/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphicArea;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class RectangleGraphic
extends AbstractDragGraphicArea {
    public static final Icon ICON = new ImageIcon(RectangleGraphic.class.getResource("/icon/22x22/draw-rectangle.png"));
    public static final Measurement TopLeftPointX = new Measurement("Top Left X", true, true, false);
    public static final Measurement TopLeftPointY = new Measurement("Top Left Y", true, true, false);
    public static final Measurement CenterX = new Measurement("Center X", true, true, false);
    public static final Measurement CenterY = new Measurement("Center Y", true, true, false);
    public static final Measurement Width = new Measurement("Width", true, true, false);
    public static final Measurement Height = new Measurement("Height", true, true, false);
    public static final Measurement Area = new Measurement("Area", true, true, true);
    public static final Measurement Perimeter = new Measurement("Perimeter", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public RectangleGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(8, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.rect");
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                point.setLocation(point.getX() + deltaX, point.getY() + deltaY);
            }
        } else {
            Rectangle2D.Double rectangle = new Rectangle2D.Double();
            rectangle.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
            double x = ((RectangularShape)rectangle).getX();
            double y = ((RectangularShape)rectangle).getY();
            double w = ((RectangularShape)rectangle).getWidth();
            double h = ((RectangularShape)rectangle).getHeight();
            eHandlePoint pt = eHandlePoint.valueFromIndex(handlePointIndex);
            if (pt.equals((Object)eHandlePoint.W) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.SW)) {
                x += deltaX;
                w -= deltaX;
            }
            if (pt.equals((Object)eHandlePoint.N) || pt.equals((Object)eHandlePoint.NW) || pt.equals((Object)eHandlePoint.NE)) {
                y += deltaY;
                h -= deltaY;
            }
            if (pt.equals((Object)eHandlePoint.E) || pt.equals((Object)eHandlePoint.NE) || pt.equals((Object)eHandlePoint.SE)) {
                w += deltaX;
            }
            if (pt.equals((Object)eHandlePoint.S) || pt.equals((Object)eHandlePoint.SW) || pt.equals((Object)eHandlePoint.SE)) {
                h += deltaY;
            }
            if (w < 0.0) {
                w = -w;
                x -= w;
                pt = pt.getVerticalMirror();
            }
            if (h < 0.0) {
                h = -h;
                y -= h;
                pt = pt.getHorizontalMirror();
            }
            handlePointIndex = pt.index;
            rectangle.setFrame(x, y, w, h);
            this.setHandlePointList(rectangle);
        }
        return handlePointIndex;
    }

    protected void setHandlePointList(Rectangle2D rectangle) {
        double x = rectangle.getX();
        double y = rectangle.getY();
        double w = rectangle.getWidth();
        double h = rectangle.getHeight();
        while (this.handlePointList.size() < this.handlePointTotalNumber) {
            this.handlePointList.add(new Point2D.Double());
        }
        ((Point2D)this.handlePointList.get(eHandlePoint.NW.index)).setLocation(new Point2D.Double(x, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.N.index)).setLocation(new Point2D.Double(x + w / 2.0, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.NE.index)).setLocation(new Point2D.Double(x + w, y));
        ((Point2D)this.handlePointList.get(eHandlePoint.E.index)).setLocation(new Point2D.Double(x + w, y + h / 2.0));
        ((Point2D)this.handlePointList.get(eHandlePoint.SE.index)).setLocation(new Point2D.Double(x + w, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.S.index)).setLocation(new Point2D.Double(x + w / 2.0, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.SW.index)).setLocation(new Point2D.Double(x, y + h));
        ((Point2D)this.handlePointList.get(eHandlePoint.W.index)).setLocation(new Point2D.Double(x, y + h / 2.0));
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseevent) {
        Rectangle2D.Double rectangle = new Rectangle2D.Double();
        if (this.handlePointList.size() > 1) {
            rectangle.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
        }
        this.setShape(rectangle, mouseevent);
        this.updateLabel(mouseevent, this.getDefaultView2d(mouseevent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() > 1 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            List<MeasureItem> stats;
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            rect.setFrameFromDiagonal((Point2D)this.handlePointList.get(eHandlePoint.NW.index), (Point2D)this.handlePointList.get(eHandlePoint.SE.index));
            double ratio = adapter.getCalibRatio();
            if (TopLeftPointX.isComputed() && (!drawOnLabel || TopLeftPointX.isGraphicLabel())) {
                val = releaseEvent || TopLeftPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(((RectangularShape)rect).getX())) : null;
                measVal.add(new MeasureItem(TopLeftPointX, val, adapter.getUnit()));
            }
            if (TopLeftPointY.isComputed() && (!drawOnLabel || TopLeftPointY.isGraphicLabel())) {
                val = releaseEvent || TopLeftPointY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(((RectangularShape)rect).getY())) : null;
                measVal.add(new MeasureItem(TopLeftPointY, val, adapter.getUnit()));
            }
            if (CenterX.isComputed() && (!drawOnLabel || CenterX.isGraphicLabel())) {
                val = releaseEvent || CenterX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(rect.getCenterX())) : null;
                measVal.add(new MeasureItem(CenterX, val, adapter.getUnit()));
            }
            if (CenterY.isComputed() && (!drawOnLabel || CenterY.isGraphicLabel())) {
                val = releaseEvent || CenterY.isQuickComputing() ? Double.valueOf(adapter.getYCalibratedValue(rect.getCenterY())) : null;
                measVal.add(new MeasureItem(CenterY, val, adapter.getUnit()));
            }
            if (Width.isComputed() && (!drawOnLabel || Width.isGraphicLabel())) {
                val = releaseEvent || Width.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getWidth()) : null;
                measVal.add(new MeasureItem(Width, val, adapter.getUnit()));
            }
            if (Height.isComputed() && (!drawOnLabel || Height.isGraphicLabel())) {
                val = releaseEvent || Height.isQuickComputing() ? Double.valueOf(ratio * ((RectangularShape)rect).getHeight()) : null;
                measVal.add(new MeasureItem(Height, val, adapter.getUnit()));
            }
            if (Area.isComputed() && (!drawOnLabel || Area.isGraphicLabel())) {
                val = releaseEvent || Area.isQuickComputing() ? Double.valueOf(((RectangularShape)rect).getWidth() * ((RectangularShape)rect).getHeight() * ratio * ratio) : null;
                String unit = "pix".equals(adapter.getUnit()) ? adapter.getUnit() : adapter.getUnit() + "2";
                measVal.add(new MeasureItem(Area, val, unit));
            }
            if ((stats = this.getImageStatistics(imageElement, releaseEvent)) != null) {
                measVal.addAll(stats);
            }
            return measVal;
        }
        return null;
    }

    protected static enum eHandlePoint {
        NONE(-1),
        NW(0),
        SE(1),
        NE(2),
        SW(3),
        N(4),
        S(5),
        E(6),
        W(7);

        final int index;
        static final Map<Integer, eHandlePoint> map;

        private eHandlePoint(int index) {
            this.index = index;
        }

        static eHandlePoint valueFromIndex(int index) {
            eHandlePoint point = map.get(index);
            if (point == null) {
                throw new RuntimeException("Not a valid index for a rectangular DragGraphic : " + index);
            }
            return point;
        }

        eHandlePoint getVerticalMirror() {
            switch (this) {
                case NW: {
                    return NE;
                }
                case NE: {
                    return NW;
                }
                case W: {
                    return E;
                }
                case E: {
                    return W;
                }
                case SW: {
                    return SE;
                }
                case SE: {
                    return SW;
                }
            }
            return this;
        }

        eHandlePoint getHorizontalMirror() {
            switch (this) {
                case NW: {
                    return SW;
                }
                case SW: {
                    return NW;
                }
                case N: {
                    return S;
                }
                case S: {
                    return N;
                }
                case NE: {
                    return SE;
                }
                case SE: {
                    return NE;
                }
            }
            return this;
        }

        static {
            map = new HashMap<Integer, eHandlePoint>(eHandlePoint.values().length);
            for (eHandlePoint corner : eHandlePoint.values()) {
                map.put(corner.index, corner);
            }
        }
    }
}

