/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class ParallelLineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(ParallelLineGraphic.class.getResource("/icon/22x22/draw-parallel.png"));
    public static final Measurement Distance = new Measurement("Distance", true, true, true);
    public static final Measurement Orientation = new Measurement("Orientation", true, true, false);
    public static final Measurement Azimuth = new Measurement("Azimuth", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public ParallelLineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(6, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Parallel";
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    protected int moveAndResizeOnDrawing(int handlePointIndex, double deltaX, double deltaY, MouseEventDouble mouseEvent) {
        if (handlePointIndex == -1) {
            for (Point2D point : this.handlePointList) {
                point.setLocation(point.getX() + deltaX, point.getY() + deltaY);
            }
        } else if (!this.isGraphicComplete()) {
            ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
            if (this.handlePointList.size() >= 4) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                Point2D D = (Point2D)this.handlePointList.get(3);
                Point2D I = GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)D);
                D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)D, (Point2D)I, (Point2D)C));
                while (this.handlePointList.size() < this.handlePointTotalNumber) {
                    this.handlePointList.add(new Point2D.Double());
                }
                Point2D E = (Point2D)this.handlePointList.get(4);
                Point2D F = (Point2D)this.handlePointList.get(5);
                E.setLocation(GeomUtil.getMidPoint((Point2D)A, (Point2D)B));
                F.setLocation(GeomUtil.getMidPoint((Point2D)C, (Point2D)D));
            }
        } else {
            Point2D A = (Point2D)this.handlePointList.get(0);
            Point2D B = (Point2D)this.handlePointList.get(1);
            Point2D C = (Point2D)this.handlePointList.get(2);
            Point2D D = (Point2D)this.handlePointList.get(3);
            Point2D E = (Point2D)this.handlePointList.get(4);
            Point2D F = (Point2D)this.handlePointList.get(5);
            if (handlePointIndex == 0 || handlePointIndex == 1) {
                Point2D anchor = handlePointIndex == 0 ? B : A;
                double theta = GeomUtil.getAngleRad((Point2D)A, (Point2D)B);
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
                AffineTransform transform = AffineTransform.getRotateInstance(theta -= GeomUtil.getAngleRad((Point2D)A, (Point2D)B), anchor.getX(), anchor.getY());
                transform.transform(C, C);
                transform.transform(D, D);
            } else {
                ((Point2D)this.handlePointList.get(handlePointIndex)).setLocation(mouseEvent.getImageCoordinates());
                if (handlePointIndex == 2) {
                    Point2D J = GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)D);
                    D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)D, (Point2D)J, (Point2D)C));
                } else if (handlePointIndex == 3) {
                    Point2D I = GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C);
                    C.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)C, (Point2D)I, (Point2D)D));
                } else if (handlePointIndex == 4) {
                    Point2D I = GeomUtil.getPerpendicularPointToLine((Point2D)C, (Point2D)D, (Point2D)A);
                    Point2D J = GeomUtil.getPerpendicularPointToLine((Point2D)C, (Point2D)D, (Point2D)B);
                    A.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)I, (Point2D)E));
                    B.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)B, (Point2D)J, (Point2D)E));
                } else if (handlePointIndex == 5) {
                    Point2D I = GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C);
                    Point2D J = GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)D);
                    C.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)C, (Point2D)I, (Point2D)F));
                    D.setLocation(GeomUtil.getPerpendicularPointToLine((Point2D)D, (Point2D)J, (Point2D)F));
                }
            }
            E.setLocation(GeomUtil.getMidPoint((Point2D)A, (Point2D)B));
            F.setLocation(GeomUtil.getMidPoint((Point2D)C, (Point2D)D));
        }
        return handlePointIndex;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        GeneralPath generalpath = new GeneralPath(1, this.handlePointList.size());
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                generalpath.moveTo(A.getX(), A.getY());
                generalpath.lineTo(B.getX(), B.getY());
                if (this.handlePointList.size() >= 3) {
                    Point2D C = (Point2D)this.handlePointList.get(2);
                    if (this.handlePointList.size() >= 4) {
                        Point2D D = (Point2D)this.handlePointList.get(3);
                        generalpath.moveTo(C.getX(), C.getY());
                        generalpath.lineTo(D.getX(), D.getY());
                    }
                }
            }
        }
        this.setShape(generalpath, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 4 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            Point2D A = (Point2D)this.handlePointList.get(0);
            Point2D B = (Point2D)this.handlePointList.get(1);
            Point2D C = (Point2D)this.handlePointList.get(2);
            if (Distance.isComputed() && (!drawOnLabel || Distance.isGraphicLabel())) {
                val = releaseEvent || Distance.isQuickComputing() ? Double.valueOf(C.distance(GeomUtil.getPerpendicularPointToLine((Point2D)A, (Point2D)B, (Point2D)C)) * adapter.getCalibRatio()) : null;
                measVal.add(new MeasureItem(Distance, val, adapter.getUnit()));
            }
            if (Orientation.isComputed() && (!drawOnLabel || Orientation.isGraphicLabel())) {
                val = releaseEvent || Orientation.isQuickComputing() ? this.getSegmentOrientation() : null;
                measVal.add(new MeasureItem(Orientation, val, "deg"));
            }
            if (Azimuth.isComputed() && (!drawOnLabel || Azimuth.isGraphicLabel())) {
                val = releaseEvent || Azimuth.isQuickComputing() ? this.getSegmentAzimuth() : null;
                measVal.add(new MeasureItem(Azimuth, val, "deg"));
            }
            return measVal;
        }
        return null;
    }

    public Double getSegmentOrientation() {
        if (this.handlePointList.size() >= 1) {
            Point2D p1 = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D p2 = (Point2D)this.handlePointList.get(1);
                return MathUtil.getOrientation((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
            }
        }
        return null;
    }

    public Double getSegmentAzimuth() {
        if (this.handlePointList.size() >= 1) {
            Point2D p1 = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D p2 = (Point2D)this.handlePointList.get(1);
                return MathUtil.getAzimuth((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
            }
        }
        return null;
    }

    @Override
    public ParallelLineGraphic clone() {
        return (ParallelLineGraphic)super.clone();
    }

    @Override
    public Graphic clone(double xPos, double yPos) {
        ParallelLineGraphic newGraphic = this.clone();
        newGraphic.updateShapeOnDrawing(null);
        return newGraphic;
    }
}

