/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class LineGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(LineGraphic.class.getResource("/icon/22x22/draw-line.png"));
    public static final Measurement FirstPointX = new Measurement("First point X", true, true, false);
    public static final Measurement FirstPointY = new Measurement("First point Y", true, true, false);
    public static final Measurement LastPointX = new Measurement("Last point X", true, true, false);
    public static final Measurement LastPointY = new Measurement("Last point Y", true, true, false);
    public static final Measurement LineLength = new Measurement("Line length", true, true, true);
    public static final Measurement Orientation = new Measurement("Orientation", true, true, false);
    public static final Measurement Azimuth = new Measurement("Azimuth", true, true, false);
    public static final Measurement ColorRGB = new Measurement("Color (RGB)", true, true, false);

    public LineGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(2, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return Messages.getString("MeasureToolBar.line");
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        GeneralPath generalpath = new GeneralPath(1, this.handlePointList.size());
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            generalpath.moveTo(A.getX(), A.getY());
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                generalpath.lineTo(B.getX(), B.getY());
            }
        }
        this.setShape(generalpath, mouseEvent);
        this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
    }

    @Override
    public LineGraphic clone() {
        return (LineGraphic)super.clone();
    }

    @Override
    public Graphic clone(double xPos, double yPos) {
        LineGraphic newGraphic = this.clone();
        newGraphic.updateShapeOnDrawing(null);
        return newGraphic;
    }

    public Double getSegmentLength(double scalex, double scaley) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                Point2D B = (Point2D)this.handlePointList.get(1);
                return Point2D.distance(scalex * A.getX(), scaley * A.getY(), scalex * B.getX(), scaley * B.getY());
            }
        }
        return null;
    }

    public Double getSegmentOrientation() {
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        if (p1 == null || p2 == null) {
            return null;
        }
        return MathUtil.getOrientation((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
    }

    public Double getSegmentAzimuth() {
        Point2D p1 = this.getStartPoint();
        Point2D p2 = this.getEndPoint();
        if (p1 == null || p2 == null) {
            return null;
        }
        return MathUtil.getAzimuth((double)p1.getX(), (double)p1.getY(), (double)p2.getX(), (double)p2.getY());
    }

    public Point2D getStartPoint() {
        if (this.handlePointList.size() >= 1) {
            return (Point2D)((Point2D)this.handlePointList.get(0)).clone();
        }
        return null;
    }

    public Point2D getEndPoint() {
        if (this.handlePointList.size() > 1) {
            return (Point2D)((Point2D)this.handlePointList.get(1)).clone();
        }
        return null;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 2 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            Double val;
            Double val2;
            Point2D p;
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (FirstPointX.isComputed() || FirstPointY.isComputed()) {
                p = this.getStartPoint();
                if (FirstPointX.isComputed() && (!drawOnLabel || FirstPointX.isGraphicLabel())) {
                    val2 = releaseEvent || FirstPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getX())) : null;
                    measVal.add(new MeasureItem(FirstPointX, val2, adapter.getUnit()));
                }
                if (FirstPointY.isComputed() && (!drawOnLabel || FirstPointY.isGraphicLabel())) {
                    val2 = releaseEvent || FirstPointY.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getY())) : null;
                    measVal.add(new MeasureItem(FirstPointY, val2, adapter.getUnit()));
                }
            }
            if (LastPointX.isComputed() || LastPointY.isComputed()) {
                p = this.getEndPoint();
                if (LastPointX.isComputed() && (!drawOnLabel || LastPointX.isGraphicLabel())) {
                    val2 = releaseEvent || LastPointX.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getX())) : null;
                    measVal.add(new MeasureItem(LastPointX, val2, adapter.getUnit()));
                }
                if (LastPointY.isComputed() && (!drawOnLabel || LastPointY.isGraphicLabel())) {
                    val2 = releaseEvent || LastPointY.isQuickComputing() ? Double.valueOf(adapter.getXCalibratedValue(p.getY())) : null;
                    measVal.add(new MeasureItem(LastPointY, val2, adapter.getUnit()));
                }
            }
            if (LineLength.isComputed() && (!drawOnLabel || LineLength.isGraphicLabel())) {
                val = releaseEvent || LineLength.isQuickComputing() ? this.getSegmentLength(adapter.getCalibRatio(), adapter.getCalibRatio()) : null;
                measVal.add(new MeasureItem(LineLength, val, adapter.getUnit()));
            }
            if (Orientation.isComputed() && (!drawOnLabel || Orientation.isGraphicLabel())) {
                val = releaseEvent || Orientation.isQuickComputing() ? this.getSegmentOrientation() : null;
                measVal.add(new MeasureItem(Orientation, val, "deg"));
            }
            if (Azimuth.isComputed() && (!drawOnLabel || Azimuth.isGraphicLabel())) {
                val = releaseEvent || Azimuth.isQuickComputing() ? this.getSegmentAzimuth() : null;
                measVal.add(new MeasureItem(Azimuth, val, "deg"));
            }
            return measVal;
        }
        return null;
    }
}

