/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.MathUtil;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.graphic.AbstractDragGraphicOld;
import org.weasis.core.ui.graphic.AngleToolGraphic;
import org.weasis.core.ui.graphic.DragSequence;
import org.weasis.core.ui.graphic.Graphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.util.MouseEventDouble;

public class FreeHandGraphic
extends AbstractDragGraphicOld
implements Cloneable {
    private static final long serialVersionUID = 5814470994233416436L;
    public static final Icon ICON = new ImageIcon(AngleToolGraphic.class.getResource("/icon/22x22/draw-angle.png"));
    private transient GeneralPath generalPath;
    protected float[] points;
    protected int numPoints;
    protected boolean closed;
    private final boolean linePath;

    public FreeHandGraphic(float lineThickness, Color paint, boolean fill, boolean linePath) {
        this.setShape(new GeneralPath(), null);
        this.setPaint(paint);
        this.lineThickness = lineThickness;
        this.linePath = linePath;
        this.numPoints = 2;
        this.points = new float[this.numPoints * 2];
        this.points[0] = 0.0f;
        this.points[1] = 0.0f;
        this.points[2] = 0.0f;
        this.points[3] = 100.0f;
        this.closed = false;
        this.setFilled(fill);
        this.updateStroke();
        this.updateShapeOnDrawing(null);
    }

    public void setClosed(boolean flag) {
        this.closed = flag;
        this.updateShape();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isLinePath() {
        return this.linePath;
    }

    @Override
    public Area getArea() {
        Area area = new Area(this.getShape());
        if (area.isEmpty()) {
            float x1 = this.points[0];
            float y1 = this.points[1];
            float x2 = this.points[0];
            float y2 = this.points[1];
            for (int m = 2; m < this.points.length; m += 2) {
                if (this.points[m] < x1) {
                    x1 = this.points[m];
                }
                if (this.points[m + 1] < y1) {
                    y1 = this.points[m + 1];
                }
                if (this.points[m] > x2) {
                    x2 = this.points[m];
                }
                if (!(this.points[m + 1] > y2)) continue;
                y2 = this.points[m + 1];
            }
            area = FreeHandGraphic.createAreaForLine(x1, y1, x2, y2, (int)this.lineThickness);
        }
        return area;
    }

    public static Area createAreaForLine(float x1, float y1, float x2, float y2, int width) {
        int i = width;
        int j = 0;
        int or = (int)MathUtil.getOrientation((double)x1, (double)y1, (double)x2, (double)y2);
        if (or < 45 || or > 135) {
            j = i;
            i = 0;
        }
        GeneralPath generalpath = new GeneralPath();
        generalpath.moveTo(x1 - (float)i, y1 - (float)j);
        generalpath.lineTo(x1 + (float)i, y1 + (float)j);
        generalpath.lineTo(x2 + (float)i, y2 + (float)j);
        generalpath.lineTo(x2 - (float)i, y2 - (float)j);
        generalpath.lineTo(x1 - (float)i, y1 - (float)j);
        generalpath.closePath();
        return new Area(generalpath);
    }

    @Override
    public void paintHandles(Graphics2D graphics2d, AffineTransform transform) {
        if (this.closed) {
            super.paintHandles(graphics2d, transform);
        }
    }

    @Override
    protected int resizeOnDrawing(int point, int j, int k, MouseEvent mouseevent) {
        return -2;
    }

    @Override
    public int getResizeCorner(MouseEvent mouseevent) {
        return -1;
    }

    @Override
    protected void updateShapeOnDrawing(MouseEvent mouseevent) {
        this.generalPath = new GeneralPath();
        this.generalPath.reset();
        this.generalPath.moveTo(this.points[0], this.points[1]);
        int j = this.numPoints * 2;
        for (int i = 2; i < j; ++i) {
            this.generalPath.lineTo(this.points[i], this.points[++i]);
        }
        if (this.isClosed() && !this.linePath) {
            this.generalPath.closePath();
        }
        this.setShape(this.generalPath, mouseevent);
    }

    @Override
    protected void updateShape() {
        super.updateShape();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        FreeHandGraphic freeGraphic = (FreeHandGraphic)super.clone();
        return freeGraphic;
    }

    @Override
    public Graphic clone(int i, int j) {
        FreeHandGraphic freeGraphic;
        try {
            freeGraphic = (FreeHandGraphic)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        freeGraphic.points = new float[4];
        freeGraphic.numPoints = 2;
        freeGraphic.points[0] = freeGraphic.points[2] = (float)i;
        freeGraphic.points[1] = freeGraphic.points[3] = (float)j;
        freeGraphic.updateStroke();
        freeGraphic.updateShapeOnDrawing(null);
        return freeGraphic;
    }

    @Override
    public void move(int i, int j, int k, MouseEvent mouseevent) {
        Point p = this.needToMoveCanvas(j, k);
        if (p != null) {
            j = p.x;
            k = p.y;
            super.move(i, j, k, mouseevent);
        }
        for (int m = 0; m < this.points.length; m += 2) {
            int n = m;
            this.points[n] = this.points[n] + (float)j;
            int n2 = m + 1;
            this.points[n2] = this.points[n2] + (float)k;
        }
    }

    @Override
    public void updateLabel(Object source, DefaultView2d view2d) {
    }

    @Override
    protected DragSequence createResizeDrag(MouseEvent mouseevent, int i) {
        return new FreeDragSequence(mouseevent == null, i);
    }

    public float getFirstX() {
        return this.points[0];
    }

    public float getFirstY() {
        return this.points[1];
    }

    public float getLastX() {
        return this.points[this.points.length - 2];
    }

    public float getLastY() {
        return this.points[this.points.length - 1];
    }

    public Icon getIcon() {
        return null;
    }

    public String getUIName() {
        return Messages.getString("FreeHandGraphic.title");
    }

    public String getDescription() {
        return null;
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        return null;
    }

    protected class FreeDragSequence
    extends AbstractDragGraphicOld.DefaultDragSequence {
        @Override
        public void startDrag(MouseEventDouble mouseevent) {
            super.startDrag(mouseevent);
            if (FreeHandGraphic.this.createPoints) {
                FreeHandGraphic.this.closed = false;
            }
        }

        @Override
        public void drag(MouseEventDouble mouseevent) {
            int tx = mouseevent.getX() - this.getLastX();
            int ty = mouseevent.getY() - this.getLastY();
            if (tx != 0 || ty != 0) {
                if (FreeHandGraphic.this.createPoints) {
                    int i = FreeHandGraphic.this.numPoints + FreeHandGraphic.this.numPoints;
                    Point p = FreeHandGraphic.this.needToMoveCanvas(tx, ty);
                    if (p != null) {
                        tx = p.x;
                        ty = p.y;
                        FreeHandGraphic.super.move(0, tx, ty, mouseevent);
                    }
                    float[] af = new float[i + 2];
                    System.arraycopy(FreeHandGraphic.this.points, 0, af, 0, i);
                    af[i] = af[i - 2] + (float)tx;
                    af[i + 1] = af[i - 1] + (float)ty;
                    ++FreeHandGraphic.this.numPoints;
                    FreeHandGraphic.this.points = af;
                    FreeHandGraphic.this.updateShapeOnDrawing(mouseevent);
                    this.update(mouseevent);
                } else {
                    this.update(mouseevent);
                }
            }
        }

        @Override
        public boolean completeDrag(MouseEventDouble mouseevent) {
            if (FreeHandGraphic.this.createPoints) {
                if (FreeHandGraphic.this.numPoints > 2) {
                    int pointToRemove;
                    int n = pointToRemove = FreeHandGraphic.this.points[0] == FreeHandGraphic.this.points[2] && FreeHandGraphic.this.points[1] == FreeHandGraphic.this.points[3] ? 2 : 0;
                    if (pointToRemove > 0) {
                        int j = FreeHandGraphic.this.numPoints + FreeHandGraphic.this.numPoints - 2;
                        float[] af1 = new float[j];
                        System.arraycopy(FreeHandGraphic.this.points, 2, af1, 0, j);
                        --FreeHandGraphic.this.numPoints;
                        FreeHandGraphic.this.points = af1;
                    }
                }
                if (!FreeHandGraphic.this.linePath || FreeHandGraphic.this.numPoints == 2) {
                    FreeHandGraphic.this.points[0] = FreeHandGraphic.this.points[0] == FreeHandGraphic.this.points[2] ? FreeHandGraphic.this.points[0] - 1.0f : FreeHandGraphic.this.points[0];
                    FreeHandGraphic.this.points[1] = FreeHandGraphic.this.points[1] == FreeHandGraphic.this.points[3] ? FreeHandGraphic.this.points[1] - 1.0f : FreeHandGraphic.this.points[1];
                }
                FreeHandGraphic.this.closed = true;
                FreeHandGraphic.this.updateShapeOnDrawing(mouseevent);
                FreeHandGraphic.this.updateShape();
                FreeHandGraphic.this.createPoints = false;
            }
            this.update(mouseevent);
            return true;
        }

        protected FreeDragSequence(boolean flag, int i) {
            super(flag, -1);
        }
    }
}

