/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.weasis.core.api.gui.util.GeomUtil;
import org.weasis.core.api.image.measure.MeasurementsAdapter;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.ui.graphic.AbstractDragGraphic;
import org.weasis.core.ui.graphic.MeasureItem;
import org.weasis.core.ui.graphic.Measurement;
import org.weasis.core.ui.util.MouseEventDouble;

public class FourPointsAngleToolGraphic
extends AbstractDragGraphic {
    public static final Icon ICON = new ImageIcon(FourPointsAngleToolGraphic.class.getResource("/icon/22x22/draw-4p-angle.png"));
    public static final Measurement Angle = new Measurement("Angle", true);
    public static final Measurement ComplementaryAngle = new Measurement("Compl. Angle", true);
    public static final double ARC_RADIUS = 24.0;

    public FourPointsAngleToolGraphic(float lineThickness, Color paintColor, boolean labelVisible) {
        super(8, paintColor, lineThickness, labelVisible);
    }

    public Icon getIcon() {
        return ICON;
    }

    public String getUIName() {
        return "Four Points Angle Tool";
    }

    @Override
    protected void updateShapeOnDrawing(MouseEventDouble mouseEvent) {
        if (this.handlePointList.size() >= 1) {
            Point2D A = (Point2D)this.handlePointList.get(0);
            if (this.handlePointList.size() >= 2) {
                AbstractDragGraphic.AdvancedShape newShape = new AbstractDragGraphic.AdvancedShape(4);
                Path2D.Double generalpath = new Path2D.Double(1, this.handlePointList.size());
                newShape.addShape(generalpath);
                Point2D B = (Point2D)this.handlePointList.get(1);
                ((Path2D)generalpath).moveTo(A.getX(), A.getY());
                ((Path2D)generalpath).lineTo(B.getX(), B.getY());
                Point2D I = GeomUtil.getMidPoint((Point2D)A, (Point2D)B);
                if (this.handlePointList.size() >= 3) {
                    Point2D J;
                    Point2D C = (Point2D)this.handlePointList.get(2);
                    if (this.handlePointList.size() < 4) {
                        J = C;
                    } else {
                        Point2D D = (Point2D)this.handlePointList.get(3);
                        ((Path2D)generalpath).moveTo(C.getX(), C.getY());
                        ((Path2D)generalpath).lineTo(D.getX(), D.getY());
                        J = GeomUtil.getMidPoint((Point2D)C, (Point2D)D);
                        if (this.handlePointList.size() >= 5) {
                            Point2D E = (Point2D)this.handlePointList.get(4);
                            if (this.handlePointList.size() >= 6) {
                                Point2D L;
                                Point2D F = (Point2D)this.handlePointList.get(5);
                                ((Path2D)generalpath).moveTo(E.getX(), E.getY());
                                ((Path2D)generalpath).lineTo(F.getX(), F.getY());
                                Point2D K = GeomUtil.getMidPoint((Point2D)E, (Point2D)F);
                                if (this.handlePointList.size() < 7) {
                                    L = GeomUtil.getPerpendicularPointFromLine((Point2D)E, (Point2D)F, (Point2D)K, (double)1.0);
                                } else {
                                    Point2D G = (Point2D)this.handlePointList.get(6);
                                    if (this.handlePointList.size() < 8) {
                                        L = G;
                                    } else {
                                        Point2D H = (Point2D)this.handlePointList.get(7);
                                        ((Path2D)generalpath).moveTo(G.getX(), G.getY());
                                        ((Path2D)generalpath).lineTo(H.getX(), H.getY());
                                        L = GeomUtil.getMidPoint((Point2D)G, (Point2D)H);
                                    }
                                    generalpath.append(new Line2D.Double(K, L), false);
                                }
                                Point2D P = GeomUtil.getIntersectPoint((Point2D)I, (Point2D)J, (Point2D)K, (Point2D)L);
                                if (P != null) {
                                    newShape.addShape(new Line2D.Double(J, P), this.getDashStroke(1.0f), true);
                                    newShape.addShape(new Line2D.Double(K, P), this.getDashStroke(1.0f), true);
                                    double startingAngle = GeomUtil.getAngleDeg((Point2D)P, (Point2D)J);
                                    double angularExtent = GeomUtil.getAngleDeg((Point2D)J, (Point2D)P, (Point2D)K);
                                    angularExtent = GeomUtil.getSmallestRotationAngleDeg((double)angularExtent);
                                    double radius = 24.0;
                                    Rectangle2D.Double arcAngleBounds = new Rectangle2D.Double(P.getX() - radius, P.getY() - radius, 2.0 * radius, 2.0 * radius);
                                    Arc2D.Double arcAngle = new Arc2D.Double(arcAngleBounds, startingAngle, angularExtent, 0);
                                    double rMax = Math.min(P.distance(I), P.distance(J));
                                    rMax = 0.6666666666666666 * Math.min(rMax, Math.min(P.distance(K), P.distance(L)));
                                    newShape.addInvShape(arcAngle, (Point2D)P.clone(), radius / rMax, this.getDashStroke(1.0f), true);
                                }
                            }
                        }
                    }
                    generalpath.append(new Line2D.Double(I, J), false);
                }
                this.setShape(newShape, mouseEvent);
                this.updateLabel(mouseEvent, this.getDefaultView2d(mouseEvent));
            }
        }
    }

    @Override
    public List<MeasureItem> getMeasurements(ImageElement imageElement, boolean releaseEvent, boolean drawOnLabel) {
        MeasurementsAdapter adapter;
        if (imageElement != null && this.handlePointList.size() >= 8 && (adapter = imageElement.getMeasurementAdapter()) != null) {
            ArrayList<MeasureItem> measVal = new ArrayList<MeasureItem>();
            if (Angle.isComputed()) {
                Point2D A = (Point2D)this.handlePointList.get(0);
                Point2D B = (Point2D)this.handlePointList.get(1);
                Point2D C = (Point2D)this.handlePointList.get(2);
                Point2D D = (Point2D)this.handlePointList.get(3);
                Point2D E = (Point2D)this.handlePointList.get(4);
                Point2D F = (Point2D)this.handlePointList.get(5);
                Point2D G = (Point2D)this.handlePointList.get(6);
                Point2D H = (Point2D)this.handlePointList.get(7);
                Point2D I = GeomUtil.getMidPoint((Point2D)A, (Point2D)B);
                Point2D J = GeomUtil.getMidPoint((Point2D)C, (Point2D)D);
                Point2D K = GeomUtil.getMidPoint((Point2D)E, (Point2D)F);
                Point2D L = GeomUtil.getMidPoint((Point2D)G, (Point2D)H);
                Point2D P = GeomUtil.getIntersectPoint((Point2D)I, (Point2D)J, (Point2D)K, (Point2D)L);
                double realAngle = Math.abs(GeomUtil.getSmallestRotationAngleDeg((double)GeomUtil.getAngleDeg((Point2D)J, (Point2D)P, (Point2D)K)));
                if (Angle.isComputed() && (!drawOnLabel || Angle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(Angle, realAngle, "deg"));
                }
                if (ComplementaryAngle.isComputed() && (!drawOnLabel || ComplementaryAngle.isGraphicLabel())) {
                    measVal.add(new MeasureItem(ComplementaryAngle, 180.0 - realAngle, "deg"));
                }
            }
            return measVal;
        }
        return null;
    }
}

