/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.graphic;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Stack;
import java.util.Vector;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import org.weasis.core.ui.graphic.Contour;
import org.weasis.core.ui.graphic.model.AbstractLayerModel;

public class BlobAnalyse2D {
    private PlanarImage source;
    private RandomIter src;
    Rectangle imgbound;
    private final Point firstPoint;
    private boolean[][] visited;
    private final int dwidth;
    private final int dheight;
    private ArrayList<Point> blob = null;
    private Shape shape;
    private int area;

    public BlobAnalyse2D(Shape shape) {
        this.shape = shape;
        this.area = 0;
        this.source = AbstractLayerModel.getGraphicAsImage(shape);
        this.imgbound = this.source.getBounds();
        this.src = RandomIterFactory.create((RenderedImage)this.source, null);
        this.dwidth = this.source.getWidth();
        this.dheight = this.source.getHeight();
        this.firstPoint = new Point();
        this.iniToVisited(this.src, 0);
    }

    public BlobAnalyse2D(PlanarImage binary) {
        this.area = 0;
        this.source = binary;
        this.imgbound = binary.getBounds();
        this.src = RandomIterFactory.create((RenderedImage)binary, null);
        this.dwidth = binary.getWidth();
        this.dheight = binary.getHeight();
        this.firstPoint = new Point();
    }

    protected void finalize() throws Throwable {
        this.shape = null;
        this.src.done();
        this.src = null;
        this.source.dispose();
        this.source = null;
        super.finalize();
    }

    private void iniToVisited(RandomIter data, int val) {
        int[] pix = new int[]{0};
        this.visited = new boolean[this.dheight][this.dwidth];
        for (int j = 0; j < this.dheight; ++j) {
            for (int i = 0; i < this.dwidth; ++i) {
                data.getPixel(i + this.imgbound.x, j + this.imgbound.y, pix);
                if (pix[0] != val) continue;
                this.visited[j][i] = true;
            }
        }
    }

    public Contour getContour() {
        for (int j = 0; j < this.dheight; ++j) {
            for (int i = 0; i < this.dwidth; ++i) {
                if (this.visited[j][i]) continue;
                int area = this.getArea();
                Contour contour = new Contour(this.shape.getBounds().x + i, this.shape.getBounds().y + j, this.chain8(i, j), area, BlobAnalyse2D.getStatValue(this.blob));
                return contour;
            }
        }
        return null;
    }

    public Vector<Contour> getHolesContour() {
        Vector<Contour> holes = new Vector<Contour>();
        this.iniToVisited(this.src, 0);
        int[] area = new int[]{0};
        for (int m = 0; m < this.dheight; ++m) {
            for (int n = 0; n < this.dwidth; ++n) {
                if (this.visited[m][n] || this.growingBHoleSize(n, m, area)) continue;
                byte[] holeChain = this.chainHole8(n, m - 1);
                Contour contour = new Contour(this.shape.getBounds().x + n, this.shape.getBounds().y + m - 1, holeChain, area[0], null);
                holes.add(contour);
            }
        }
        holes.trimToSize();
        holes = holes.size() == 0 ? null : holes;
        return holes;
    }

    private byte[] chainHole8(int x, int y) {
        int[] dx = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int[] dy = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        Byte direction = null;
        int row = y;
        int col = x;
        int lastdir = 6;
        Vector<Byte> chain = new Vector<Byte>();
        int[] pix = new int[]{0};
        this.src.getPixel(x, y, pix);
        int val = pix[0];
        do {
            boolean foundPix = false;
            for (int i = lastdir + 1; i < lastdir + 8; ++i) {
                byte dirTemp = (byte)(i % 8);
                int xp4 = dx[dirTemp] + col;
                int yp4 = dy[dirTemp] + row;
                if (xp4 < 0 || xp4 >= this.dwidth || yp4 < 0 || yp4 >= this.dheight) continue;
                this.src.getPixel(xp4, yp4, pix);
                if (pix[0] != val) continue;
                direction = dirTemp;
                foundPix = true;
                break;
            }
            if (!foundPix) break;
            chain.addElement(direction);
            lastdir = (direction + 5) % 8;
        } while ((row += dy[direction.intValue()]) != y || (col += dx[direction.intValue()]) != x);
        byte[] tab2 = new byte[chain.size()];
        for (int i = 0; i < tab2.length; ++i) {
            tab2[i] = (Byte)chain.get(i);
        }
        return tab2;
    }

    private boolean growingBHoleSize(int i, int j, int[] area) {
        Stack<Integer[]> stack = new Stack<Integer[]>();
        area[0] = 1;
        boolean borderHit = false;
        if (i == 0 || i == this.dwidth - 1 || j == 0 || j == this.dheight - 1) {
            borderHit = true;
        }
        this.visited[j][i] = true;
        stack.push(new Integer[]{i, j});
        while (!stack.empty()) {
            Integer[] ai = (Integer[])stack.pop();
            int x = ai[0];
            int y = ai[1];
            int xp1 = x;
            int yp1 = y - 1;
            if (xp1 >= 0 && xp1 < this.dwidth && yp1 >= 0 && yp1 < this.dheight && !this.visited[yp1][xp1]) {
                if (xp1 == 0 || xp1 == this.dwidth - 1 || yp1 == 0 || yp1 == this.dheight - 1) {
                    borderHit = true;
                } else {
                    area[0] = area[0] + 1;
                }
                this.visited[yp1][xp1] = true;
                stack.push(new Integer[]{xp1, yp1});
            }
            int xp2 = x;
            int yp2 = y + 1;
            if (xp2 >= 0 && xp2 < this.dwidth && yp2 >= 0 && yp2 < this.dheight && !this.visited[yp2][xp2]) {
                if (xp2 == 0 || xp2 == this.dwidth - 1 || yp2 == 0 || yp2 == this.dheight - 1) {
                    borderHit = true;
                } else {
                    area[0] = area[0] + 1;
                }
                this.visited[yp2][xp2] = true;
                stack.push(new Integer[]{xp2, yp2});
            }
            int xp3 = x + 1;
            int yp3 = y;
            if (xp3 >= 0 && xp3 < this.dwidth && yp3 >= 0 && yp3 < this.dheight && !this.visited[yp3][xp3]) {
                if (xp3 == 0 || xp3 == this.dwidth - 1 || yp3 == 0 || yp3 == this.dheight - 1) {
                    borderHit = true;
                } else {
                    area[0] = area[0] + 1;
                }
                this.visited[yp3][xp3] = true;
                stack.push(new Integer[]{xp3, yp3});
            }
            int xp4 = x - 1;
            int yp4 = y;
            if (xp4 < 0 || xp4 >= this.dwidth || yp4 < 0 || yp4 >= this.dheight || this.visited[yp4][xp4]) continue;
            if (xp4 == 0 || xp4 == this.dwidth - 1 || yp4 == 0 || yp4 == this.dheight - 1) {
                borderHit = true;
            } else {
                area[0] = area[0] + 1;
            }
            this.visited[yp4][xp4] = true;
            stack.push(new Integer[]{xp4, yp4});
        }
        return borderHit;
    }

    public int getArea() {
        if (this.blob == null) {
            for (int j = 0; j < this.dheight; ++j) {
                for (int i = 0; i < this.dwidth; ++i) {
                    if (this.visited[j][i]) continue;
                    this.firstPoint.x = i;
                    this.firstPoint.y = j;
                    this.area = this.growingSize(i, j);
                    return this.area;
                }
            }
        }
        return this.area;
    }

    public double getPerimeter() {
        this.getArea();
        return BlobAnalyse2D.computePerimeter(this.chain8(this.firstPoint.x, this.firstPoint.y));
    }

    public static double computePerimeter(byte[] chain) {
        double perimeter = 0.0;
        int corner = 0;
        int evenCode = 0;
        int oddCode = 0;
        if (chain.length == 0) {
            perimeter = 2.0;
            return 2.0;
        }
        if (chain[0] % 2 != 0) {
            ++oddCode;
        } else {
            ++evenCode;
        }
        for (int i = 1; i < chain.length; ++i) {
            byte code = chain[i];
            if (code % 2 != 0) {
                ++oddCode;
            } else {
                ++evenCode;
            }
            if (code == chain[i - 1]) continue;
            ++corner;
        }
        perimeter = 0.98 * (double)evenCode + 1.406 * (double)oddCode - 0.091 * (double)corner;
        return perimeter;
    }

    public ArrayList<Point> getBlobSumCoorXY() {
        this.getArea();
        return this.blob;
    }

    private byte[] chain8(int x, int y) {
        int[] dx = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
        int[] dy = new int[]{0, -1, -1, -1, 0, 1, 1, 1};
        Byte direction = null;
        int row = y += this.imgbound.y;
        int col = x += this.imgbound.x;
        int lastdir = 4;
        Vector<Byte> chain = new Vector<Byte>();
        int maxX = this.imgbound.x + this.imgbound.width;
        int maxY = this.imgbound.y + this.imgbound.height;
        int[] pix = new int[]{0};
        this.src.getPixel(x, y, pix);
        int val = pix[0];
        do {
            boolean foundPix = false;
            for (int i = lastdir + 1; i < lastdir + 8; ++i) {
                int dirTemp = i % 8;
                int xp4 = dx[dirTemp] + col;
                int yp4 = dy[dirTemp] + row;
                if (xp4 < this.imgbound.x || xp4 >= maxX || yp4 < this.imgbound.y || yp4 >= maxY) continue;
                this.src.getPixel(xp4, yp4, pix);
                if (pix[0] != val) continue;
                direction = (byte)dirTemp;
                foundPix = true;
                break;
            }
            if (!foundPix) break;
            chain.addElement(direction);
            lastdir = (direction + 5) % 8;
        } while ((row += dy[direction.intValue()]) != y || (col += dx[direction.intValue()]) != x);
        byte[] tab = new byte[chain.size()];
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = (Byte)chain.get(i);
        }
        return tab;
    }

    int growingSize(int i, int j) {
        this.blob = new ArrayList();
        Stack<Point> stack = new Stack<Point>();
        int size = 1;
        Point startp = new Point(i, j);
        this.blob.add(startp);
        this.visited[j][i] = true;
        stack.push(startp);
        while (!stack.empty()) {
            Point lp = (Point)stack.pop();
            int xp1 = lp.x;
            int yp1 = lp.y - 1;
            if (xp1 >= 0 && xp1 < this.dwidth && yp1 >= 0 && yp1 < this.dheight && !this.visited[yp1][xp1]) {
                Point p = new Point(xp1, yp1);
                this.blob.add(p);
                ++size;
                this.visited[yp1][xp1] = true;
                stack.push(p);
            }
            int xp2 = lp.x;
            int yp2 = lp.y + 1;
            if (xp2 >= 0 && xp2 < this.dwidth && yp2 >= 0 && yp2 < this.dheight && !this.visited[yp2][xp2]) {
                Point p = new Point(xp2, yp2);
                this.blob.add(p);
                ++size;
                this.visited[yp2][xp2] = true;
                stack.push(p);
            }
            int xp3 = lp.x + 1;
            int yp3 = lp.y;
            if (xp3 >= 0 && xp3 < this.dwidth && yp3 >= 0 && yp3 < this.dheight && !this.visited[yp3][xp3]) {
                Point p = new Point(xp3, yp3);
                this.blob.add(p);
                ++size;
                this.visited[yp3][xp3] = true;
                stack.push(p);
            }
            int xp4 = lp.x - 1;
            int yp4 = lp.y;
            if (xp4 >= 0 && xp4 < this.dwidth && yp4 >= 0 && yp4 < this.dheight && !this.visited[yp4][xp4]) {
                Point p = new Point(xp4, yp4);
                this.blob.add(p);
                ++size;
                this.visited[yp4][xp4] = true;
                stack.push(p);
            }
            int xp5 = lp.x + 1;
            int yp5 = lp.y - 1;
            if (xp5 >= 0 && xp5 < this.dwidth && yp5 >= 0 && yp5 < this.dheight && !this.visited[yp5][xp5]) {
                Point p = new Point(xp5, yp5);
                this.blob.add(p);
                ++size;
                this.visited[yp5][xp5] = true;
                stack.push(p);
            }
            int xp6 = lp.x - 1;
            int yp6 = lp.y + 1;
            if (xp6 >= 0 && xp6 < this.dwidth && yp6 >= 0 && yp6 < this.dheight && !this.visited[yp6][xp6]) {
                Point p = new Point(xp6, yp6);
                this.blob.add(p);
                ++size;
                this.visited[yp6][xp6] = true;
                stack.push(p);
            }
            int xp7 = lp.x + 1;
            int yp7 = lp.y + 1;
            if (xp7 >= 0 && xp7 < this.dwidth && yp7 >= 0 && yp7 < this.dheight && !this.visited[yp7][xp7]) {
                Point p = new Point(xp7, yp7);
                this.blob.add(p);
                ++size;
                this.visited[yp7][xp7] = true;
                stack.push(p);
            }
            int xp8 = lp.x - 1;
            int yp8 = lp.y - 1;
            if (xp8 < 0 || xp8 >= this.dwidth || yp8 < 0 || yp8 >= this.dheight || this.visited[yp8][xp8]) continue;
            Point p = new Point(xp8, yp8);
            this.blob.add(p);
            ++size;
            this.visited[yp8][xp8] = true;
            stack.push(p);
        }
        return size;
    }

    public static ArrayList<Double> getStatValue(ArrayList<Point> blobXY) {
        ArrayList<Double> list = new ArrayList<Double>(11);
        int sumX = 0;
        int sumY = 0;
        for (Point p : blobXY) {
            sumX += p.x;
            sumY += p.y;
        }
        double mx = (double)sumX / (double)blobXY.size();
        double my = (double)sumY / (double)blobXY.size();
        double u20 = 0.0;
        double u02 = 0.0;
        double u11 = 0.0;
        double u21 = 0.0;
        double u12 = 0.0;
        double u30 = 0.0;
        double u03 = 0.0;
        for (Point p : blobXY) {
            double x = p.getX();
            double y = p.getY();
            u11 += (x - mx) * (y - my);
            u20 += (x - mx) * (x - mx);
            u02 += (y - my) * (y - my);
            u21 += (x - mx) * (x - mx) * (y - my);
            u12 += (x - mx) * (y - my) * (y - my);
            u30 += (x - mx) * (x - mx) * (x - mx);
            u03 += (y - my) * (y - my) * (y - my);
        }
        list.add(mx);
        list.add(my);
        list.add(u11);
        list.add(u20);
        list.add(u02);
        list.add(u21);
        list.add(u12);
        list.add(u30);
        list.add(u03);
        return list;
    }
}

