/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image.dockable;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.weasis.core.api.gui.util.DropDownButton;
import org.weasis.core.api.gui.util.JSliderW;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.ui.Messages;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.util.WtoolBar;

public abstract class MiniTool
extends PluginTool
implements ActionListener {
    public static final String BUTTON_NAME = Messages.getString("MiniToolDockable.title");
    private SliderChangeListener currentAction;
    private final JSliderW slider;

    public MiniTool(String pluginName, Icon icon) {
        super(BUTTON_NAME, pluginName, ToolWindowAnchor.RIGHT);
        this.setDockableWidth(40);
        this.currentAction = this.getActions()[0];
        this.slider = MiniTool.createSlider(this.currentAction, this.getAnchor());
        this.jbInit();
    }

    private void jbInit() {
        boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)this.getAnchor()) || ToolWindowAnchor.LEFT.equals((Object)this.getAnchor());
        this.setLayout(new BoxLayout(this, vertical ? 1 : 0));
        Dimension dim = new Dimension(5, 5);
        this.add(Box.createRigidArea(dim));
        DropDownButton button = new DropDownButton("Mini", this.currentAction.getActionW().getSmallDropButtonIcon()){

            protected JPopupMenu getPopupMenu() {
                return MiniTool.this.getPopupMenuScroll(this);
            }
        };
        button.setToolTipText(Messages.getString("MiniToolDockable.change"));
        WtoolBar.installButtonUI((AbstractButton)button);
        WtoolBar.configureButton((AbstractButton)button);
        button.setAlignmentY(0.5f);
        button.setAlignmentX(0.5f);
        this.add((Component)button);
        this.add(Box.createRigidArea(dim));
        this.slider.setAlignmentY(0.5f);
        this.slider.setAlignmentX(0.5f);
        this.add((Component)this.slider);
        this.add(Box.createRigidArea(dim));
    }

    public abstract SliderChangeListener[] getActions();

    public static JSliderW createSlider(SliderChangeListener action, ToolWindowAnchor anchor) {
        boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)anchor) || ToolWindowAnchor.LEFT.equals((Object)anchor);
        JSliderW slider = new JSliderW(action.getMin(), action.getMax(), action.getValue());
        slider.setDisplayOnlyValue(true);
        slider.setInverted(vertical);
        slider.setOrientation(vertical ? 1 : 0);
        slider.setPreferredSize(new Dimension(35, 250));
        action.registerSlider(slider);
        return slider;
    }

    @Override
    protected void changeToolWindowAnchor(ToolWindowAnchor anchor) {
        boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)anchor) || ToolWindowAnchor.LEFT.equals((Object)anchor);
        this.setLayout(new BoxLayout(this, vertical ? 1 : 0));
        this.slider.getParent().setLayout(new BoxLayout(this.slider.getParent(), vertical ? 1 : 0));
        this.slider.setInverted(vertical);
        this.slider.setOrientation(vertical ? 1 : 0);
        ToolWindow win = this.getToolWindow();
        if (win != null) {
            DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)win.getTypeDescriptor(ToolWindowType.DOCKED);
            int width = this.getDockableWidth();
            if (width > 0) {
                dockedTypeDescriptor.setDockLength(vertical ? width : width + 10);
            }
        }
        this.slider.revalidate();
        this.slider.repaint();
    }

    private JPopupMenu getPopupMenuScroll(DropDownButton dropButton) {
        String type = dropButton.getType();
        JPopupMenu popupMouseScroll = new JPopupMenu(type);
        popupMouseScroll.setInvoker((Component)dropButton);
        ButtonGroup groupButtons = new ButtonGroup();
        SliderChangeListener[] actions = this.getActions();
        for (int i = 0; i < actions.length; ++i) {
            JRadioButtonMenuItem radio = new JRadioButtonMenuItem(actions[i].toString(), actions[i].getActionW().getSmallIcon(), actions[i].equals(this.currentAction));
            radio.setActionCommand("" + i);
            radio.addActionListener(this);
            popupMouseScroll.add(radio);
            groupButtons.add(radio);
        }
        return popupMouseScroll;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButtonMenuItem item;
        if (e.getSource() instanceof JRadioButtonMenuItem && (item = (JRadioButtonMenuItem)e.getSource()).getParent() instanceof JPopupMenu) {
            SliderChangeListener newAction = this.getAction(e.getActionCommand());
            if (this.currentAction == newAction) {
                return;
            }
            if (this.currentAction != null) {
                this.currentAction.unregisterSlider(this.slider);
            }
            if (newAction != null) {
                newAction.registerSlider(this.slider);
            }
            this.currentAction = newAction;
            JPopupMenu pop = (JPopupMenu)item.getParent();
            if (pop.getInvoker() instanceof DropDownButton) {
                ((DropDownButton)pop.getInvoker()).setIcon(this.currentAction.getActionW().getSmallDropButtonIcon());
            }
        }
    }

    private SliderChangeListener getAction(String actionCommand) {
        try {
            int index = Integer.parseInt(actionCommand);
            SliderChangeListener[] actions = this.getActions();
            if (index >= 0 && index < actions.length) {
                return actions[index];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }
}

