/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.core.ui.editor.image;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.noos.xing.mydoggy.Content;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.image.ViewerToolBar;
import org.weasis.core.ui.util.WtoolBar;

public abstract class ViewerPlugin<E extends MediaElement>
extends JPanel
implements SeriesViewer<E> {
    private final String dockableUID;
    private MediaSeriesGroup groupID;
    private String pluginName;
    private final Icon icon;
    private final String tooltips;

    public ViewerPlugin(String PluginName) {
        this(PluginName, null, null);
    }

    public ViewerPlugin(String pluginName, Icon icon, String tooltips) {
        this.setLayout(new BorderLayout());
        this.setName(pluginName);
        this.pluginName = pluginName;
        this.icon = icon;
        this.tooltips = tooltips;
        this.dockableUID = "" + UIManager.dockableUIGenerator.getAndIncrement();
    }

    @Override
    public MediaSeriesGroup getGroupID() {
        return this.groupID;
    }

    public void setGroupID(MediaSeriesGroup groupID) {
        this.groupID = groupID;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getTooltips() {
        return this.tooltips;
    }

    public String getDockableUID() {
        return this.dockableUID;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
        Content content = UIManager.toolWindowManager.getContentManager().getContent((Object)this.getDockableUID());
        if (content != null) {
            content.setTitle(pluginName);
        }
    }

    public void setSelectedAndGetFocus() {
        Content content = UIManager.toolWindowManager.getContentManager().getContent((Object)this.getDockableUID());
        if (content != null) {
            content.setSelected(true);
        }
        this.requestFocusInWindow();
    }

    @Override
    public void close() {
        UIManager.VIEWER_PLUGINS.remove(this);
    }

    public Component getComponent() {
        return this;
    }

    public ViewerToolBar getViewerToolBar() {
        WtoolBar[] bars = this.getToolBar();
        if (bars != null) {
            for (WtoolBar t : bars) {
                if (!(t instanceof ViewerToolBar)) continue;
                return (ViewerToolBar)t;
            }
        }
        return null;
    }

    public abstract Action[] getExportActions();
}

