/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.explorer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.FontRenderContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.noos.xing.mydoggy.DockedTypeDescriptor;
import org.noos.xing.mydoggy.ToolWindow;
import org.noos.xing.mydoggy.ToolWindowAnchor;
import org.noos.xing.mydoggy.ToolWindowType;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.explorer.model.DataExplorerModel;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.JMVUtils;
import org.weasis.core.api.media.data.ImageElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.MediaSeriesGroupNode;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.api.media.data.Thumbnail;
import org.weasis.core.api.util.FontTools;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.editor.SeriesViewer;
import org.weasis.core.ui.editor.SeriesViewerEvent;
import org.weasis.core.ui.editor.SeriesViewerFactory;
import org.weasis.core.ui.editor.image.ViewerPlugin;
import org.weasis.core.ui.util.ArrayListComboBoxModel;
import org.weasis.core.ui.util.WrapLayout;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.codec.DicomSpecialElement;
import org.weasis.dicom.codec.geometry.ImageOrientation;
import org.weasis.dicom.explorer.DicomExport;
import org.weasis.dicom.explorer.DicomFieldsView;
import org.weasis.dicom.explorer.DicomImport;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.explorer.Messages;
import org.weasis.dicom.explorer.MimeSystemAppFactory;
import org.weasis.dicom.explorer.SeriesSelectionModel;
import org.weasis.dicom.explorer.wado.LoadSeries;

public class DicomExplorer
extends PluginTool
implements DataExplorerView {
    private static final Logger LOGGER = LoggerFactory.getLogger(DicomExplorer.class);
    public static final String NAME = Messages.getString("DicomExplorer.title");
    public static final String PREFERENCE_NODE = "dicom.explorer";
    public static final String BUTTON_NAME = Messages.getString("DicomExplorer.btn_title");
    public static final String DESCRIPTION = Messages.getString("DicomExplorer.desc");
    private static final String ALL_PATIENTS = Messages.getString("DicomExplorer.sel_all_pat");
    private static final String ALL_STUDIES = Messages.getString("DicomExplorer.sel_all_st");
    public static final Icon PATIENT_ICON = new ImageIcon(DicomExplorer.class.getResource("/icon/16x16/patient.png"));
    private JPanel panel = null;
    private PatientPane selectedPatient = null;
    private final List<PatientPane> patientPaneList = new ArrayList<PatientPane>();
    private final HashMap<MediaSeriesGroup, List<StudyPane>> patient2study = new HashMap();
    private final HashMap<MediaSeriesGroup, List<SeriesPane>> study2series = new HashMap();
    private final JScrollPane thumnailView = new JScrollPane();
    private final SeriesSelectionModel selectionList = new SeriesSelectionModel();
    private final DicomModel model;
    private final Comparator patientComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };
    private final Comparator studyComparator = new Comparator(){

        @Override
        public boolean equals(Object obj) {
            return true;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 instanceof StudyPane && o2 instanceof StudyPane) {
                o1 = ((StudyPane)o1).dicomStudy;
                o2 = ((StudyPane)o2).dicomStudy;
            }
            if (o1 instanceof MediaSeriesGroup && o2 instanceof MediaSeriesGroup) {
                MediaSeriesGroup st1 = (MediaSeriesGroup)o1;
                MediaSeriesGroup st2 = (MediaSeriesGroup)o2;
                Date date1 = (Date)st1.getTagValue(TagW.StudyDate);
                Date date2 = (Date)st2.getTagValue(TagW.StudyDate);
                if (date1 != null && date2 != null) {
                    int res = date2.compareTo(date1);
                    if (res == 0) {
                        Date time1 = (Date)st1.getTagValue(TagW.StudyTime);
                        Date time2 = (Date)st2.getTagValue(TagW.StudyTime);
                        if (time1 != null && time2 != null) {
                            return time2.compareTo(time1);
                        }
                    } else {
                        return res;
                    }
                }
                String uid1 = (String)st1.getTagValue(TagW.StudyInstanceUID);
                String uid2 = (String)st2.getTagValue(TagW.StudyInstanceUID);
                if (date1 == null && date2 == null && uid1 != null && uid2 != null) {
                    return uid1.compareTo(uid2);
                }
                if (date1 == null) {
                    return 1;
                }
                if (date2 == null) {
                    return -1;
                }
            } else {
                if (o1 instanceof MediaSeriesGroup) {
                    return 1;
                }
                if (o2 instanceof MediaSeriesGroup) {
                    return -1;
                }
            }
            return 0;
        }
    };
    private final ArrayListComboBoxModel modelPatient = new ArrayListComboBoxModel(){
        private static final long serialVersionUID = 1826724555734323483L;

        public void addElement(Object anObject) {
            int index = this.binarySearch(anObject, DicomExplorer.this.patientComparator);
            if (index < 0) {
                super.insertElementAt(anObject, -(index + 1));
            }
        }
    };
    private final ArrayListComboBoxModel modelStudy = new ArrayListComboBoxModel(){
        private static final long serialVersionUID = 2272386715266884376L;

        public void addElement(Object anObject) {
            int index = this.binarySearch(anObject, DicomExplorer.this.studyComparator);
            if (index < 0) {
                super.insertElementAt(anObject, -(index + 1));
            } else {
                super.insertElementAt(anObject, index);
            }
        }
    };
    private final JComboBox patientCombobox = new JComboBox(this.modelPatient);
    private final JComboBox studyCombobox = new JComboBox(this.modelStudy);
    protected final PatientContainerPane patientContainer = new PatientContainerPane();
    private final transient ItemListener patientChangeListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                Object item = DicomExplorer.this.modelPatient.getSelectedItem();
                if (item instanceof MediaSeriesGroupNode) {
                    MediaSeriesGroupNode patient = (MediaSeriesGroupNode)item;
                    DicomExplorer.this.selectPatient((MediaSeriesGroup)patient);
                } else if (item != null) {
                    DicomExplorer.this.selectPatient(null);
                }
                DicomExplorer.this.patientContainer.revalidate();
                DicomExplorer.this.patientContainer.repaint();
            }
        }
    };
    private final transient ItemListener studyItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                DicomExplorer.this.selectStudy();
            }
        }
    };
    private final JSlider slider = new JSlider(48, 256, 112);
    private JPanel panel_1 = null;
    private final JPanel panel_2 = new JPanel();
    private final JToggleButton btnMoreOptions = new JToggleButton(Messages.getString("DicomExplorer.more_opt"));
    private final JPanel panel_3 = new JPanel();
    private final JButton btnExport = new JButton(Messages.getString("DicomExplorer.export"));
    private final JButton btnImport = new JButton(Messages.getString("DicomExplorer.import"));
    private final AbstractAction importAction = new AbstractAction(Messages.getString("DicomExplorer.to") + NAME){

        @Override
        public void actionPerformed(ActionEvent e) {
            DicomImport dialog = new DicomImport(DicomExplorer.this.model);
            JMVUtils.showCenterScreen((Window)((Object)dialog));
        }
    };
    private final AbstractAction exportAction = new AbstractAction(Messages.getString("DicomExplorer.from") + NAME){

        @Override
        public void actionPerformed(ActionEvent e) {
            DicomExport dialog = new DicomExport(DicomExplorer.this.model);
            JMVUtils.showCenterScreen((Window)((Object)dialog));
        }
    };

    public DicomExplorer() {
        this(null);
    }

    public DicomExplorer(DicomModel model) {
        super(BUTTON_NAME, NAME, ToolWindowAnchor.LEFT);
        this.setLayout(new BorderLayout());
        this.setDockableWidth(180);
        this.model = model == null ? new DicomModel() : model;
        Color panelBckColor = (Color)UIManager.get("Panel.background");
        if (panelBckColor == null) {
            UIManager.put("Panel.background", this.getBackground());
        }
        this.thumnailView.getVerticalScrollBar().setUnitIncrement(16);
        this.thumnailView.setViewportView(this.patientContainer);
        this.changeToolWindowAnchor(this.getAnchor());
    }

    protected void activate(ComponentContext context) {
        this.model.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "dicom");
        ((Dictionary)dict).put("osgi.command.function", DicomModel.functions);
        context.getBundleContext().registerService(DicomModel.class.getName(), (Object)this.model, dict);
    }

    protected void deactivate(ComponentContext context) {
        this.model.removePropertyChangeListener((PropertyChangeListener)((Object)this));
    }

    private String getLimiteStringSize(String name, int limit) {
        if (name.length() > limit) {
            name = name.substring(0, limit - 2) + "...";
        }
        return name;
    }

    public SeriesSelectionModel getSelectionList() {
        return this.selectionList;
    }

    private void removePatientPane(MediaSeriesGroup patient) {
        for (int i = 0; i < this.patientPaneList.size(); ++i) {
            PatientPane p = this.patientPaneList.get(i);
            if (!p.isPatient(patient)) continue;
            this.patientPaneList.remove(i);
            List<StudyPane> studies = this.patient2study.remove(patient);
            if (studies != null) {
                for (StudyPane studyPane : studies) {
                    this.study2series.remove(studyPane.dicomStudy);
                }
            }
            this.patientContainer.remove(p);
            this.modelPatient.removeElement((Object)patient);
            return;
        }
    }

    private void removeStudy(MediaSeriesGroup study) {
        MediaSeriesGroup patient = this.model.getParent(study, DicomModel.patient);
        List<StudyPane> studies = this.patient2study.get(patient);
        if (studies != null) {
            for (int i = 0; i < studies.size(); ++i) {
                StudyPane st = studies.get(i);
                if (!st.isStudy(study)) continue;
                studies.remove(i);
                if (studies.size() == 0) {
                    this.patient2study.remove(patient);
                    this.model.removePatient(patient);
                    return;
                }
                this.study2series.remove(study);
                PatientPane patientPane = this.getPatientPane(patient);
                if (patientPane == null || !patientPane.isStudyVisible(study)) break;
                patientPane.remove(st);
                this.modelStudy.removeElement((Object)study);
                patientPane.revalidate();
                patientPane.repaint();
                break;
            }
        }
        this.study2series.remove(study);
    }

    private void removeSeries(MediaSeriesGroup series) {
        MediaSeriesGroup study = this.model.getParent(series, DicomModel.study);
        List<SeriesPane> seriesList = this.study2series.get(study);
        if (seriesList != null) {
            for (int j = 0; j < seriesList.size(); ++j) {
                SeriesPane se = seriesList.get(j);
                if (!se.isSeries(series)) continue;
                seriesList.remove(j);
                if (seriesList.size() == 0) {
                    this.study2series.remove(study);
                    this.model.removeStudy(study);
                    return;
                }
                se.removeAll();
                StudyPane studyPane = this.getStudyPane(study);
                if (studyPane == null || !studyPane.isSeriesVisible(series)) break;
                studyPane.remove(se);
                studyPane.revalidate();
                studyPane.repaint();
                break;
            }
        }
    }

    private PatientPane createPatientPane(MediaSeriesGroup patient) {
        PatientPane pat = this.getPatientPane(patient);
        if (pat == null) {
            pat = new PatientPane(patient);
            this.patientPaneList.add(pat);
        }
        return pat;
    }

    private PatientPane getPatientPane(MediaSeriesGroup patient) {
        for (PatientPane p : this.patientPaneList) {
            if (!p.isPatient(patient)) continue;
            return p;
        }
        return null;
    }

    private StudyPane getStudyPane(MediaSeriesGroup study) {
        List<StudyPane> studies = this.patient2study.get(this.model.getParent(study, DicomModel.patient));
        if (studies != null) {
            for (int i = 0; i < studies.size(); ++i) {
                StudyPane st = studies.get(i);
                if (!st.isStudy(study)) continue;
                return st;
            }
        }
        return null;
    }

    private StudyPane createStudyPaneInstance(MediaSeriesGroup study, int[] position) {
        StudyPane studyPane = this.getStudyPane(study);
        if (studyPane == null) {
            studyPane = new StudyPane(study);
            List<StudyPane> studies = this.patient2study.get(this.model.getParent(study, DicomModel.patient));
            if (studies != null) {
                int index = Collections.binarySearch(studies, studyPane, this.studyComparator);
                index = index < 0 ? -(index + 1) : studies.size();
                if (position != null) {
                    position[0] = index;
                }
                studies.add(index, studyPane);
            }
        } else if (position != null) {
            position[0] = -1;
        }
        return studyPane;
    }

    private void updateThumbnailSize() {
        int thumbnailSize = this.slider.getValue();
        for (PatientPane p : this.patientContainer.getPatientPaneList()) {
            for (StudyPane studyPane : p.getStudyPaneList()) {
                for (SeriesPane series : studyPane.getSeriesPaneList()) {
                    series.updateSize(thumbnailSize);
                }
            }
        }
        this.patientContainer.revalidate();
        this.patientContainer.repaint();
    }

    private SeriesPane getSeriesPane(MediaSeriesGroup series) {
        List<SeriesPane> seriesList = this.study2series.get(this.model.getParent(series, DicomModel.study));
        if (seriesList != null) {
            for (int j = 0; j < seriesList.size(); ++j) {
                SeriesPane se = seriesList.get(j);
                if (!se.isSeries(series)) continue;
                return se;
            }
        }
        return null;
    }

    private synchronized SeriesPane createSeriesPaneInstance(MediaSeriesGroup series, int[] position) {
        SeriesPane seriesPane = this.getSeriesPane(series);
        if (seriesPane == null) {
            seriesPane = new SeriesPane(series);
            List<SeriesPane> seriesList = this.study2series.get(this.model.getParent(series, DicomModel.study));
            if (seriesList != null) {
                Integer val1 = this.getIntValue((Integer)series.getTagValue(TagW.SeriesNumber));
                int index = 0;
                for (int i = 0; i < seriesList.size(); ++i) {
                    SeriesPane sp = seriesList.get(i);
                    if (series instanceof DicomSeries && sp.sequence instanceof DicomSeries) {
                        Integer val2 = this.getIntValue((Integer)sp.sequence.getTagValue(TagW.SeriesNumber));
                        if (val1 != null && val2 != null && val1 < val2) {
                            LOGGER.debug("Sort Series {} by Series Number, index: {} ", (Object)val1, (Object)i);
                            break;
                        }
                        if (val1 == null || val2 == null || val1.intValue() == val2.intValue()) {
                            DicomImageElement media1 = (DicomImageElement)((DicomSeries)series).getMedia(0);
                            DicomImageElement media2 = (DicomImageElement)((DicomSeries)sp.sequence).getMedia(0);
                            if (media1 != null && media2 != null) {
                                int p2;
                                int p1;
                                Float tag1 = (Float)media1.getTagValue(TagW.SliceLocation);
                                Float tag2 = (Float)media2.getTagValue(TagW.SliceLocation);
                                if (tag1 != null && tag2 != null && tag1.floatValue() < tag2.floatValue()) {
                                    LOGGER.debug("Sort Series {} by slice Location: {}, index: {} ", new Object[]{val1, tag1, i});
                                    break;
                                }
                                if (tag2 == tag1 && (p1 = this.getOrientationLabelPosition((String)media1.getTagValue(TagW.ImageOrientationPlane))) < (p2 = this.getOrientationLabelPosition((String)media2.getTagValue(TagW.ImageOrientationPlane)))) {
                                    LOGGER.debug("Sort Series {} by orientation: {}, index: {} ", new Object[]{val1, p1, i});
                                    break;
                                }
                            }
                        }
                    }
                    index = i + 1;
                    if (position == null) continue;
                    position[0] = index;
                }
                seriesList.add(index, seriesPane);
            }
        } else if (position != null) {
            position[0] = -1;
        }
        return seriesPane;
    }

    private int getIntValue(Integer value) {
        return value == null ? 0 : value;
    }

    private int getOrientationLabelPosition(String orientationPlane) {
        if (orientationPlane == null) {
            return 0;
        }
        for (int i = 0; i < ImageOrientation.LABELS.length; ++i) {
            if (!ImageOrientation.LABELS[i].equals(orientationPlane)) continue;
            return i;
        }
        return 0;
    }

    private boolean isSelectedPatient(MediaSeriesGroup patient) {
        return this.selectedPatient != null && this.selectedPatient.patient == patient;
    }

    protected JPanel getPanel() {
        if (this.panel_1 == null) {
            this.panel_1 = new JPanel();
            this.panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowHeights = new int[]{0, 0, 7};
            this.panel.setLayout(gridBagLayout);
            this.panel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JLabel label = new JLabel(PATIENT_ICON);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 5, 5);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.panel.add((Component)label, gridBagConstraints);
            GridBagConstraints gridBagConstraints_1 = new GridBagConstraints();
            gridBagConstraints_1.insets = new Insets(0, 2, 5, 0);
            gridBagConstraints_1.anchor = 17;
            gridBagConstraints_1.weightx = 1.0;
            gridBagConstraints_1.gridy = 0;
            gridBagConstraints_1.gridx = 1;
            this.panel.add((Component)this.patientCombobox, gridBagConstraints_1);
            this.patientCombobox.setMaximumRowCount(15);
            this.patientCombobox.setFont(FontTools.getFont11());
            JMVUtils.setPreferredWidth((JComponent)this.patientCombobox, (int)145, (int)145);
            this.patientCombobox.updateUI();
            this.patientCombobox.addItemListener(this.patientChangeListener);
            JMVUtils.addTooltipToComboList((JComboBox)this.patientCombobox);
            GridBagConstraints gridBagConstraints_3 = new GridBagConstraints();
            gridBagConstraints_3.anchor = 17;
            gridBagConstraints_3.insets = new Insets(2, 2, 5, 0);
            gridBagConstraints_3.gridx = 1;
            gridBagConstraints_3.gridy = 1;
            this.panel.add((Component)this.studyCombobox, gridBagConstraints_3);
            this.studyCombobox.setMaximumRowCount(15);
            this.studyCombobox.setFont(FontTools.getFont11());
            this.studyCombobox.updateUI();
            JMVUtils.setPreferredWidth((JComponent)this.studyCombobox, (int)145, (int)145);
            this.modelStudy.insertElementAt((Object)ALL_STUDIES, 0);
            this.modelStudy.setSelectedItem((Object)ALL_STUDIES);
            this.studyCombobox.addItemListener(this.studyItemListener);
            JMVUtils.addTooltipToComboList((JComboBox)this.studyCombobox);
            this.panel_1.setLayout(new BorderLayout());
            this.panel_1.add((Component)this.panel, "North");
            GridBagConstraints gbc_btnMoreOptions = new GridBagConstraints();
            gbc_btnMoreOptions.anchor = 13;
            gbc_btnMoreOptions.gridx = 1;
            gbc_btnMoreOptions.gridy = 2;
            this.btnMoreOptions.setFont(FontTools.getFont10());
            this.btnMoreOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DicomExplorer.this.btnMoreOptions.isSelected()) {
                        DicomExplorer.this.panel_1.add((Component)DicomExplorer.this.panel_2, "South");
                    } else {
                        DicomExplorer.this.panel_1.remove(DicomExplorer.this.panel_2);
                    }
                    DicomExplorer.this.panel_1.revalidate();
                    DicomExplorer.this.panel_1.repaint();
                }
            });
            this.panel.add((Component)this.btnMoreOptions, gbc_btnMoreOptions);
            GridBagLayout gbl_panel_2 = new GridBagLayout();
            this.panel_2.setLayout(gbl_panel_2);
            GridBagConstraints gbc_panel_3 = new GridBagConstraints();
            gbc_panel_3.weightx = 1.0;
            gbc_panel_3.anchor = 18;
            gbc_panel_3.gridx = 0;
            gbc_panel_3.gridy = 0;
            FlowLayout flowLayout = (FlowLayout)this.panel_3.getLayout();
            flowLayout.setHgap(10);
            flowLayout.setAlignment(0);
            this.panel_2.add((Component)this.panel_3, gbc_panel_3);
            this.btnImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DicomImport dialog = new DicomImport(DicomExplorer.this.model);
                    JMVUtils.showCenterScreen((Window)((Object)dialog));
                }
            });
            this.panel_3.add(this.btnImport);
            this.btnExport.setEnabled(false);
            this.panel_3.add(this.btnExport);
            final JPanel palenSlider1 = new JPanel();
            palenSlider1.setLayout(new BoxLayout(palenSlider1, 1));
            palenSlider1.setBorder(new TitledBorder(Messages.getString("DicomExplorer.thmb_size") + this.slider.getValue()));
            this.slider.setPaintTicks(true);
            this.slider.setSnapToTicks(true);
            this.slider.setMajorTickSpacing(16);
            this.slider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSlider source = (JSlider)e.getSource();
                    if (!source.getValueIsAdjusting()) {
                        ((TitledBorder)palenSlider1.getBorder()).setTitle(Messages.getString("DicomExplorer.thmb_size") + source.getValue());
                        palenSlider1.repaint();
                        DicomExplorer.this.updateThumbnailSize();
                    }
                }
            });
            JMVUtils.setPreferredWidth((JComponent)this.slider, (int)145, (int)145);
            palenSlider1.add(this.slider);
            GridBagConstraints gbc_palenSlider1 = new GridBagConstraints();
            gbc_palenSlider1.insets = new Insets(0, 5, 5, 5);
            gbc_palenSlider1.anchor = 18;
            gbc_palenSlider1.gridx = 0;
            gbc_palenSlider1.gridy = 1;
            this.panel_2.add((Component)palenSlider1, gbc_palenSlider1);
        }
        return this.panel_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPatientHasOpenSeries(MediaSeriesGroup p) {
        Collection<MediaSeriesGroup> studies;
        Collection<MediaSeriesGroup> collection = studies = this.model.getChildren(p);
        synchronized (collection) {
            for (MediaSeriesGroup study : studies) {
                Collection<MediaSeriesGroup> seriesList;
                Collection<MediaSeriesGroup> collection2 = seriesList = this.model.getChildren(study);
                synchronized (collection2) {
                    for (MediaSeriesGroup seq : seriesList) {
                        if (!(seq instanceof Series)) continue;
                        Boolean open = (Boolean)((Series)seq).getTagValue(TagW.SeriesOpen);
                        boolean bl = open == null ? false : open;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    public void selectPatient(MediaSeriesGroup patient) {
        if (this.selectedPatient == null || patient != this.selectedPatient.patient) {
            this.selectionList.clear();
            this.studyCombobox.removeItemListener(this.studyItemListener);
            this.modelStudy.removeAllElements();
            this.modelStudy.insertElementAt((Object)ALL_STUDIES, 0);
            this.modelStudy.setSelectedItem((Object)ALL_STUDIES);
            this.patientContainer.removeAll();
            if (patient == null) {
                this.selectedPatient = null;
                this.patientContainer.showAllPatients();
            } else {
                this.selectedPatient = this.createPatientPane(patient);
                this.selectedPatient.showTitle(false);
                List<StudyPane> studies = this.patient2study.get(patient);
                if (studies != null) {
                    for (StudyPane studyPane : studies) {
                        this.modelStudy.addElement((Object)studyPane.dicomStudy);
                    }
                }
                this.studyCombobox.addItemListener(this.studyItemListener);
                this.selectStudy();
                this.patientContainer.addPane(this.selectedPatient);
                this.model.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Select, (Object)this.model, null, (Object)patient));
            }
        }
    }

    private List<Series> getSplitSeries(Series dcm) {
        MediaSeriesGroup study = this.model.getParent((MediaSeriesGroup)dcm, DicomModel.study);
        Object splitNb = dcm.getTagValue(TagW.SplitSeriesNumber);
        ArrayList<Series> list = new ArrayList<Series>();
        if (splitNb == null || study == null) {
            list.add(dcm);
            return list;
        }
        String uid = (String)dcm.getTagValue(TagW.SeriesInstanceUID);
        if (uid != null) {
            Collection<MediaSeriesGroup> seriesList = this.model.getChildren(study);
            for (MediaSeriesGroup group : seriesList) {
                Series s;
                if (!(group instanceof Series) || !uid.equals((s = (Series)group).getTagValue(TagW.SeriesInstanceUID))) continue;
                list.add(s);
            }
        }
        return list;
    }

    private void updateSplitSeries(Series dcmSeries) {
        MediaSeriesGroup study = this.model.getParent((MediaSeriesGroup)dcmSeries, DicomModel.study);
        if (study == null) {
            return;
        }
        StudyPane studyPane = this.createStudyPaneInstance(study, null);
        List<Series> list = this.getSplitSeries(dcmSeries);
        List<SeriesPane> seriesList = this.study2series.get(study);
        if (seriesList == null) {
            seriesList = new ArrayList<SeriesPane>();
            this.study2series.put(study, seriesList);
        }
        boolean addSeries = this.patientContainer.isStudyVisible(study);
        boolean repaintStudy = false;
        for (Series dicomSeries : list) {
            Thumbnail thumb;
            int[] positionSeries = new int[1];
            this.createSeriesPaneInstance((MediaSeriesGroup)dicomSeries, positionSeries);
            if (addSeries && positionSeries[0] != -1) {
                repaintStudy = true;
            }
            if ((thumb = (Thumbnail)dicomSeries.getTagValue(TagW.Thumbnail)) == null) continue;
            thumb.reBuildThumbnail();
        }
        Integer nb = (Integer)dcmSeries.getTagValue(TagW.SplitSeriesNumber);
        if (nb != null && nb < 0) {
            this.model.removeSeries((MediaSeriesGroup)dcmSeries);
            repaintStudy = true;
        }
        if (repaintStudy) {
            studyPane.removeAll();
            Comparator<SeriesPane> comp = new Comparator<SeriesPane>(){

                @Override
                public int compare(SeriesPane s1, SeriesPane s2) {
                    int val2;
                    int val1 = DicomExplorer.this.getIntValue((Integer)s1.getSequence().getTagValue(TagW.SeriesNumber));
                    if (val1 == (val2 = DicomExplorer.this.getIntValue((Integer)s2.getSequence().getTagValue(TagW.SeriesNumber)))) {
                        int split2;
                        if (val1 == 0) {
                            return 1;
                        }
                        int split1 = DicomExplorer.this.getIntValue((Integer)s1.getSequence().getTagValue(TagW.SplitSeriesNumber));
                        return split1 < (split2 = DicomExplorer.this.getIntValue((Integer)s2.getSequence().getTagValue(TagW.SplitSeriesNumber))) ? -1 : (split1 == split2 ? 0 : 1);
                    }
                    return val1 < val2 ? -1 : 1;
                }
            };
            Collections.sort(seriesList, comp);
            for (int i = 0; i < seriesList.size(); ++i) {
                studyPane.addPane(seriesList.get(i), i);
            }
            studyPane.revalidate();
            studyPane.repaint();
        }
    }

    private void selectStudy() {
        Object item = this.modelStudy.getSelectedItem();
        if (item instanceof MediaSeriesGroupNode) {
            MediaSeriesGroupNode selectedStudy = (MediaSeriesGroupNode)item;
            this.selectStudy((MediaSeriesGroup)selectedStudy);
        } else {
            this.selectStudy(null);
        }
    }

    public void selectStudy(MediaSeriesGroup selectedStudy) {
        if (this.selectedPatient != null) {
            this.selectionList.clear();
            this.selectedPatient.removeAll();
            if (selectedStudy == null) {
                this.selectedPatient.showAllstudies();
            } else {
                StudyPane studyPane = this.getStudyPane(selectedStudy);
                if (studyPane != null) {
                    studyPane.showAllSeries();
                    studyPane.refreshLayout();
                    this.selectedPatient.addPane(studyPane);
                }
            }
            this.selectedPatient.revalidate();
            this.selectedPatient.repaint();
        }
    }

    public void dispose() {
    }

    private void addSpecialModalityToStudy(Series series) {
        DicomSpecialElement dicomObject = (DicomSpecialElement)series.getTagValue(TagW.DicomSpecialElement);
        MediaSeriesGroup study = this.model.getParent((MediaSeriesGroup)series, DicomModel.study);
        ArrayList<DicomSpecialElement> list = (ArrayList<DicomSpecialElement>)study.getTagValue(TagW.DicomSpecialElementList);
        if (list == null) {
            list = new ArrayList<DicomSpecialElement>();
            study.setTag(TagW.DicomSpecialElementList, list);
        }
        list.add(dicomObject);
    }

    private void addDicomSeries(Series series) {
        if (DicomModel.isSpecialModality(series)) {
            this.addSpecialModalityToStudy(series);
            return;
        }
        LOGGER.info("Add series: {}", (Object)series);
        MediaSeriesGroup study = this.model.getParent((MediaSeriesGroup)series, DicomModel.study);
        MediaSeriesGroup patient = this.model.getParent((MediaSeriesGroup)series, DicomModel.patient);
        PatientPane patientPane = this.createPatientPane(patient);
        if (this.modelPatient.getIndexOf((Object)patient) < 0) {
            this.modelPatient.addElement((Object)patient);
            if (this.modelPatient.getSize() == 1) {
                this.selectedPatient = patientPane;
                this.patientContainer.addPane(this.selectedPatient);
                this.patientCombobox.removeItemListener(this.patientChangeListener);
                this.patientCombobox.setSelectedItem(patient);
                this.patientCombobox.addItemListener(this.patientChangeListener);
            } else if (this.selectedPatient == null) {
                this.patientContainer.addPane(patientPane);
            }
        }
        boolean addSeries = this.selectedPatient == patientPane;
        List<StudyPane> studies = this.patient2study.get(patient);
        if (studies == null) {
            studies = new ArrayList<StudyPane>();
            this.patient2study.put(patient, studies);
        }
        Object selectedStudy = this.modelStudy.getSelectedItem();
        int[] positionStudy = new int[1];
        StudyPane studyPane = this.createStudyPaneInstance(study, positionStudy);
        List<SeriesPane> seriesList = this.study2series.get(study);
        if (seriesList == null) {
            seriesList = new ArrayList<SeriesPane>();
            this.study2series.put(study, seriesList);
        }
        int[] positionSeries = new int[1];
        this.createSeriesPaneInstance((MediaSeriesGroup)series, positionSeries);
        if (addSeries && positionSeries[0] != -1) {
            if (positionStudy[0] != -1) {
                if (this.modelStudy.getIndexOf((Object)study) < 0) {
                    this.modelStudy.addElement((Object)study);
                }
                if (ALL_STUDIES.equals(selectedStudy)) {
                    patientPane.removeAll();
                    for (StudyPane s : studies) {
                        patientPane.addPane(s);
                    }
                    patientPane.revalidate();
                }
            }
            if (patientPane.isStudyVisible(study)) {
                studyPane.removeAll();
                for (int i = 0; i < seriesList.size(); ++i) {
                    studyPane.addPane(seriesList.get(i), i);
                }
                studyPane.revalidate();
                studyPane.repaint();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt instanceof ObservableEvent) {
            Series dcm;
            MediaSeriesGroup patient;
            ObservableEvent event = (ObservableEvent)evt;
            ObservableEvent.BasicAction action = event.getActionCommand();
            Object newVal = event.getNewValue();
            if (this.model.equals(evt.getSource())) {
                if (ObservableEvent.BasicAction.Select.equals((Object)action)) {
                    Series dcm2;
                    MediaSeriesGroup patient2;
                    if (newVal instanceof Series && !this.isSelectedPatient(patient2 = this.model.getParent((MediaSeriesGroup)(dcm2 = (Series)newVal), DicomModel.patient))) {
                        this.modelPatient.setSelectedItem((Object)patient2);
                    }
                } else if (ObservableEvent.BasicAction.Add.equals((Object)action)) {
                    if (newVal instanceof Series) {
                        this.addDicomSeries((Series)newVal);
                    }
                } else if (ObservableEvent.BasicAction.Remove.equals((Object)action)) {
                    if (newVal instanceof MediaSeriesGroup) {
                        MediaSeriesGroup group = (MediaSeriesGroup)newVal;
                        if (TagW.PatientPseudoUID.equals((Object)group.getTagID())) {
                            this.removePatientPane(group);
                        } else if (TagW.StudyInstanceUID.equals((Object)group.getTagID())) {
                            this.removeStudy(group);
                        } else if (TagW.SubseriesInstanceUID.equals((Object)group.getTagID())) {
                            this.removeSeries(group);
                        }
                    }
                } else if (ObservableEvent.BasicAction.UpdateParent.equals((Object)action)) {
                    MediaSeriesGroup study;
                    StudyPane studyPane;
                    Series dcm3;
                    MediaSeriesGroup patient3;
                    if (newVal instanceof Series && this.isSelectedPatient(patient3 = this.model.getParent((MediaSeriesGroup)(dcm3 = (Series)newVal), DicomModel.patient)) && (studyPane = this.getStudyPane(study = this.model.getParent((MediaSeriesGroup)dcm3, DicomModel.study))) != null) {
                        SeriesPane pane;
                        if (!DicomModel.isSpecialModality(dcm3) && (pane = this.getSeriesPane((MediaSeriesGroup)dcm3)) != null) {
                            pane.updateText();
                        }
                        studyPane.updateText();
                    }
                } else if (ObservableEvent.BasicAction.Update.equals((Object)action) && newVal instanceof Series) {
                    Series dcm4 = (Series)newVal;
                    if (DicomModel.isSpecialModality(dcm4)) {
                        this.addSpecialModalityToStudy(dcm4);
                    } else {
                        Integer splitNb = (Integer)dcm4.getTagValue(TagW.SplitSeriesNumber);
                        if (splitNb != null) {
                            this.updateSplitSeries(dcm4);
                        }
                    }
                }
            } else if (evt.getSource() instanceof SeriesViewer && ObservableEvent.BasicAction.Select.equals((Object)action) && newVal instanceof Series && !this.isSelectedPatient(patient = this.model.getParent((MediaSeriesGroup)(dcm = (Series)newVal), DicomModel.patient))) {
                this.modelPatient.setSelectedItem((Object)patient);
                if (evt.getSource() instanceof ViewerPlugin) {
                    ((ViewerPlugin)evt.getSource()).requestFocusInWindow();
                }
            }
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Icon getIcon() {
        return null;
    }

    public String getUIName() {
        return NAME;
    }

    public String toString() {
        return NAME;
    }

    public DataExplorerModel getDataExplorerModel() {
        return this.model;
    }

    protected void changeToolWindowAnchor(ToolWindowAnchor anchor) {
        this.removeAll();
        boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)anchor) || ToolWindowAnchor.LEFT.equals((Object)anchor);
        this.add(this.getPanel(), vertical ? "North" : "West");
        this.patientContainer.refreshLayout();
        ToolWindow win = this.getToolWindow();
        if (win != null) {
            DockedTypeDescriptor dockedTypeDescriptor = (DockedTypeDescriptor)win.getTypeDescriptor(ToolWindowType.DOCKED);
            int width = this.getDockableWidth();
            if (width > 0) {
                dockedTypeDescriptor.setDockLength(vertical ? width : width + 15);
            }
        }
        this.add(this.thumnailView, "Center");
    }

    public static Thumbnail createThumbnail(final Series series, final DicomModel dicomModel, final int thumbnailSize) {
        Callable<Thumbnail> callable = new Callable<Thumbnail>(){

            @Override
            public Thumbnail call() throws Exception {
                Thumbnail thumb = new Thumbnail((MediaSeries)series, thumbnailSize);
                thumb.addMouseListener((MouseListener)DicomExplorer.createThumbnailMouseAdapter(series, dicomModel, null));
                thumb.addKeyListener((KeyListener)DicomExplorer.createThumbnailKeyListener(series, dicomModel));
                thumb.registerListeners();
                return thumb;
            }
        };
        FutureTask<Thumbnail> future = new FutureTask<Thumbnail>(callable);
        GuiExecutor.instance().invokeAndWait(future);
        Thumbnail result = null;
        try {
            result = future.get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static MouseAdapter createThumbnailMouseAdapter(final Series series, final DicomModel dicomModel, final LoadSeries loadSeries) {
        return new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DataExplorerView explorer = org.weasis.core.ui.docking.UIManager.getExplorerplugin((String)NAME);
                    if (explorer instanceof DicomExplorer) {
                        ((DicomExplorer)explorer).getSelectionList().clear();
                    }
                    LoadSeries.openSequenceInDefaultPlugin(new Series[]{series}, dicomModel);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseevent) {
                DataExplorerView explorer;
                SeriesSelectionModel selList;
                Component c = mouseevent.getComponent();
                if (!c.isFocusOwner()) {
                    c.requestFocusInWindow();
                }
                SeriesSelectionModel seriesSelectionModel = selList = (explorer = org.weasis.core.ui.docking.UIManager.getExplorerplugin((String)NAME)) instanceof DicomExplorer ? ((DicomExplorer)explorer).getSelectionList() : new SeriesSelectionModel(1);
                if (SwingUtilities.isRightMouseButton(mouseevent)) {
                    JMenuItem item2;
                    JPopupMenu popupMenu = new JPopupMenu();
                    List plugins = org.weasis.core.ui.docking.UIManager.getViewerFactoryList((String[])new String[]{series.getMimeType()});
                    if (!selList.contains(series)) {
                        selList.add(series);
                    }
                    for (final SeriesViewerFactory viewerFactory : plugins) {
                        JMenuItem item4 = new JMenuItem(Messages.getString("DicomExplorer.open_series") + viewerFactory.getUIName(), viewerFactory.getIcon());
                        item4.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Series[] seriesArray;
                                if (selList.size() == 0) {
                                    Series[] seriesArray2 = new Series[1];
                                    seriesArray = seriesArray2;
                                    seriesArray2[0] = series;
                                } else {
                                    seriesArray = selList.toArray(new Series[selList.size()]);
                                }
                                Series[] seriesList = seriesArray;
                                selList.clear();
                                LoadSeries.openSequenceInPlugin(viewerFactory, seriesList, dicomModel);
                            }
                        });
                        popupMenu.add(item4);
                        if (!(viewerFactory instanceof MimeSystemAppFactory)) continue;
                        JMenuItem item5 = new JMenuItem("Open DICOM information", null);
                        item5.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JFrame frame = new JFrame(Messages.getString("DicomExplorer.dcmInfo"));
                                frame.setSize(500, 630);
                                DicomFieldsView view = new DicomFieldsView();
                                view.changingViewContentEvent(new SeriesViewerEvent(viewerFactory.createSeriesViewer(null), series, series.getMedia(MediaSeries.MEDIA_POSITION.FIRST), SeriesViewerEvent.EVENT.SELECT));
                                JPanel panel = new JPanel();
                                panel.setLayout(new BorderLayout());
                                panel.add(view);
                                frame.add(panel);
                                frame.setVisible(true);
                            }
                        });
                        popupMenu.add(item5);
                    }
                    if (series instanceof DicomSeries) {
                        Object splitNb;
                        popupMenu.add(new JSeparator());
                        item2 = new JMenuItem(Messages.getString("DicomExplorer.sel_rel_series"));
                        item2.addActionListener(new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String fruid = (String)series.getTagValue(TagW.FrameOfReferenceUID);
                                if (fruid != null) {
                                    Collection<MediaSeriesGroup> seriesList;
                                    selList.clear();
                                    MediaSeriesGroup studyGroup = dicomModel.getParent((MediaSeriesGroup)series, DicomModel.study);
                                    Collection<MediaSeriesGroup> collection = seriesList = dicomModel.getChildren(studyGroup);
                                    synchronized (collection) {
                                        for (MediaSeriesGroup seq : seriesList) {
                                            Series s;
                                            if (!(seq instanceof Series) || !fruid.equals((s = (Series)seq).getTagValue(TagW.FrameOfReferenceUID))) continue;
                                            selList.add(s);
                                        }
                                    }
                                }
                            }
                        });
                        popupMenu.add(item2);
                        item2 = new JMenuItem(Messages.getString("DicomExplorer.sel_rel_series_axis"));
                        item2.addActionListener(new ActionListener(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String fruid = (String)series.getTagValue(TagW.FrameOfReferenceUID);
                                if (fruid != null) {
                                    Collection<MediaSeriesGroup> seriesList;
                                    selList.clear();
                                    MediaSeriesGroup studyGroup = dicomModel.getParent((MediaSeriesGroup)series, DicomModel.study);
                                    Collection<MediaSeriesGroup> collection = seriesList = dicomModel.getChildren(studyGroup);
                                    synchronized (collection) {
                                        for (MediaSeriesGroup seq : seriesList) {
                                            Series s;
                                            if (!(seq instanceof Series) || !fruid.equals((s = (Series)seq).getTagValue(TagW.FrameOfReferenceUID)) || !ImageOrientation.hasSameOrientation((MediaSeries)series, (MediaSeries)s)) continue;
                                            selList.add(s);
                                        }
                                    }
                                }
                            }
                        });
                        popupMenu.add(item2);
                        if (loadSeries != null) {
                            JMenuItem item3;
                            if (loadSeries.isStopped()) {
                                popupMenu.add(new JSeparator());
                                item3 = new JMenuItem(Messages.getString("LoadSeries.resume"));
                                item3.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        loadSeries.resume();
                                    }
                                });
                                popupMenu.add(item3);
                            } else if (!loadSeries.isDone()) {
                                popupMenu.add(new JSeparator());
                                item3 = new JMenuItem(Messages.getString("LoadSeries.stop"));
                                item3.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        loadSeries.stop();
                                    }
                                });
                                popupMenu.add(item3);
                            }
                        }
                        if ((splitNb = series.getTagValue(TagW.SplitSeriesNumber)) != null && selList.size() > 1) {
                            String uid = (String)series.getTagValue(TagW.SeriesInstanceUID);
                            boolean sameOrigin = true;
                            if (uid != null) {
                                for (Series s : selList) {
                                    if (uid.equals(s.getTagValue(TagW.SeriesInstanceUID))) continue;
                                    sameOrigin = false;
                                    break;
                                }
                            }
                            if (sameOrigin) {
                                final Series[] seriesList = selList.toArray(new Series[selList.size()]);
                                popupMenu.add(new JSeparator());
                                item2 = new JMenuItem(Messages.getString("DicomExplorer.merge"));
                                item2.addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        selList.clear();
                                        dicomModel.mergeSeries(seriesList);
                                    }
                                });
                                popupMenu.add(item2);
                            }
                        }
                    }
                    popupMenu.add(new JSeparator());
                    item2 = new JMenuItem(Messages.getString("DicomExplorer.rem_series"));
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            dicomModel.removeSeries((MediaSeriesGroup)series);
                        }
                    });
                    popupMenu.add(item2);
                    item2 = new JMenuItem(Messages.getString("DicomExplorer.rem_study"));
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MediaSeriesGroup studyGroup = dicomModel.getParent((MediaSeriesGroup)series, DicomModel.study);
                            dicomModel.removeStudy(studyGroup);
                        }
                    });
                    popupMenu.add(item2);
                    item2 = new JMenuItem(Messages.getString("DicomExplorer.rem_pat"));
                    item2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            MediaSeriesGroup patientGroup = dicomModel.getParent(dicomModel.getParent((MediaSeriesGroup)series, DicomModel.study), DicomModel.patient);
                            dicomModel.removePatient(patientGroup);
                        }
                    });
                    popupMenu.add(item2);
                    if (series.getMedias().size() > 1 && series.getMedia(0) instanceof ImageElement) {
                        popupMenu.add(new JSeparator());
                        JMenu menu = new JMenu("Rebuild Thumbnail");
                        item2 = new JMenuItem("From first image");
                        item2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Thumbnail t = (Thumbnail)series.getTagValue(TagW.Thumbnail);
                                if (t != null) {
                                    t.reBuildThumbnail(MediaSeries.MEDIA_POSITION.FIRST);
                                }
                            }
                        });
                        menu.add(item2);
                        item2 = new JMenuItem("From middle image");
                        item2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Thumbnail t = (Thumbnail)series.getTagValue(TagW.Thumbnail);
                                if (t != null) {
                                    t.reBuildThumbnail(MediaSeries.MEDIA_POSITION.MIDDLE);
                                }
                            }
                        });
                        menu.add(item2);
                        item2 = new JMenuItem("From last image");
                        item2.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                Thumbnail t = (Thumbnail)series.getTagValue(TagW.Thumbnail);
                                if (t != null) {
                                    t.reBuildThumbnail(MediaSeries.MEDIA_POSITION.LAST);
                                }
                            }
                        });
                        menu.add(item2);
                        popupMenu.add(menu);
                    }
                    popupMenu.show(mouseevent.getComponent(), mouseevent.getX() - 5, mouseevent.getY() - 5);
                } else if (selList.contains(series)) {
                    if (mouseevent.isControlDown()) {
                        selList.remove(series);
                    } else {
                        selList.clear();
                        selList.add(series);
                    }
                } else if (mouseevent.isControlDown()) {
                    selList.add(series);
                } else if (mouseevent.isShiftDown()) {
                    if (explorer instanceof DicomExplorer) {
                        ArrayList<Series> seriesList = new ArrayList<Series>();
                        DicomExplorer exp = (DicomExplorer)explorer;
                        for (PatientPane p : exp.patientContainer.getPatientPaneList()) {
                            for (StudyPane studyPane : p.getStudyPaneList()) {
                                for (SeriesPane series2 : studyPane.getSeriesPaneList()) {
                                    if (!(series2.getSequence() instanceof Series)) continue;
                                    seriesList.add((Series)series2.getSequence());
                                }
                            }
                        }
                        int lastIndex = seriesList.indexOf(selList.get(selList.size() - 1));
                        int newIndex = seriesList.indexOf(series);
                        if (lastIndex >= 0 && newIndex >= 0) {
                            if (lastIndex > newIndex) {
                                int temp = lastIndex;
                                lastIndex = newIndex;
                                newIndex = temp;
                            }
                            for (int i = lastIndex; i <= newIndex; ++i) {
                                selList.add((Series)seriesList.get(i));
                            }
                        } else {
                            selList.add(series);
                        }
                    } else {
                        selList.add(series);
                    }
                } else {
                    selList.clear();
                    selList.add(series);
                }
            }
        };
    }

    public static KeyAdapter createThumbnailKeyListener(final Series series, final DicomModel dicomModel) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SeriesSelectionModel selList;
                    DataExplorerView explorer = org.weasis.core.ui.docking.UIManager.getExplorerplugin((String)NAME);
                    SeriesSelectionModel seriesSelectionModel = selList = explorer instanceof DicomExplorer ? ((DicomExplorer)explorer).getSelectionList() : new SeriesSelectionModel(1);
                    if (selList.size() == 0) {
                        selList.add(series);
                    }
                    LoadSeries.openSequenceInDefaultPlugin(selList.toArray(new Series[selList.size()]), dicomModel);
                }
            }
        };
    }

    public Action getOpenExportDialogAction() {
        return null;
    }

    public Action getOpenImportDialogAction() {
        return this.importAction;
    }

    class SeriesPane
    extends JPanel {
        private final MediaSeriesGroup sequence;
        private final JLabel label;
        private final boolean selected;

        public SeriesPane(MediaSeriesGroup sequence) {
            if (sequence == null) {
                throw new IllegalArgumentException("Series cannot be null");
            }
            this.sequence = sequence;
            this.selected = false;
            this.setLayout(new BoxLayout(this, 1));
            int thumbnailSize = DicomExplorer.this.slider.getValue();
            if (sequence instanceof Series) {
                Series series = (Series)sequence;
                Thumbnail thumb = (Thumbnail)series.getTagValue(TagW.Thumbnail);
                if (thumb == null) {
                    thumb = DicomExplorer.createThumbnail(series, DicomExplorer.this.model, thumbnailSize);
                    series.setTag(TagW.Thumbnail, (Object)thumb);
                }
                this.add((Component)thumb);
            }
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.0f);
            String desc = (String)sequence.getTagValue(TagW.SeriesDescription);
            this.label = new JLabel(desc == null ? "" : desc, 0);
            this.label.setFont(FontTools.getFont10());
            this.label.setFocusable(false);
            this.setFocusable(false);
            this.updateSize(thumbnailSize);
            this.add(this.label);
        }

        public void updateSize(int thumbnailSize) {
            Dimension max = this.label.getMaximumSize();
            if (max == null || max.width != thumbnailSize) {
                Series series;
                Thumbnail thumb;
                if (this.sequence instanceof Series && (thumb = (Thumbnail)(series = (Series)this.sequence).getTagValue(TagW.Thumbnail)) != null) {
                    thumb.setThumbnailSize(thumbnailSize);
                }
                FontRenderContext frc = new FontRenderContext(null, false, false);
                Dimension dim = new Dimension(thumbnailSize, (int)(this.label.getFont().getStringBounds("0", frc).getHeight() + 1.0));
                this.label.setPreferredSize(dim);
                this.label.setMaximumSize(dim);
            }
        }

        public void updateText() {
            String desc = (String)this.sequence.getTagValue(TagW.SeriesDescription);
            this.label.setText(desc == null ? "" : desc);
        }

        public boolean isSeries(MediaSeriesGroup sequence) {
            return this.sequence.equals(sequence);
        }

        public MediaSeriesGroup getSequence() {
            return this.sequence;
        }
    }

    class StudyPane
    extends JPanel {
        private final MediaSeriesGroup dicomStudy;
        private final TitleBorder title;

        public StudyPane(MediaSeriesGroup dicomStudy) {
            if (dicomStudy == null) {
                throw new IllegalArgumentException("Study cannot be null");
            }
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.0f);
            this.dicomStudy = dicomStudy;
            this.title = new TitleBorder(dicomStudy.toString());
            this.title.setTitleFont(FontTools.getFont12());
            this.title.setTitleJustification(1);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), this.title));
            this.setFocusable(false);
            this.refreshLayout();
        }

        public boolean isSeriesVisible(MediaSeriesGroup series) {
            for (Component c : this.getComponents()) {
                if (!(c instanceof SeriesPane) || !((SeriesPane)c).isSeries(series)) continue;
                return true;
            }
            return false;
        }

        private List<SeriesPane> getSeriesPaneList() {
            ArrayList<SeriesPane> seriesPaneList = new ArrayList<SeriesPane>();
            for (Component c : this.getComponents()) {
                if (!(c instanceof SeriesPane)) continue;
                seriesPaneList.add((SeriesPane)c);
            }
            return seriesPaneList;
        }

        private void refreshLayout() {
            boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)DicomExplorer.this.getAnchor()) || ToolWindowAnchor.LEFT.equals((Object)DicomExplorer.this.getAnchor());
            this.setLayout((LayoutManager)(vertical ? new WrapLayout(0) : new BoxLayout(this, 0)));
        }

        private void showAllSeries() {
            super.removeAll();
            List seriesList = (List)DicomExplorer.this.study2series.get(this.dicomStudy);
            if (seriesList != null) {
                int thumbnailSize = DicomExplorer.this.slider.getValue();
                for (int i = 0; i < seriesList.size(); ++i) {
                    SeriesPane series = (SeriesPane)seriesList.get(i);
                    series.updateSize(thumbnailSize);
                    this.addPane(series, i);
                }
                this.revalidate();
            }
        }

        public void addPane(SeriesPane seriesPane, int index) {
            seriesPane.updateSize(DicomExplorer.this.slider.getValue());
            this.add((Component)seriesPane, index);
            this.updateText();
        }

        public void updateText() {
            this.title.setTitle(this.dicomStudy.toString());
        }

        public boolean isStudy(MediaSeriesGroup dicomStudy) {
            return this.dicomStudy.equals(dicomStudy);
        }
    }

    class PatientPane
    extends JPanel {
        private final MediaSeriesGroup patient;
        private final GridBagConstraints constraint = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);

        public PatientPane(MediaSeriesGroup patient) {
            if (patient == null) {
                throw new IllegalArgumentException("Patient cannot be null");
            }
            this.patient = patient;
            this.setAlignmentX(0.0f);
            this.setAlignmentY(0.0f);
            this.setFocusable(false);
            this.setLayout(new GridBagLayout());
        }

        public void showTitle(boolean show) {
            if (show) {
                TitleBorder title = new TitleBorder(this.patient.toString());
                title.setTitleFont(FontTools.getFont12Bold());
                title.setTitleJustification(1);
                Color color = UIManager.getColor("ComboBox.buttonHighlight");
                title.setTitleColor(color);
                title.setBorder(BorderFactory.createLineBorder(color, 2));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 25, 5), title));
            } else {
                this.setBorder(null);
            }
        }

        public boolean isStudyVisible(MediaSeriesGroup study) {
            for (Component c : this.getComponents()) {
                StudyPane studyPane;
                if (!(c instanceof StudyPane) || !(studyPane = (StudyPane)c).isStudy(study)) continue;
                return true;
            }
            return false;
        }

        public boolean isSeriesVisible(MediaSeriesGroup series) {
            MediaSeriesGroup study = DicomExplorer.this.model.getParent(series, DicomModel.study);
            for (Component c : this.getComponents()) {
                StudyPane studyPane;
                if (!(c instanceof StudyPane) || !(studyPane = (StudyPane)c).isStudy(study) || !studyPane.isSeriesVisible(series)) continue;
                return true;
            }
            return false;
        }

        private List<StudyPane> getStudyPaneList() {
            ArrayList<StudyPane> studyPaneList = new ArrayList<StudyPane>();
            for (Component c : this.getComponents()) {
                if (!(c instanceof StudyPane)) continue;
                studyPaneList.add((StudyPane)c);
            }
            return studyPaneList;
        }

        private void refreshLayout() {
            List<StudyPane> studies = this.getStudyPaneList();
            super.removeAll();
            for (StudyPane studyPane : studies) {
                studyPane.refreshLayout();
                if (studyPane.getComponentCount() <= 0) continue;
                this.addPane(studyPane);
            }
            this.revalidate();
        }

        private void showAllstudies() {
            super.removeAll();
            List studies = (List)DicomExplorer.this.patient2study.get(this.patient);
            if (studies != null) {
                for (StudyPane studyPane : studies) {
                    studyPane.showAllSeries();
                    studyPane.refreshLayout();
                    if (studyPane.getComponentCount() <= 0) continue;
                    this.addPane(studyPane);
                }
                this.revalidate();
            }
        }

        public void addPane(StudyPane studyPane) {
            this.addPane(studyPane, -1);
        }

        public void addPane(StudyPane studyPane, int position) {
            boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)DicomExplorer.this.getAnchor()) || ToolWindowAnchor.LEFT.equals((Object)DicomExplorer.this.getAnchor());
            this.constraint.gridx = vertical ? 0 : position;
            this.constraint.gridy = vertical ? position : 0;
            this.constraint.weightx = vertical ? 1.0 : 0.0;
            this.constraint.weighty = 0.0;
            this.add((Component)studyPane, this.constraint);
        }

        public boolean isPatient(MediaSeriesGroup patient) {
            return this.patient.equals(patient);
        }
    }

    class PatientContainerPane
    extends JPanel {
        private final GridBagConstraints constraint = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0);
        private final Component filler = Box.createRigidArea(new Dimension(5, 5));

        public PatientContainerPane() {
            DicomExplorer.this.modelPatient.removeAllElements();
            this.setFocusCycleRoot(true);
            this.setFocusTraversalPolicyProvider(true);
            this.setLayout(new GridBagLayout());
        }

        private List<PatientPane> getPatientPaneList() {
            ArrayList<PatientPane> patientPaneList = new ArrayList<PatientPane>();
            for (Component c : this.getComponents()) {
                if (!(c instanceof PatientPane)) continue;
                patientPaneList.add((PatientPane)c);
            }
            return patientPaneList;
        }

        private void refreshLayout() {
            List<PatientPane> list = this.getPatientPaneList();
            super.removeAll();
            for (PatientPane p : list) {
                p.refreshLayout();
                if (p.getComponentCount() <= 0) continue;
                this.addPane(p);
            }
        }

        private void showAllPatients() {
            super.removeAll();
            for (PatientPane patientPane : DicomExplorer.this.patientPaneList) {
                patientPane.showTitle(true);
                patientPane.showAllstudies();
                if (patientPane.getComponentCount() <= 0) continue;
                this.addPane(patientPane);
            }
            this.revalidate();
        }

        public void addPane(PatientPane patientPane, int position) {
            boolean vertical = ToolWindowAnchor.RIGHT.equals((Object)DicomExplorer.this.getAnchor()) || ToolWindowAnchor.LEFT.equals((Object)DicomExplorer.this.getAnchor());
            this.constraint.gridx = vertical ? 0 : position;
            this.constraint.gridy = vertical ? position : 0;
            this.remove(this.filler);
            this.constraint.weightx = vertical ? 1.0 : 0.0;
            this.constraint.weighty = vertical ? 0.0 : 1.0;
            this.add((Component)patientPane, this.constraint);
            this.constraint.weightx = vertical ? 0.0 : 1.0;
            this.constraint.weighty = vertical ? 1.0 : 0.0;
            this.add(this.filler, this.constraint);
        }

        public void addPane(PatientPane patientPane) {
            this.addPane(patientPane, -1);
        }

        public boolean isPatientVisible(MediaSeriesGroup patient) {
            for (Component c : this.getComponents()) {
                if (!(c instanceof PatientPane) || !((PatientPane)c).isPatient(patient)) continue;
                return true;
            }
            return false;
        }

        public boolean isStudyVisible(MediaSeriesGroup study) {
            MediaSeriesGroup patient = DicomExplorer.this.model.getParent(study, DicomModel.patient);
            for (Component c : this.getComponents()) {
                PatientPane patientPane;
                if (!(c instanceof PatientPane) || !(patientPane = (PatientPane)c).isPatient(patient) || !patientPane.isStudyVisible(study)) continue;
                return true;
            }
            return false;
        }

        public boolean isSeriesVisible(MediaSeriesGroup series) {
            MediaSeriesGroup patient = DicomExplorer.this.model.getParent(series, DicomModel.patient);
            for (Component c : this.getComponents()) {
                PatientPane patientPane;
                if (!(c instanceof PatientPane) || !(patientPane = (PatientPane)c).isPatient(patient) || !patientPane.isSeriesVisible(series)) continue;
                return true;
            }
            return false;
        }
    }

    class TitleBorder
    extends TitledBorder {
        public TitleBorder(String title) {
            super(title);
            DicomExplorer.this.setFont(FontTools.getFont10());
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int length;
            FontRenderContext frc = ((Graphics2D)g).getFontRenderContext();
            Rectangle bound = this.getTitleFont().getStringBounds(this.title, frc).getBounds();
            int panelLength = width - 15;
            if (bound.width > panelLength && (length = this.title.length() * panelLength / bound.width) > 2) {
                this.title = this.title.substring(0, length - 2) + "...";
            }
            super.paintBorder(c, g, x, y, width, height);
        }
    }
}

