/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.AreaOpImage;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class SeparableConvolveOpImage
extends AreaOpImage {
    static int byteLoopCounter = 0;
    protected KernelJAI kernel;
    protected int kw;
    protected int kh;
    protected int kx;
    protected int ky;
    protected float[] hValues;
    protected float[] vValues;
    protected float[][] hTables;

    public SeparableConvolveOpImage(RenderedImage renderedImage, BorderExtender borderExtender, Map map, ImageLayout imageLayout, KernelJAI kernelJAI) {
        super(renderedImage, imageLayout, map, true, borderExtender, kernelJAI.getLeftPadding(), kernelJAI.getRightPadding(), kernelJAI.getTopPadding(), kernelJAI.getBottomPadding());
        this.kernel = kernelJAI;
        this.kw = kernelJAI.getWidth();
        this.kh = kernelJAI.getHeight();
        this.kx = kernelJAI.getXOrigin();
        this.ky = kernelJAI.getYOrigin();
        this.hValues = kernelJAI.getHorizontalKernelData();
        this.vValues = kernelJAI.getVerticalKernelData();
        if (this.sampleModel.getDataType() == 0) {
            this.hTables = new float[this.hValues.length][256];
            for (int i = 0; i < this.hValues.length; ++i) {
                float f = this.hValues[i];
                for (int j = 0; j < 256; ++j) {
                    byte by = (byte)j;
                    float f2 = j;
                    this.hTables[i][by + 128] = f * f2;
                }
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        Raster raster = rasterArray[0];
        Rectangle rectangle2 = this.mapDestRect(rectangle, 0);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (rasterAccessor2.getDataType()) {
            case 0: {
                this.byteLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 3: {
                this.intLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 2: {
                this.shortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 1: {
                this.ushortLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 4: {
                this.floatLoop(rasterAccessor, rasterAccessor2);
                break;
            }
            case 5: {
                this.doubleLoop(rasterAccessor, rasterAccessor2);
                break;
            }
        }
        if (rasterAccessor2.isDataCopy()) {
            rasterAccessor2.clampDataArrays();
            rasterAccessor2.copyDataToRaster();
        }
    }

    protected void byteLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        byte[][] byArray = rasterAccessor2.getByteDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        byte[][] byArray2 = rasterAccessor.getByteDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n13 = nArray2[i];
            int n14 = nArray[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    float f = 0.0f;
                    for (int j = 0; j < this.kw; ++j) {
                        f += this.hTables[j][byArray4[n9] + 128];
                        n9 += n6;
                    }
                    fArray[n15 + n10] = f;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18;
                    int n19 = n11;
                    float f = 0.0f;
                    for (n18 = 0; n18 < this.kw; ++n18) {
                        f += this.hTables[n18][byArray4[n19] + 128];
                        n19 += n6;
                    }
                    fArray[n15 + n9] = f;
                    f = 0.5f;
                    n18 = n16 + n9;
                    for (n17 = 0; n17 < this.kh; ++n17) {
                        f += fArray[n18] * this.vValues[n17];
                        if ((n18 += n) < n8) continue;
                        n18 -= n8;
                    }
                    n17 = (int)f;
                    if (n17 < 0) {
                        n17 = 0;
                    } else if (n17 > 255) {
                        n17 = 255;
                    }
                    byArray3[n10] = (byte)n17;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }

    protected void shortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n13 = nArray2[i];
            int n14 = nArray[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    float f = 0.0f;
                    for (int j = 0; j < this.kw; ++j) {
                        f += (float)sArray4[n9] * this.hValues[j];
                        n9 += n6;
                    }
                    fArray[n15 + n10] = f;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18;
                    int n19 = n11;
                    float f = 0.0f;
                    for (n18 = 0; n18 < this.kw; ++n18) {
                        f += (float)sArray4[n19] * this.hValues[n18];
                        n19 += n6;
                    }
                    fArray[n15 + n9] = f;
                    f = 0.5f;
                    n18 = n16 + n9;
                    for (n17 = 0; n17 < this.kh; ++n17) {
                        f += fArray[n18] * this.vValues[n17];
                        if ((n18 += n) < n8) continue;
                        n18 -= n8;
                    }
                    n17 = (int)f;
                    if (n17 < Short.MIN_VALUE) {
                        n17 = Short.MIN_VALUE;
                    } else if (n17 > Short.MAX_VALUE) {
                        n17 = Short.MAX_VALUE;
                    }
                    sArray3[n10] = (short)n17;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }

    protected void ushortLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        short[][] sArray = rasterAccessor2.getShortDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        short[][] sArray2 = rasterAccessor.getShortDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n13 = nArray2[i];
            int n14 = nArray[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    float f = 0.0f;
                    for (int j = 0; j < this.kw; ++j) {
                        f += (float)(sArray4[n9] & 0xFFFF) * this.hValues[j];
                        n9 += n6;
                    }
                    fArray[n15 + n10] = f;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18;
                    int n19 = n11;
                    float f = 0.0f;
                    for (n18 = 0; n18 < this.kw; ++n18) {
                        f += (float)(sArray4[n19] & 0xFFFF) * this.hValues[n18];
                        n19 += n6;
                    }
                    fArray[n15 + n9] = f;
                    f = 0.5f;
                    n18 = n16 + n9;
                    for (n17 = 0; n17 < this.kh; ++n17) {
                        f += fArray[n18] * this.vValues[n17];
                        if ((n18 += n) < n8) continue;
                        n18 -= n8;
                    }
                    n17 = (int)f;
                    if (n17 < 0) {
                        n17 = 0;
                    } else if (n17 > 65535) {
                        n17 = 65535;
                    }
                    sArray3[n10] = (short)n17;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }

    protected void intLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        int[][] nArray = rasterAccessor2.getIntDataArrays();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        int[][] nArray3 = rasterAccessor.getIntDataArrays();
        int[] nArray4 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray = new float[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            int[] nArray5 = nArray[i];
            int[] nArray6 = nArray3[i];
            int n13 = nArray4[i];
            int n14 = nArray2[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    float f = 0.0f;
                    for (int j = 0; j < this.kw; ++j) {
                        f += (float)nArray6[n9] * this.hValues[j];
                        n9 += n6;
                    }
                    fArray[n15 + n10] = f;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18;
                    int n19 = n11;
                    float f = 0.0f;
                    for (n18 = 0; n18 < this.kw; ++n18) {
                        f += (float)nArray6[n19] * this.hValues[n18];
                        n19 += n6;
                    }
                    fArray[n15 + n9] = f;
                    f = 0.5f;
                    n18 = n16 + n9;
                    for (n17 = 0; n17 < this.kh; ++n17) {
                        f += fArray[n18] * this.vValues[n17];
                        if ((n18 += n) < n8) continue;
                        n18 -= n8;
                    }
                    nArray5[n10] = n17 = (int)f;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }

    protected void floatLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        float[][] fArray = rasterAccessor2.getFloatDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        float[][] fArray2 = rasterAccessor.getFloatDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        float[] fArray3 = new float[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            float[] fArray4 = fArray[i];
            float[] fArray5 = fArray2[i];
            int n13 = nArray2[i];
            int n14 = nArray[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    float f = 0.0f;
                    for (int j = 0; j < this.kw; ++j) {
                        f += fArray5[n9] * this.hValues[j];
                        n9 += n6;
                    }
                    fArray3[n15 + n10] = f;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18 = n11;
                    float f = 0.0f;
                    for (n17 = 0; n17 < this.kw; ++n17) {
                        f += fArray5[n18] * this.hValues[n17];
                        n18 += n6;
                    }
                    fArray3[n15 + n9] = f;
                    f = 0.0f;
                    n17 = n16 + n9;
                    for (int j = 0; j < this.kh; ++j) {
                        f += fArray3[n17] * this.vValues[j];
                        if ((n17 += n) < n8) continue;
                        n17 -= n8;
                    }
                    fArray4[n10] = f;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }

    protected void doubleLoop(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor2.getWidth();
        int n2 = rasterAccessor2.getHeight();
        int n3 = rasterAccessor2.getNumBands();
        double[][] dArray = rasterAccessor2.getDoubleDataArrays();
        int[] nArray = rasterAccessor2.getBandOffsets();
        int n4 = rasterAccessor2.getPixelStride();
        int n5 = rasterAccessor2.getScanlineStride();
        double[][] dArray2 = rasterAccessor.getDoubleDataArrays();
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n6 = rasterAccessor.getPixelStride();
        int n7 = rasterAccessor.getScanlineStride();
        double[] dArray3 = new double[this.kh * n];
        int n8 = this.kh * n;
        for (int i = 0; i < n3; ++i) {
            int n9;
            int n10;
            int n11;
            int n12;
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray2[i];
            int n13 = nArray2[i];
            int n14 = nArray[i];
            int n15 = 0;
            int n16 = 0;
            for (n12 = 0; n12 < this.kh - 1; ++n12) {
                n11 = n13;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = n11;
                    double d = 0.0;
                    for (int j = 0; j < this.kw; ++j) {
                        d += dArray5[n9] * (double)this.hValues[j];
                        n9 += n6;
                    }
                    dArray3[n15 + n10] = d;
                    n11 += n6;
                }
                n15 += n;
                n13 += n7;
            }
            for (n12 = 0; n12 < n2; ++n12) {
                n11 = n13;
                n10 = n14;
                for (n9 = 0; n9 < n; ++n9) {
                    int n17;
                    int n18 = n11;
                    double d = 0.0;
                    for (n17 = 0; n17 < this.kw; ++n17) {
                        d += dArray5[n18] * (double)this.hValues[n17];
                        n18 += n6;
                    }
                    dArray3[n15 + n9] = d;
                    d = 0.0;
                    n17 = n16 + n9;
                    for (int j = 0; j < this.kh; ++j) {
                        d += dArray3[n17] * (double)this.vValues[j];
                        if ((n17 += n) < n8) continue;
                        n17 -= n8;
                    }
                    dArray4[n10] = d;
                    n11 += n6;
                    n10 += n4;
                }
                if ((n15 += n) == n8) {
                    n15 = 0;
                }
                if ((n16 += n) == n8) {
                    n16 = 0;
                }
                n13 += n7;
                n14 += n5;
            }
        }
    }
}

