/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ColorCube;
import javax.media.jai.ImageLayout;
import javax.media.jai.KernelJAI;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;

final class OrderedDitherOpImage
extends PointOpImage {
    private static final int TYPE_OD_GENERAL = 0;
    private static final int TYPE_OD_BYTE_LUT_3BAND = 1;
    private static final int TYPE_OD_BYTE_LUT_NBAND = 2;
    private static final int DITHER_LUT_LENGTH_MAX = 262144;
    private static final int DITHER_LUT_CACHE_LENGTH_MAX = 4;
    private static Vector ditherLUTCache = new Vector(0, 4);
    private int odType = 0;
    protected int numBands;
    protected int[] dims;
    protected int[] mults;
    protected int adjustedOffset;
    protected int maskWidth;
    protected int maskHeight;
    protected byte[][] maskDataByte;
    protected int[][] maskDataInt;
    protected long[][] maskDataLong;
    protected float[][] maskDataFloat;
    protected DitherLUT odLUT = null;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, ColorCube colorCube) {
        ColorModel colorModel;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        SampleModel sampleModel = imageLayout2.getSampleModel(renderedImage);
        if (colorCube.getNumBands() == 1 && colorCube.getNumEntries() == 2 && !ImageUtil.isBinary(imageLayout2.getSampleModel(renderedImage))) {
            sampleModel = new MultiPixelPackedSampleModel(0, imageLayout2.getTileWidth(renderedImage), imageLayout2.getTileHeight(renderedImage), 1);
            imageLayout2.setSampleModel(sampleModel);
        }
        if (sampleModel.getNumBands() != 1) {
            sampleModel = RasterFactory.createComponentSampleModel(sampleModel, sampleModel.getTransferType(), sampleModel.getWidth(), sampleModel.getHeight(), 1);
            imageLayout2.setSampleModel(sampleModel);
            colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        if ((imageLayout == null || !imageLayout2.isValid(512)) && renderedImage.getSampleModel().getDataType() == 0 && imageLayout2.getSampleModel(null).getDataType() == 0 && colorCube.getDataType() == 0 && colorCube.getNumBands() == 3 && ((colorModel = renderedImage.getColorModel()) == null || colorModel != null && colorModel.getColorSpace().isCS_sRGB())) {
            int n = colorCube.getNumEntries();
            byte[][] byArray = new byte[3][256];
            for (int i = 0; i < 3; ++i) {
                int n2;
                byte[] byArray2 = byArray[i];
                byte[] byArray3 = colorCube.getByteData(i);
                int n3 = colorCube.getOffset(i);
                int n4 = n3 + n;
                for (n2 = 0; n2 < n3; ++n2) {
                    byArray2[n2] = 0;
                }
                for (n2 = n3; n2 < n4; ++n2) {
                    byArray2[n2] = byArray3[n2 - n3];
                }
                for (n2 = n4; n2 < 256; ++n2) {
                    byArray2[n2] = -1;
                }
            }
            imageLayout2.setColorModel(new IndexColorModel(8, 256, byArray[0], byArray[1], byArray[2]));
        }
        return imageLayout2;
    }

    public OrderedDitherOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, ColorCube colorCube, KernelJAI[] kernelJAIArray) {
        super(renderedImage, OrderedDitherOpImage.layoutHelper(imageLayout, renderedImage, colorCube), map, true);
        this.numBands = colorCube.getNumBands();
        this.mults = (int[])colorCube.getMultipliers().clone();
        this.dims = (int[])colorCube.getDimsLessOne().clone();
        this.adjustedOffset = colorCube.getAdjustedOffset();
        this.maskWidth = kernelJAIArray[0].getWidth();
        this.maskHeight = kernelJAIArray[0].getHeight();
        this.initializeDitherData(this.sampleModel.getTransferType(), kernelJAIArray);
        this.permitInPlaceOperation();
    }

    private void initializeDitherData(int n, KernelJAI[] kernelJAIArray) {
        switch (n) {
            case 0: {
                this.maskDataByte = new byte[kernelJAIArray.length][];
                for (int i = 0; i < this.maskDataByte.length; ++i) {
                    float[] fArray = kernelJAIArray[i].getKernelData();
                    this.maskDataByte[i] = new byte[fArray.length];
                    for (int j = 0; j < fArray.length; ++j) {
                        this.maskDataByte[i][j] = (byte)((int)(fArray[j] * 255.0f) & 0xFF);
                    }
                }
                this.initializeDitherLUT();
                break;
            }
            case 1: 
            case 2: {
                int n2 = 65535;
                this.maskDataInt = new int[kernelJAIArray.length][];
                for (int i = 0; i < this.maskDataInt.length; ++i) {
                    float[] fArray = kernelJAIArray[i].getKernelData();
                    this.maskDataInt[i] = new int[fArray.length];
                    for (int j = 0; j < fArray.length; ++j) {
                        this.maskDataInt[i][j] = (int)(fArray[j] * (float)n2);
                    }
                }
                break;
            }
            case 3: {
                long l = 0xFFFFFFFFL;
                this.maskDataLong = new long[kernelJAIArray.length][];
                for (int i = 0; i < this.maskDataLong.length; ++i) {
                    float[] fArray = kernelJAIArray[i].getKernelData();
                    this.maskDataLong[i] = new long[fArray.length];
                    for (int j = 0; j < fArray.length; ++j) {
                        this.maskDataLong[i][j] = (long)(fArray[j] * (float)l);
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                this.maskDataFloat = new float[kernelJAIArray.length][];
                for (int i = 0; i < this.maskDataFloat.length; ++i) {
                    this.maskDataFloat[i] = kernelJAIArray[i].getKernelData();
                }
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage0"));
            }
        }
    }

    private synchronized void initializeDitherLUT() {
        if (this.numBands * this.maskHeight * this.maskWidth * 256 > 262144) {
            this.odType = 0;
            return;
        }
        this.odType = this.numBands == 3 ? 1 : 2;
        int n = 0;
        while (n < ditherLUTCache.size()) {
            SoftReference softReference = (SoftReference)ditherLUTCache.get(n);
            DitherLUT ditherLUT = (DitherLUT)softReference.get();
            if (ditherLUT == null) {
                ditherLUTCache.remove(n);
                continue;
            }
            if (ditherLUT.equals(this.dims, this.mults, this.maskDataByte)) {
                this.odLUT = ditherLUT;
                break;
            }
            ++n;
        }
        if (this.odLUT == null) {
            this.odLUT = new DitherLUT(this.dims, this.mults, this.maskDataByte);
            if (ditherLUTCache.size() < 4) {
                ditherLUTCache.add(new SoftReference<DitherLUT>(this.odLUT));
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Object object;
        RenderedImage[] renderedImageArray;
        RasterFormatTag[] rasterFormatTagArray = null;
        if (ImageUtil.isBinary(this.getSampleModel()) && !ImageUtil.isBinary(this.getSourceImage(0).getSampleModel())) {
            renderedImageArray = new RenderedImage[]{this.getSourceImage(0)};
            object = RasterAccessor.findCompatibleTags(renderedImageArray, renderedImageArray[0]);
            RasterFormatTag[] rasterFormatTagArray2 = RasterAccessor.findCompatibleTags(renderedImageArray, this);
            rasterFormatTagArray = new RasterFormatTag[]{object[0], rasterFormatTagArray2[1]};
        } else {
            rasterFormatTagArray = this.getFormatTags();
        }
        renderedImageArray = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSource(0).getColorModel());
        object = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        switch (renderedImageArray.getDataType()) {
            case 0: {
                this.computeRectByte((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 2: {
                this.computeRectShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 1: {
                this.computeRectUShort((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 3: {
                this.computeRectInt((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 4: {
                this.computeRectFloat((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            case 5: {
                this.computeRectDouble((RasterAccessor)renderedImageArray, (RasterAccessor)object);
                break;
            }
            default: {
                throw new RuntimeException(JaiI18N.getString("OrderedDitherOpImage1"));
            }
        }
        ((RasterAccessor)object).copyDataToRaster();
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        byte[] byArray2 = rasterAccessor2.getByteDataArray(0);
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        switch (this.odType) {
            case 1: 
            case 2: {
                int[] nArray2 = (int[])nArray.clone();
                int[] nArray3 = (int[])nArray2.clone();
                int n11 = n8;
                for (int i = 0; i < n5; ++i) {
                    int n12 = (n10 + i) % this.maskHeight;
                    if (this.odType == 1) {
                        this.computeLineByteLUT3(byArray, nArray3, n3, byArray2, n11, n7, n4, n9, n12);
                    } else {
                        this.computeLineByteLUTN(byArray, nArray3, n3, byArray2, n11, n7, n4, n9, n12);
                    }
                    for (int j = 0; j < n; ++j) {
                        int n13 = j;
                        nArray2[n13] = nArray2[n13] + n2;
                        nArray3[j] = nArray2[j];
                    }
                    n11 += n6;
                }
                break;
            }
            default: {
                this.computeRectByteGeneral(byArray, nArray, n2, n3, byArray2, n8, n6, n7, n4, n5, n9, n10);
            }
        }
    }

    private void computeLineByteLUT3(byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.odLUT.ditherLUTBandStride;
        int n8 = this.odLUT.ditherLUTRowStride;
        int n9 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n10 = this.adjustedOffset;
        int n11 = n6 * n8;
        int n12 = n11 + n7;
        int n13 = n12 + n7;
        int n14 = n11 + n8;
        int n15 = n5 * n9;
        int n16 = n11 + n15;
        int n17 = n12 + n15;
        int n18 = n13 + n15;
        byte[] byArray4 = byArray[0];
        byte[] byArray5 = byArray[1];
        byte[] byArray6 = byArray[2];
        for (int i = n4; i > 0; --i) {
            int n19 = (byArray3[n16 + (byArray4[nArray[0]] & 0xFF)] & 0xFF) + (byArray3[n17 + (byArray5[nArray[1]] & 0xFF)] & 0xFF) + (byArray3[n18 + (byArray6[nArray[2]] & 0xFF)] & 0xFF);
            byArray2[n2] = (byte)(n19 + n10 & 0xFF);
            nArray[0] = nArray[0] + n;
            nArray[1] = nArray[1] + n;
            nArray[2] = nArray[2] + n;
            n2 += n3;
            if ((n16 += n9) >= n14) {
                n16 = n11;
                n17 = n12;
                n18 = n13;
                continue;
            }
            n17 += n9;
            n18 += n9;
        }
    }

    private void computeLineByteLUTN(byte[][] byArray, int[] nArray, int n, byte[] byArray2, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.odLUT.ditherLUTBandStride;
        int n8 = this.odLUT.ditherLUTRowStride;
        int n9 = this.odLUT.ditherLUTColStride;
        byte[] byArray3 = this.odLUT.ditherLUT;
        int n10 = this.adjustedOffset;
        int n11 = n6 * n8;
        int n12 = n11 + n5 * n9;
        int n13 = n11 + n8;
        for (int i = n4; i > 0; --i) {
            int n14 = n12;
            int n15 = n10;
            int n16 = 0;
            while (n16 < this.numBands) {
                n15 += byArray3[n14 + (byArray[n16][nArray[n16]] & 0xFF)] & 0xFF;
                n14 += n7;
                int n17 = n16++;
                nArray[n17] = nArray[n17] + n;
            }
            byArray2[n2] = (byte)(n15 & 0xFF);
            n2 += n3;
            if ((n12 += n9) < n13) continue;
            n12 = n11;
        }
    }

    private void computeRectByteGeneral(byte[][] byArray, int[] nArray, int n, int n2, byte[] byArray2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        if (this.adjustedOffset > 0) {
            Arrays.fill(byArray2, (byte)(this.adjustedOffset & 0xFF));
        }
        int n11 = nArray.length;
        for (n10 = 0; n10 < n11; ++n10) {
            byte[] byArray3 = byArray[n10];
            byte[] byArray4 = byArray2;
            byte[] byArray5 = this.maskDataByte[n10];
            int n12 = nArray[n10];
            int n13 = n3;
            for (int i = 0; i < n7; ++i) {
                int n14 = (n9 + i) % this.maskHeight;
                int n15 = n14 * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n8;
                int n18 = n12;
                int n19 = n13;
                for (int j = 0; j < n6; ++j) {
                    int n20 = (byArray3[n18] & 0xFF) * this.dims[n10];
                    int n21 = n20 & 0xFF;
                    n20 >>= 8;
                    if (n21 > (byArray5[n17] & 0xFF)) {
                        ++n20;
                    }
                    int n22 = (byArray4[n19] & 0xFF) + n20 * this.mults[n10];
                    byArray4[n19] = (byte)(n22 & 0xFF);
                    n18 += n2;
                    n19 += n5;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
                n12 += n;
                n13 += n4;
            }
        }
        if (this.adjustedOffset < 0) {
            n10 = byArray2.length;
            for (int i = 0; i < n10; ++i) {
                byArray2[i] = (byte)((byArray2[i] & 0xFF) + this.adjustedOffset);
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        for (int i = 0; i < n; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[i];
            int n11 = nArray[i];
            int n12 = n8;
            for (int j = 0; j < n5; ++j) {
                int n13 = n11;
                int n14 = n12;
                n11 += n2;
                n12 += n6;
                int n15 = (n10 + j) % this.maskHeight * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n9;
                for (int k = 0; k < n4; ++k) {
                    int n18 = (sArray3[n13] - Short.MIN_VALUE) * this.dims[i];
                    int n19 = n18 & 0xFFFF;
                    int n20 = (sArray4[n14] & 0xFFFF) + (n18 >> 16) * this.mults[i];
                    if (n19 > nArray2[n17]) {
                        n20 += this.mults[i];
                    }
                    sArray4[n14] = (short)(n20 & 0xFFFF);
                    n13 += n3;
                    n14 += n7;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        short[] sArray2 = rasterAccessor2.getShortDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(sArray2, (short)(this.adjustedOffset & 0xFFFF));
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        for (int i = 0; i < n; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2;
            int[] nArray2 = this.maskDataInt[i];
            int n11 = nArray[i];
            int n12 = n8;
            for (int j = 0; j < n5; ++j) {
                int n13 = n11;
                int n14 = n12;
                n11 += n2;
                n12 += n6;
                int n15 = (n10 + j) % this.maskHeight * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n9;
                for (int k = 0; k < n4; ++k) {
                    int n18 = (sArray3[n13] & 0xFFFF) * this.dims[i];
                    int n19 = n18 & 0xFFFF;
                    int n20 = (sArray4[n14] & 0xFFFF) + (n18 >> 16) * this.mults[i];
                    if (n19 > nArray2[n17]) {
                        n20 += this.mults[i];
                    }
                    sArray4[n14] = (short)(n20 & 0xFFFF);
                    n13 += n3;
                    n14 += n7;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        int[] nArray3 = rasterAccessor2.getIntDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(nArray3, this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        for (int i = 0; i < n; ++i) {
            int[] nArray4 = nArray2[i];
            int[] nArray5 = nArray3;
            long[] lArray = this.maskDataLong[i];
            int n11 = nArray[i];
            int n12 = n8;
            for (int j = 0; j < n5; ++j) {
                int n13 = n11;
                int n14 = n12;
                n11 += n2;
                n12 += n6;
                int n15 = (n10 + j) % this.maskHeight * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n9;
                for (int k = 0; k < n4; ++k) {
                    long l = ((long)nArray4[n13] - Integer.MIN_VALUE) * (long)this.dims[i];
                    long l2 = l & 0xFFFFFFFFFFFFFFFFL;
                    int n18 = nArray5[n14] + (int)(l >> 32) * this.mults[i];
                    if (l2 > lArray[n17]) {
                        n18 += this.mults[i];
                    }
                    nArray5[n14] = n18;
                    n13 += n3;
                    n14 += n7;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        float[] fArray2 = rasterAccessor2.getFloatDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(fArray2, (float)this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        for (int i = 0; i < n; ++i) {
            float[] fArray3 = fArray[i];
            float[] fArray4 = fArray2;
            float[] fArray5 = this.maskDataFloat[i];
            int n11 = nArray[i];
            int n12 = n8;
            for (int j = 0; j < n5; ++j) {
                int n13 = n11;
                int n14 = n12;
                n11 += n2;
                n12 += n6;
                int n15 = (n10 + j) % this.maskHeight * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n9;
                for (int k = 0; k < n4; ++k) {
                    int n18 = (int)(fArray3[n13] * (float)this.dims[i]);
                    float f = fArray3[n13] * (float)this.dims[i] - (float)n18;
                    float f2 = fArray4[n14] + (float)(n18 * this.mults[i]);
                    if (f > fArray5[n17]) {
                        f2 += (float)this.mults[i];
                    }
                    fArray4[n14] = f2;
                    n13 += n3;
                    n14 += n7;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getNumBands();
        int n2 = rasterAccessor.getScanlineStride();
        int n3 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n4 = rasterAccessor2.getWidth();
        int n5 = rasterAccessor2.getHeight();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int n8 = rasterAccessor2.getBandOffset(0);
        double[] dArray2 = rasterAccessor2.getDoubleDataArray(0);
        if (this.adjustedOffset != 0) {
            Arrays.fill(dArray2, (double)this.adjustedOffset);
        }
        int n9 = rasterAccessor2.getX() % this.maskWidth;
        int n10 = rasterAccessor2.getY();
        for (int i = 0; i < n; ++i) {
            double[] dArray3 = dArray[i];
            double[] dArray4 = dArray2;
            float[] fArray = this.maskDataFloat[i];
            int n11 = nArray[i];
            int n12 = n8;
            for (int j = 0; j < n5; ++j) {
                int n13 = n11;
                int n14 = n12;
                n11 += n2;
                n12 += n6;
                int n15 = (n10 + j) % this.maskHeight * this.maskWidth;
                int n16 = n15 + this.maskWidth;
                int n17 = n15 + n9;
                for (int k = 0; k < n4; ++k) {
                    int n18 = (int)(dArray3[n13] * (double)this.dims[i]);
                    float f = (float)(dArray3[n13] * (double)this.dims[i] - (double)n18);
                    double d = dArray4[n14] + (double)(n18 * this.mults[i]);
                    if (f > fArray[n17]) {
                        d += (double)this.mults[i];
                    }
                    dArray4[n14] = d;
                    n13 += n3;
                    n14 += n7;
                    if (++n17 < n16) continue;
                    n17 = n15;
                }
            }
        }
    }

    private class DitherLUT {
        private int[] dimsCache;
        private int[] multsCache;
        private byte[][] maskDataCache;
        public int ditherLUTBandStride;
        public int ditherLUTRowStride;
        public int ditherLUTColStride;
        public byte[] ditherLUT;

        DitherLUT(int[] nArray, int[] nArray2, byte[][] byArray) {
            int n;
            this.dimsCache = (int[])nArray.clone();
            this.multsCache = (int[])nArray2.clone();
            this.maskDataCache = new byte[byArray.length][];
            for (n = 0; n < byArray.length; ++n) {
                this.maskDataCache[n] = (byte[])byArray[n].clone();
            }
            this.ditherLUTColStride = 256;
            this.ditherLUTRowStride = OrderedDitherOpImage.this.maskWidth * this.ditherLUTColStride;
            this.ditherLUTBandStride = OrderedDitherOpImage.this.maskHeight * this.ditherLUTRowStride;
            this.ditherLUT = new byte[OrderedDitherOpImage.this.numBands * this.ditherLUTBandStride];
            n = 0;
            int n2 = OrderedDitherOpImage.this.maskWidth * OrderedDitherOpImage.this.maskHeight;
            for (int i = 0; i < OrderedDitherOpImage.this.numBands; ++i) {
                int n3 = nArray[i];
                int n4 = nArray2[i];
                byte[] byArray2 = byArray[i];
                int n5 = 0;
                for (int j = 0; j < 256; ++j) {
                    int n6 = n5;
                    int n7 = n6 & 0xFF;
                    int n8 = n6 >> 8;
                    int n9 = n8 * n4;
                    int n10 = n9 + n4;
                    int n11 = n + j;
                    for (int k = 0; k < n2; ++k) {
                        int n12 = byArray2[k] & 0xFF;
                        this.ditherLUT[n11] = n7 > n12 ? (byte)(n10 & 0xFF) : (byte)(n9 & 0xFF);
                        n11 += 256;
                    }
                    n5 += n3;
                }
                n += this.ditherLUTBandStride;
            }
        }

        public boolean equals(int[] nArray, int[] nArray2, byte[][] byArray) {
            int n;
            if (nArray.length != this.dimsCache.length) {
                return false;
            }
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] == this.dimsCache[n]) continue;
                return false;
            }
            if (nArray2.length != this.multsCache.length) {
                return false;
            }
            for (n = 0; n < nArray2.length; ++n) {
                if (nArray2[n] == this.multsCache[n]) continue;
                return false;
            }
            if (byArray.length != OrderedDitherOpImage.this.maskDataByte.length) {
                return false;
            }
            for (n = 0; n < byArray.length; ++n) {
                if (byArray[n].length != this.maskDataCache[n].length) {
                    return false;
                }
                byte[] byArray2 = this.maskDataCache[n];
                byte[] byArray3 = byArray[n];
                for (int i = 0; i < byArray[n].length; ++i) {
                    if (byArray3[i] == byArray2[i]) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

