/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PointOpImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class MaxOpImage
extends PointOpImage {
    private static long negativeZeroFloatBits = Float.floatToIntBits(-0.0f);
    private static long negativeZeroDoubleBits = Double.doubleToLongBits(-0.0);
    private static byte[] byteTable = null;
    private static SoftReference softRef = null;

    private synchronized void allocByteTable() {
        if (softRef == null || softRef.get() == null) {
            byteTable = new byte[65536];
            softRef = new SoftReference<byte[]>(byteTable);
            boolean bl = false;
            for (int i = 0; i < 256; ++i) {
                int n;
                int n2 = i << 8;
                for (n = 0; n < i; ++n) {
                    MaxOpImage.byteTable[n2 + n] = (byte)i;
                }
                for (n = i; n < 256; ++n) {
                    MaxOpImage.byteTable[n2 + n] = (byte)n;
                }
            }
        }
    }

    public MaxOpImage(RenderedImage renderedImage, RenderedImage renderedImage2, Map map, ImageLayout imageLayout) {
        super(renderedImage, renderedImage2, imageLayout, map, true);
        if (this.sampleModel.getTransferType() == 0) {
            this.allocByteTable();
        }
        this.permitInPlaceOperation();
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(rasterArray[1], rectangle, rasterFormatTagArray[1], this.getSourceImage(1).getColorModel());
        RasterAccessor rasterAccessor3 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[2], this.getColorModel());
        switch (rasterAccessor3.getDataType()) {
            case 0: {
                this.computeRectByte(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 1: {
                this.computeRectUShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 2: {
                this.computeRectShort(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 3: {
                this.computeRectInt(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 4: {
                this.computeRectFloat(rasterAccessor, rasterAccessor2, rasterAccessor3);
                break;
            }
            case 5: {
                this.computeRectDouble(rasterAccessor, rasterAccessor2, rasterAccessor3);
            }
        }
        if (rasterAccessor3.isDataCopy()) {
            rasterAccessor3.clampDataArrays();
            rasterAccessor3.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        byte[][] byArray3 = rasterAccessor3.getByteDataArrays();
        for (int i = 0; i < n7; ++i) {
            byte[] byArray4 = byArray[i];
            byte[] byArray5 = byArray2[i];
            byte[] byArray6 = byArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                int n16 = n15 + n5 * n9;
                while (n15 < n16) {
                    int n17 = byArray4[n13] & 0xFF;
                    int n18 = byArray5[n14] & 0xFF;
                    byArray6[n15] = byteTable[(n17 << 8) + n18];
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        for (int i = 0; i < n7; ++i) {
            short[] sArray4 = sArray[i];
            short[] sArray5 = sArray2[i];
            short[] sArray6 = sArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                for (int k = 0; k < n5; ++k) {
                    sArray6[n15] = this.maxUShort(sArray4[n13], sArray5[n14]);
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        short[][] sArray3 = rasterAccessor3.getShortDataArrays();
        for (int i = 0; i < n7; ++i) {
            short[] sArray4 = sArray[i];
            short[] sArray5 = sArray2[i];
            short[] sArray6 = sArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                for (int k = 0; k < n5; ++k) {
                    sArray6[n15] = this.maxShort(sArray4[n13], sArray5[n14]);
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray5 = rasterAccessor3.getBandOffsets();
        int[][] nArray6 = rasterAccessor3.getIntDataArrays();
        for (int i = 0; i < n7; ++i) {
            int[] nArray7 = nArray2[i];
            int[] nArray8 = nArray4[i];
            int[] nArray9 = nArray6[i];
            int n10 = nArray[i];
            int n11 = nArray3[i];
            int n12 = nArray5[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                for (int k = 0; k < n5; ++k) {
                    nArray9[n15] = this.maxInt(nArray7[n13], nArray8[n14]);
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private void computeRectFloat(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        float[][] fArray2 = rasterAccessor2.getFloatDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        float[][] fArray3 = rasterAccessor3.getFloatDataArrays();
        for (int i = 0; i < n7; ++i) {
            float[] fArray4 = fArray[i];
            float[] fArray5 = fArray2[i];
            float[] fArray6 = fArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                for (int k = 0; k < n5; ++k) {
                    fArray6[n15] = this.maxFloat(fArray4[n13], fArray5[n14]);
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private void computeRectDouble(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2, RasterAccessor rasterAccessor3) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n3 = rasterAccessor2.getScanlineStride();
        int n4 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        double[][] dArray2 = rasterAccessor2.getDoubleDataArrays();
        int n5 = rasterAccessor3.getWidth();
        int n6 = rasterAccessor3.getHeight();
        int n7 = rasterAccessor3.getNumBands();
        int n8 = rasterAccessor3.getScanlineStride();
        int n9 = rasterAccessor3.getPixelStride();
        int[] nArray3 = rasterAccessor3.getBandOffsets();
        double[][] dArray3 = rasterAccessor3.getDoubleDataArrays();
        for (int i = 0; i < n7; ++i) {
            double[] dArray4 = dArray[i];
            double[] dArray5 = dArray2[i];
            double[] dArray6 = dArray3[i];
            int n10 = nArray[i];
            int n11 = nArray2[i];
            int n12 = nArray3[i];
            for (int j = 0; j < n6; ++j) {
                int n13 = n10;
                int n14 = n11;
                int n15 = n12;
                n10 += n;
                n11 += n3;
                n12 += n8;
                for (int k = 0; k < n5; ++k) {
                    dArray6[n15] = this.maxDouble(dArray4[n13], dArray5[n14]);
                    n13 += n2;
                    n14 += n4;
                    n15 += n9;
                }
            }
        }
    }

    private final short maxUShort(short s, short s2) {
        return (s & 0xFFFF) > (s2 & 0xFFFF) ? s : s2;
    }

    private final short maxShort(short s, short s2) {
        return s > s2 ? s : s2;
    }

    private final int maxInt(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private final float maxFloat(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && (long)Float.floatToIntBits(f) == negativeZeroFloatBits) {
            return f2;
        }
        return f >= f2 ? f : f2;
    }

    private final double maxDouble(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && Double.doubleToLongBits(d) == negativeZeroDoubleBits) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }
}

