/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ColormapOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

final class InvertOpImage
extends ColormapOpImage {
    public InvertOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout) {
        super(renderedImage, imageLayout, map, true);
        this.permitInPlaceOperation();
        this.initializeColormapOperation();
    }

    protected void transformColormap(byte[][] byArray) {
        for (int i = 0; i < 3; ++i) {
            byte[] byArray2 = byArray[i];
            int n = byArray2.length;
            for (int j = 0; j < n; ++j) {
                byArray2[j] = (byte)(255 - (byArray2[j] & 0xFF));
            }
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(rasterArray[0], rectangle, rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        if (rasterAccessor2.isBinary()) {
            byte[] byArray = rasterAccessor.getBinaryDataArray();
            byte[] byArray2 = rasterAccessor2.getBinaryDataArray();
            int n = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray2[i] = ~byArray[i];
            }
            rasterAccessor2.copyBinaryDataToRaster();
        } else {
            switch (rasterAccessor2.getDataType()) {
                case 0: {
                    this.computeRectByte(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 1: {
                    this.computeRectUShort(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 2: {
                    this.computeRectShort(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 3: {
                    this.computeRectInt(rasterAccessor, rasterAccessor2);
                    break;
                }
                case 4: 
                case 5: {
                    throw new RuntimeException(JaiI18N.getString("InvertOpImage0"));
                }
            }
            rasterAccessor2.copyDataToRaster();
        }
    }

    private void computeRectByte(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        byte[][] byArray2 = rasterAccessor2.getByteDataArrays();
        for (int i = 0; i < n5; ++i) {
            byte[] byArray3 = byArray[i];
            byte[] byArray4 = byArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n;
                n9 += n6;
                int n12 = n11 + n3 * n7;
                while (n11 < n12) {
                    byArray4[n11] = (byte)(255 - (byArray3[n10] & 0xFF));
                    n10 += n2;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectUShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n;
                n9 += n6;
                int n12 = n11 + n3 * n7;
                while (n11 < n12) {
                    sArray4[n11] = (short)(65535 - (sArray3[n10] & 0xFFFF));
                    n10 += n2;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectShort(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray2 = rasterAccessor2.getBandOffsets();
        short[][] sArray2 = rasterAccessor2.getShortDataArrays();
        for (int i = 0; i < n5; ++i) {
            short[] sArray3 = sArray[i];
            short[] sArray4 = sArray2[i];
            int n8 = nArray[i];
            int n9 = nArray2[i];
            for (int j = 0; j < n4; ++j) {
                int n10 = n8;
                int n11 = n9;
                n8 += n;
                n9 += n6;
                int n12 = n11 + n3 * n7;
                while (n11 < n12) {
                    sArray4[n11] = (short)(Short.MAX_VALUE - sArray3[n10]);
                    n10 += n2;
                    n11 += n7;
                }
            }
        }
    }

    private void computeRectInt(RasterAccessor rasterAccessor, RasterAccessor rasterAccessor2) {
        int n = rasterAccessor.getScanlineStride();
        int n2 = rasterAccessor.getPixelStride();
        int[] nArray = rasterAccessor.getBandOffsets();
        int[][] nArray2 = rasterAccessor.getIntDataArrays();
        int n3 = rasterAccessor2.getWidth();
        int n4 = rasterAccessor2.getHeight();
        int n5 = rasterAccessor2.getNumBands();
        int n6 = rasterAccessor2.getScanlineStride();
        int n7 = rasterAccessor2.getPixelStride();
        int[] nArray3 = rasterAccessor2.getBandOffsets();
        int[][] nArray4 = rasterAccessor2.getIntDataArrays();
        int[] nArray5 = nArray2[0];
        int[] nArray6 = nArray4[0];
        int n8 = nArray6.length;
        switch (this.sampleModel.getTransferType()) {
            case 0: {
                for (int i = 0; i < n8; ++i) {
                    nArray6[i] = ~nArray5[i] & 0xFF;
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n8; ++i) {
                    nArray6[i] = ~nArray5[i] & 0xFFFF;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n8; ++i) {
                    nArray6[i] = Short.MAX_VALUE - nArray5[i];
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n5; ++i) {
                    nArray5 = nArray2[i];
                    nArray6 = nArray4[i];
                    int n9 = nArray[i];
                    int n10 = nArray3[i];
                    for (int j = 0; j < n4; ++j) {
                        int n11 = n9;
                        int n12 = n10;
                        n9 += n;
                        n10 += n6;
                        int n13 = n12 + n3 * n7;
                        while (n12 < n13) {
                            nArray6[n12] = Integer.MAX_VALUE - nArray5[n11];
                            n11 += n2;
                            n12 += n7;
                        }
                    }
                }
                break;
            }
        }
    }
}

