/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.FFT;
import com.sun.media.jai.opimage.JaiI18N;
import com.sun.media.jai.util.JDKWorkarounds;
import com.sun.media.jai.util.MathJAI;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.UntiledOpImage;
import javax.media.jai.operator.DFTDescriptor;

public class DFTOpImage
extends UntiledOpImage {
    FFT fft;
    protected boolean complexSrc;
    protected boolean complexDst;

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage, EnumeratedParameter enumeratedParameter) {
        int n;
        int n2;
        int n3;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        imageLayout2.setMinX(renderedImage.getMinX());
        imageLayout2.setMinY(renderedImage.getMinY());
        int n4 = imageLayout2.getWidth(renderedImage);
        int n5 = imageLayout2.getHeight(renderedImage);
        if (n4 == 1 && n5 == 1) {
            n3 = 1;
            n2 = 1;
        } else if (n4 == 1 && n5 > 1) {
            n2 = 1;
            n3 = MathJAI.nextPositivePowerOf2(n5);
        } else if (n4 > 1 && n5 == 1) {
            n2 = MathJAI.nextPositivePowerOf2(n4);
            n3 = 1;
        } else {
            n2 = MathJAI.nextPositivePowerOf2(n4);
            n3 = MathJAI.nextPositivePowerOf2(n5);
        }
        imageLayout2.setWidth(n2);
        imageLayout2.setHeight(n3);
        boolean bl = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        boolean bl2 = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
        boolean bl3 = false;
        SampleModel sampleModel = renderedImage.getSampleModel();
        int n6 = sampleModel.getNumBands();
        if (bl && !bl2) {
            n6 /= 2;
        } else if (!bl && bl2) {
            n6 *= 2;
        }
        SampleModel sampleModel2 = imageLayout2.getSampleModel(renderedImage);
        int n7 = sampleModel2.getNumBands();
        if (n7 != n6) {
            n7 = n6;
            bl3 = true;
        }
        if ((n = sampleModel2.getTransferType()) != 4 && n != 5) {
            n = 4;
            bl3 = true;
        }
        if (bl3) {
            sampleModel2 = RasterFactory.createComponentSampleModel(sampleModel2, n, n2, n3, n7);
            imageLayout2.setSampleModel(sampleModel2);
            ColorModel colorModel = imageLayout2.getColorModel(null);
            if (colorModel != null && !JDKWorkarounds.areCompatibleDataModels(sampleModel2, colorModel)) {
                imageLayout2.unsetValid(512);
            }
        }
        return imageLayout2;
    }

    public DFTOpImage(RenderedImage renderedImage, Map map, ImageLayout imageLayout, EnumeratedParameter enumeratedParameter, FFT fFT) {
        super(renderedImage, map, DFTOpImage.layoutHelper(imageLayout, renderedImage, enumeratedParameter));
        this.fft = fFT;
        this.complexSrc = !enumeratedParameter.equals(DFTDescriptor.REAL_TO_COMPLEX);
        this.complexDst = !enumeratedParameter.equals(DFTDescriptor.COMPLEX_TO_REAL);
    }

    public Point2D mapDestPoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    public Point2D mapSourcePoint(Point2D point2D) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return null;
    }

    protected void computeImage(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        Raster raster = rasterArray[0];
        if (rectangle.width == 1 && rectangle.height == 1) {
            int n = this.sampleModel.getNumBands();
            double[] dArray = new double[raster.getSampleModel().getNumBands()];
            raster.getPixel(rectangle.x, rectangle.y, dArray);
            if (this.complexSrc && this.complexDst) {
                writableRaster.setPixel(rectangle.x, rectangle.y, dArray);
            } else if (this.complexSrc) {
                for (int i = 0; i < n; ++i) {
                    writableRaster.setSample(rectangle.x, rectangle.y, i, dArray[2 * i]);
                }
            } else if (this.complexDst) {
                for (int i = 0; i < n; ++i) {
                    writableRaster.setSample(rectangle.x, rectangle.y, i, i % 2 == 0 ? dArray[i / 2] : 0.0);
                }
            } else {
                throw new RuntimeException(JaiI18N.getString("DFTOpImage1"));
            }
            return;
        }
        this.fft.setLength(rectangle.width > 1 ? this.getWidth() : this.getHeight());
        int n = raster.getWidth();
        int n2 = raster.getHeight();
        int n3 = raster.getMinX();
        int n4 = raster.getMinY();
        RasterFormatTag[] rasterFormatTagArray = this.getFormatTags();
        RasterAccessor rasterAccessor = new RasterAccessor(raster, new Rectangle(n3, n4, n, n2), rasterFormatTagArray[0], this.getSourceImage(0).getColorModel());
        RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle, rasterFormatTagArray[1], this.getColorModel());
        int n5 = rasterAccessor.getDataType();
        int n6 = rasterAccessor2.getDataType();
        int n7 = rasterAccessor.getPixelStride();
        int n8 = rasterAccessor.getScanlineStride();
        int n9 = rasterAccessor2.getPixelStride();
        int n10 = rasterAccessor2.getScanlineStride();
        int n11 = 1;
        int n12 = rectangle.width;
        if (this.complexDst) {
            n11 = n9;
            n12 = n10;
        }
        int n13 = 0;
        int n14 = this.complexSrc ? 2 : 1;
        int n15 = 0;
        int n16 = this.complexDst ? 2 : 1;
        int n17 = this.complexDst ? writableRaster.getSampleModel().getNumBands() / 2 : writableRaster.getSampleModel().getNumBands();
        for (int i = 0; i < n17; ++i) {
            int n18;
            int n19;
            int n20;
            int n21;
            Object object = rasterAccessor.getDataArray(n13);
            Object object2 = null;
            if (this.complexSrc) {
                object2 = rasterAccessor.getDataArray(n13 + 1);
            }
            Object object3 = rasterAccessor2.getDataArray(n15);
            Object object4 = null;
            object4 = this.complexDst ? rasterAccessor2.getDataArray(n15 + 1) : (n6 == 4 ? (Object)new float[rectangle.width * rectangle.height] : (Object)new double[rectangle.width * rectangle.height]);
            if (rectangle.width > 1) {
                this.fft.setLength(this.getWidth());
                n21 = rasterAccessor.getBandOffset(n13);
                n20 = 0;
                if (this.complexSrc) {
                    n20 = rasterAccessor.getBandOffset(n13 + 1);
                }
                n19 = rasterAccessor2.getBandOffset(n15);
                n18 = 0;
                if (this.complexDst) {
                    n18 = rasterAccessor2.getBandOffset(n15 + 1);
                }
                for (int j = 0; j < n2; ++j) {
                    this.fft.setData(n5, object, n21, n7, object2, n20, n7, n);
                    this.fft.transform();
                    this.fft.getData(n6, object3, n19, n9, object4, n18, n11);
                    n21 += n8;
                    n20 += n8;
                    n19 += n10;
                    n18 += n12;
                }
            }
            if (rectangle.width == 1) {
                n21 = rasterAccessor.getBandOffset(n13);
                n20 = 0;
                if (this.complexSrc) {
                    n20 = rasterAccessor.getBandOffset(n13 + 1);
                }
                n19 = rasterAccessor2.getBandOffset(n15);
                n18 = 0;
                if (this.complexDst) {
                    n18 = rasterAccessor2.getBandOffset(n15 + 1);
                }
                this.fft.setData(n5, object, n21, n8, object2, n20, n8, n2);
                this.fft.transform();
                this.fft.getData(n6, object3, n19, n10, object4, n18, n12);
            } else if (rectangle.height > 1) {
                this.fft.setLength(this.getHeight());
                n21 = rasterAccessor2.getBandOffset(n15);
                n20 = 0;
                if (this.complexDst) {
                    n20 = rasterAccessor2.getBandOffset(n15 + 1);
                }
                for (n19 = 0; n19 < rectangle.width; ++n19) {
                    this.fft.setData(n6, object3, n21, n10, object4, n20, n12, rectangle.height);
                    this.fft.transform();
                    this.fft.getData(n6, object3, n21, n10, this.complexDst ? object4 : null, n20, n12);
                    n21 += n9;
                    n20 += n11;
                }
            }
            n13 += n14;
            n15 += n16;
        }
        if (rasterAccessor2.needsClamping()) {
            rasterAccessor2.clampDataArrays();
        }
        rasterAccessor2.copyDataToRaster();
    }
}

