/*
 * Decompiled with CFR 0.152.
 */
package org.weasis.dicom.viewer2d;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import org.noos.xing.mydoggy.Content;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.weasis.core.api.explorer.DataExplorerView;
import org.weasis.core.api.explorer.ObservableEvent;
import org.weasis.core.api.gui.util.AbstractProperties;
import org.weasis.core.api.gui.util.ActionState;
import org.weasis.core.api.gui.util.ActionW;
import org.weasis.core.api.gui.util.ComboItemListener;
import org.weasis.core.api.gui.util.GuiExecutor;
import org.weasis.core.api.gui.util.SliderChangeListener;
import org.weasis.core.api.gui.util.SliderCineListener;
import org.weasis.core.api.gui.util.ToggleButtonListener;
import org.weasis.core.api.image.GridBagLayoutModel;
import org.weasis.core.api.image.LayoutConstraints;
import org.weasis.core.api.media.data.MediaElement;
import org.weasis.core.api.media.data.MediaSeries;
import org.weasis.core.api.media.data.MediaSeriesGroup;
import org.weasis.core.api.media.data.Series;
import org.weasis.core.api.media.data.SeriesEvent;
import org.weasis.core.api.media.data.TagW;
import org.weasis.core.ui.docking.PluginTool;
import org.weasis.core.ui.docking.UIManager;
import org.weasis.core.ui.editor.SeriesViewerListener;
import org.weasis.core.ui.editor.image.DefaultView2d;
import org.weasis.core.ui.editor.image.ImageViewerEventManager;
import org.weasis.core.ui.editor.image.ImageViewerPlugin;
import org.weasis.core.ui.editor.image.SynchView;
import org.weasis.core.ui.editor.image.ViewerToolBar;
import org.weasis.core.ui.editor.image.dockable.MeasureTool;
import org.weasis.core.ui.editor.image.dockable.MiniTool;
import org.weasis.core.ui.util.WtoolBar;
import org.weasis.dicom.codec.DicomImageElement;
import org.weasis.dicom.codec.DicomSeries;
import org.weasis.dicom.explorer.DicomExplorer;
import org.weasis.dicom.explorer.DicomModel;
import org.weasis.dicom.viewer2d.EventManager;
import org.weasis.dicom.viewer2d.Messages;
import org.weasis.dicom.viewer2d.MprView;
import org.weasis.dicom.viewer2d.ResetTools;
import org.weasis.dicom.viewer2d.View2d;
import org.weasis.dicom.viewer2d.View2dFactory;
import org.weasis.dicom.viewer2d.dockable.DisplayTool;
import org.weasis.dicom.viewer2d.dockable.ImageTool;

public class View2dContainer
extends ImageViewerPlugin<DicomImageElement>
implements PropertyChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(View2dContainer.class);
    public static final GridBagLayoutModel VIEWS_2x1_r1xc2_dump = new GridBagLayoutModel(View2dContainer.class.getResourceAsStream("/config/layoutModel.xml"), Messages.getString("View2dContainer.layout_dump"), (Icon)new ImageIcon(View2dContainer.class.getResource("/icon/22x22/layout1x2_c2.png")));
    public static final GridBagLayoutModel VIEWS_2x2_mpr = new GridBagLayoutModel(new LinkedHashMap(3), "Orthogonal MPR", null);
    public static final GridBagLayoutModel[] MODELS;
    private static PluginTool[] toolPanels;
    private static WtoolBar statusBar;
    private static WtoolBar[] toolBars;

    public View2dContainer() {
        this(VIEWS_1x1);
    }

    public View2dContainer(GridBagLayoutModel layoutModel) {
        super((ImageViewerEventManager)EventManager.getInstance(), layoutModel, View2dFactory.NAME, View2dFactory.ICON, null);
        this.setSynchView(SynchView.DEFAULT_STACK);
    }

    public void setSelectedImagePaneFromFocus(DefaultView2d<DicomImageElement> defaultView2d) {
        this.setSelectedImagePane(defaultView2d);
        if (defaultView2d != null && defaultView2d.getSeries() instanceof DicomSeries) {
            DicomSeries.startPreloading((DicomSeries)((DicomSeries)defaultView2d.getSeries()), (int)defaultView2d.getFrameIndex());
        }
    }

    public JMenu fillSelectedPluginMenu(JMenu menuRoot) {
        if (menuRoot != null) {
            ActionState rotateAction;
            ActionState stackAction;
            ActionState filterAction;
            ActionState lutAction;
            ActionState presetAction;
            menuRoot.removeAll();
            menuRoot.setText(View2dFactory.NAME);
            ActionState viewingAction = this.eventManager.getAction(ActionW.VIEWINGPROTOCOL);
            if (viewingAction instanceof ComboItemListener) {
                menuRoot.add(((ComboItemListener)viewingAction).createMenu(Messages.getString("View2dContainer.view_protocols")));
            }
            if ((presetAction = this.eventManager.getAction(ActionW.PRESET)) instanceof ComboItemListener) {
                menuRoot.add(((ComboItemListener)presetAction).createMenu(Messages.getString("View2dContainer.presets")));
            }
            if ((lutAction = this.eventManager.getAction(ActionW.LUT)) instanceof ComboItemListener) {
                JMenu menu = ((ComboItemListener)lutAction).createMenu(Messages.getString("View2dContainer.lut"));
                ActionState invlutAction = this.eventManager.getAction(ActionW.INVERSELUT);
                if (invlutAction instanceof ToggleButtonListener) {
                    menu.add(new JSeparator());
                    menu.add(((ToggleButtonListener)invlutAction).createMenu(Messages.getString("View2dContainer.inv_lut")));
                }
                menuRoot.add(menu);
            }
            if ((filterAction = this.eventManager.getAction(ActionW.FILTER)) instanceof ComboItemListener) {
                JMenu menu = ((ComboItemListener)filterAction).createMenu(Messages.getString("View2dContainer.filter"));
                menuRoot.add(menu);
            }
            if ((stackAction = this.eventManager.getAction(ActionW.SORTSTACK)) instanceof ComboItemListener) {
                JMenu menu = ((ComboItemListener)stackAction).createMenu(Messages.getString("View2dContainer.sort_stack"));
                ActionState invstackAction = this.eventManager.getAction(ActionW.INVERSESTACK);
                if (invstackAction instanceof ToggleButtonListener) {
                    menu.add(new JSeparator());
                    menu.add(((ToggleButtonListener)invstackAction).createMenu(Messages.getString("View2dContainer.inv_stack")));
                }
                menuRoot.add(menu);
            }
            if ((rotateAction = this.eventManager.getAction(ActionW.ROTATION)) instanceof SliderChangeListener) {
                menuRoot.add(new JSeparator());
                JMenu menu = new JMenu(Messages.getString("View2dContainer.orientation"));
                JMenuItem menuItem = new JMenuItem(Messages.getString("ResetTools.reset"));
                final SliderChangeListener rotation = (SliderChangeListener)rotateAction;
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        rotation.setValue(0);
                    }
                });
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("View2dContainer.-90"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        rotation.setValue((rotation.getValue() - 90 + 360) % 360);
                    }
                });
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("View2dContainer.+90"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        rotation.setValue((rotation.getValue() + 90) % 360);
                    }
                });
                menu.add(menuItem);
                menuItem = new JMenuItem(Messages.getString("View2dContainer.+180"));
                menuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        rotation.setValue((rotation.getValue() + 180) % 360);
                    }
                });
                menu.add(menuItem);
                ActionState flipAction = this.eventManager.getAction(ActionW.FLIP);
                if (flipAction instanceof ToggleButtonListener) {
                    menu.add(new JSeparator());
                    menu.add(((ToggleButtonListener)flipAction).createMenu(Messages.getString("View2dContainer.flip_h")));
                    menuRoot.add(menu);
                }
            }
            menuRoot.add(new JSeparator());
            menuRoot.add(ResetTools.createUnregisteredJMenu());
        }
        return menuRoot;
    }

    public PluginTool[] getToolPanel() {
        if (toolPanels == null) {
            toolPanels = new PluginTool[4];
            View2dContainer.toolPanels[0] = new MiniTool(Messages.getString("View2dContainer.mini"), null){

                public SliderChangeListener[] getActions() {
                    ActionState rotateAction;
                    ActionState zoomAction;
                    ArrayList<SliderChangeListener> listeners = new ArrayList<SliderChangeListener>(3);
                    ActionState seqAction = View2dContainer.this.eventManager.getAction(ActionW.SCROLL_SERIES);
                    if (seqAction instanceof SliderChangeListener) {
                        listeners.add((SliderChangeListener)seqAction);
                    }
                    if ((zoomAction = View2dContainer.this.eventManager.getAction(ActionW.ZOOM)) instanceof SliderChangeListener) {
                        listeners.add((SliderChangeListener)zoomAction);
                    }
                    if ((rotateAction = View2dContainer.this.eventManager.getAction(ActionW.ROTATION)) instanceof SliderChangeListener) {
                        listeners.add((SliderChangeListener)rotateAction);
                    }
                    return listeners.toArray(new SliderChangeListener[listeners.size()]);
                }
            };
            toolPanels[0].setHide(false);
            toolPanels[0].registerToolAsDockable();
            View2dContainer.toolPanels[1] = new ImageTool(Messages.getString("View2dContainer.image_tools"), null);
            toolPanels[1].registerToolAsDockable();
            View2dContainer.toolPanels[2] = new DisplayTool(DisplayTool.BUTTON_NAME, null);
            toolPanels[2].registerToolAsDockable();
            View2dContainer.toolPanels[3] = new MeasureTool("Measure", null, this.eventManager);
            toolPanels[3].registerToolAsDockable();
            this.eventManager.addSeriesViewerListener((SeriesViewerListener)toolPanels[2]);
        }
        return toolPanels;
    }

    public void setSelected(boolean selected) {
        if (selected) {
            this.eventManager.setSelectedView2dContainer((ImageViewerPlugin)this);
            MediaSeries series = this.selectedImagePane.getSeries();
            if (series != null) {
                DataExplorerView dicomView = UIManager.getExplorerplugin((String)DicomExplorer.NAME);
                if (dicomView == null || !(dicomView.getDataExplorerModel() instanceof DicomModel)) {
                    return;
                }
                DicomModel model = (DicomModel)dicomView.getDataExplorerModel();
                model.firePropertyChange(new ObservableEvent(ObservableEvent.BasicAction.Select, (Object)this, null, (Object)series));
            }
        } else {
            this.eventManager.setSelectedView2dContainer(null);
        }
    }

    public void close() {
        super.close();
        View2dFactory.closeSeriesViewer(this);
        GuiExecutor.instance().execute(new Runnable(){

            @Override
            public void run() {
                for (DefaultView2d v : View2dContainer.this.view2ds) {
                    v.dispose();
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block13: {
            Object newVal;
            ObservableEvent.BasicAction action;
            block17: {
                MediaSeriesGroup group;
                ObservableEvent event;
                block19: {
                    block18: {
                        block14: {
                            Object source;
                            SeriesEvent.Action action2;
                            block16: {
                                Object param;
                                block15: {
                                    ActionState seqAction;
                                    if (!(evt instanceof ObservableEvent)) break block13;
                                    event = (ObservableEvent)evt;
                                    action = event.getActionCommand();
                                    newVal = event.getNewValue();
                                    if (!(newVal instanceof SeriesEvent)) break block14;
                                    SeriesEvent event2 = (SeriesEvent)newVal;
                                    if (!ObservableEvent.BasicAction.Add.equals((Object)action)) break block13;
                                    action2 = event2.getActionCommand();
                                    source = event2.getSource();
                                    param = event2.getParam();
                                    if (!SeriesEvent.Action.AddImage.equals((Object)action2)) break block15;
                                    if (!(source instanceof DicomSeries)) break block13;
                                    DicomSeries series = (DicomSeries)source;
                                    DefaultView2d view2DPane = this.eventManager.getSelectedViewPane();
                                    DicomImageElement img = (DicomImageElement)view2DPane.getImage();
                                    if (img != null && view2DPane.getSeries() == series && (seqAction = this.eventManager.getAction(ActionW.SCROLL_SERIES)) instanceof SliderCineListener) {
                                        SliderCineListener sliceAction = (SliderCineListener)seqAction;
                                        if (param instanceof Integer) {
                                            int imgIndex = series.getImageIndex((MediaElement)img);
                                            int size = series.size();
                                            if (imgIndex < 0) {
                                                imgIndex = 0;
                                                view2DPane.setSeries((MediaSeries)series, -1);
                                            }
                                            if (imgIndex >= 0) {
                                                sliceAction.setMinMaxValue(1, size, imgIndex + 1);
                                            }
                                        }
                                    }
                                    break block13;
                                }
                                if (!SeriesEvent.Action.UpdateImage.equals((Object)action2)) break block16;
                                if (!(source instanceof DicomImageElement)) break block13;
                                DicomImageElement dcm = (DicomImageElement)source;
                                for (DefaultView2d v : this.view2ds) {
                                    if (dcm != v.getImage()) continue;
                                    if (v.getImageLayer().getDisplayImage() == null) {
                                        v.setActionsInView(ActionW.PROGRESSION.cmd(), param);
                                        v.getImageLayer().setImage(null);
                                        v.setSeries(v.getSeries());
                                        continue;
                                    }
                                    v.propertyChange(new PropertyChangeEvent(dcm, ActionW.PROGRESSION.cmd(), null, param));
                                }
                                break block13;
                            }
                            if (!SeriesEvent.Action.loadImageInMemory.equals((Object)action2) || !(source instanceof DicomSeries)) break block13;
                            DicomSeries dcm = (DicomSeries)source;
                            for (DefaultView2d v : this.view2ds) {
                                if (dcm != v.getSeries()) continue;
                                v.repaint(v.getInfoLayer().getPreloadingProgressBound());
                            }
                            break block13;
                        }
                        if (!ObservableEvent.BasicAction.Remove.equals((Object)action)) break block17;
                        if (!(newVal instanceof DicomSeries)) break block18;
                        DicomSeries dicomSeries = (DicomSeries)newVal;
                        for (DefaultView2d v : this.view2ds) {
                            MediaSeries s = v.getSeries();
                            if (!dicomSeries.equals((Object)s)) continue;
                            v.setSeries(null);
                        }
                        break block13;
                    }
                    if (!(newVal instanceof MediaSeriesGroup)) break block13;
                    group = (MediaSeriesGroup)newVal;
                    if (!TagW.PatientPseudoUID.equals((Object)group.getTagID())) break block19;
                    if (!group.equals(this.getGroupID())) break block13;
                    this.close();
                    Content content = UIManager.toolWindowManager.getContentManager().getContent((Object)this.getDockableUID());
                    if (content != null) {
                        UIManager.toolWindowManager.getContentManager().removeContent(content);
                    }
                    break block13;
                }
                if (!TagW.StudyInstanceUID.equals((Object)group.getTagID()) || !(event.getSource() instanceof DicomModel)) break block13;
                DicomModel model = (DicomModel)event.getSource();
                for (MediaSeriesGroup s : model.getChildren(group)) {
                    for (DefaultView2d v : this.view2ds) {
                        MediaSeries series = v.getSeries();
                        if (!s.equals(series)) continue;
                        v.setSeries(null);
                    }
                }
                break block13;
            }
            if (ObservableEvent.BasicAction.Replace.equals((Object)action) && newVal instanceof Series) {
                Series series = (Series)newVal;
                for (DefaultView2d v : this.view2ds) {
                    MediaSeries s = v.getSeries();
                    if (!series.equals((Object)s)) continue;
                    v.setSeries(null);
                    v.setSeries((MediaSeries)series, -1);
                }
            }
        }
    }

    public int getViewTypeNumber(Class defaultClass) {
        return View2dFactory.getViewTypeNumber(this.layoutModel, defaultClass);
    }

    public boolean isViewType(Class defaultClass, String type) {
        if (defaultClass != null) {
            try {
                Class<?> clazz = Class.forName(type);
                return defaultClass.isAssignableFrom(clazz);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public DefaultView2d<DicomImageElement> createDefaultView(String classType) {
        if (MprView.class.getName().equals(classType)) {
            return new MprView((ImageViewerEventManager<DicomImageElement>)this.eventManager, VIEWS_2x2_mpr);
        }
        return new View2d((ImageViewerEventManager<DicomImageElement>)this.eventManager);
    }

    public JComponent createUIcomponent(String clazz) {
        if (this.isViewType(DefaultView2d.class, clazz)) {
            return this.createDefaultView(clazz);
        }
        try {
            Class<?> cl = Class.forName(clazz);
            JComponent component = (JComponent)cl.newInstance();
            if (component instanceof SeriesViewerListener) {
                this.eventManager.addSeriesViewerListener((SeriesViewerListener)component);
            }
            return component;
        }
        catch (InstantiationException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (ClassCastException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public synchronized WtoolBar getStatusBar() {
        return statusBar;
    }

    public synchronized WtoolBar[] getToolBar() {
        if (toolBars == null) {
            toolBars = new WtoolBar[2];
            ViewerToolBar bar = new ViewerToolBar(this.eventManager);
            View2dContainer.toolBars[0] = bar;
            View2dContainer.toolBars[1] = bar.getMeasureToolBar();
        }
        return toolBars;
    }

    public Action[] getExportActions() {
        Action[] actions = null;
        if (this.selectedImagePane != null) {
            actions = new Action[]{this.selectedImagePane.getExportToClipboardAction()};
        }
        if (AbstractProperties.OPERATING_SYSTEM.startsWith("mac")) {
            AbstractAction importAll = new AbstractAction(Messages.getString("View2dContainer.expOsirixMes"), new ImageIcon(View2dContainer.class.getResource("/icon/16x16/osririx.png"))){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd = "/usr/bin/open -a OsiriX";
                    String baseDir = System.getProperty("weasis.portable.dir");
                    if (baseDir != null) {
                        String prop = System.getProperty("weasis.portable.dicom.directory");
                        if (prop != null) {
                            String[] dirs = prop.split(",");
                            File[] files = new File[dirs.length];
                            for (int i = 0; i < files.length; ++i) {
                                File file = new File(baseDir, dirs[i].trim());
                                if (!file.canRead()) continue;
                                cmd = cmd + " " + file.getAbsolutePath();
                            }
                        }
                    } else {
                        File file = new File(AbstractProperties.APP_TEMP_DIR, "dicom");
                        if (file.canRead()) {
                            cmd = cmd + " " + file.getAbsolutePath();
                        }
                    }
                    System.out.println("Execute cmd:" + cmd);
                    try {
                        String data;
                        Process p = Runtime.getRuntime().exec(cmd);
                        BufferedReader buffer = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        while ((data = buffer.readLine()) != null) {
                            System.out.println(data);
                        }
                        int val = 0;
                        if (p.waitFor() != 0) {
                            val = p.exitValue();
                        }
                        if (val != 0) {
                            JOptionPane.showMessageDialog((Component)((Object)View2dContainer.this), Messages.getString("View2dContainer.expOsirixTitle"), Messages.getString("View2dContainer.expOsirixMes"), 0);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    catch (InterruptedException e2) {
                        LOGGER.error("Cannot get the exit status of the open Osirix command: ", (Object)e2.getMessage());
                    }
                }
            };
            actions = new Action[]{this.selectedImagePane.getExportToClipboardAction(), importAll};
        }
        return actions;
    }

    static {
        LinkedHashMap constraints = VIEWS_2x2_mpr.getConstraints();
        constraints.put(new LayoutConstraints(MprView.class.getName(), 0, 0, 0, 1, 2, 0.5, 1.0, 10, 1), null);
        constraints.put(new LayoutConstraints(MprView.class.getName(), 1, 1, 0, 1, 1, 0.5, 0.5, 10, 1), null);
        constraints.put(new LayoutConstraints(MprView.class.getName(), 2, 1, 1, 1, 1, 0.5, 0.5, 10, 1), null);
        MODELS = new GridBagLayoutModel[]{VIEWS_1x1, VIEWS_1x2, VIEWS_2x1, VIEWS_2x2_f2, VIEWS_2_f1x2, VIEWS_2x1_r1xc2_dump, VIEWS_2x2, VIEWS_3x2, VIEWS_3x3, VIEWS_4x3, VIEWS_4x4};
        statusBar = null;
    }
}

