/*
 * Decompiled with CFR 0.152.
 */
package paraselene.dyna;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.CacheRequest;
import java.net.CacheResponse;
import java.net.HttpURLConnection;
import java.net.ResponseCache;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import paraselene.dyna.Request;
import paraselene.dyna.Response;
import paraselene.dyna.ResponseReader;
import paraselene.mockup.Linker;
import paraselene.mockup.Param;

class Cache
extends ResponseCache {
    private static HashMap<URI, ResponseReader> body_map = new HashMap();
    private static HashMap<URI, Map<String, List<String>>> head_map = new HashMap();
    private static final String BODY = "paraselene.body.";
    private static final String HEAD = "paraselene.head.";

    private static File[] getSaveFile(String path) {
        String user = System.getProperty("user.name");
        return new File[]{new File(path + File.separator + BODY + user), new File(path + File.separator + HEAD + user)};
    }

    static void save() throws Exception {
        String path = Param.DTD.get();
        if (path == null) {
            return;
        }
        if (!new File(path).exists()) {
            Linker.readme.echoln("WARNING: " + path + " doesn't exist.");
            return;
        }
        File[] f = Cache.getSaveFile(path);
        File body = f[0];
        File head = f[1];
        HashMap<URI, byte[]> tmp = new HashMap<URI, byte[]>();
        for (URI uri : body_map.keySet()) {
            tmp.put(uri, body_map.get(uri).getBytes());
        }
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(body));
        out.writeObject(tmp);
        out.close();
        out = new ObjectOutputStream(new FileOutputStream(head));
        out.writeObject(head_map);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(URI uri, ResponseReader data) {
        HashMap<URI, ResponseReader> hashMap = body_map;
        synchronized (hashMap) {
            body_map.put(uri, data);
        }
        StringBuffer buf = new StringBuffer("\"");
        buf = buf.append(uri.toString());
        buf = buf.append("\" was cached.");
        Linker.readme.echoln(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void delete(URI uri) {
        HashMap<URI, Map<String, List<String>>> hashMap = head_map;
        synchronized (hashMap) {
            head_map.remove(uri);
        }
    }

    public static void init() throws Exception {
        ResponseCache.setDefault(new Cache());
        String path = Param.DTD.get();
        if (path == null) {
            return;
        }
        File[] f = Cache.getSaveFile(path);
        File body = f[0];
        File head = f[1];
        if (!body.exists() || !head.exists()) {
            Linker.readme.echoln("DTD cache doesn't exist in " + path);
            return;
        }
        Linker.readme.echoln("DTD cache loaded from " + path);
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(body));
        HashMap tmp = (HashMap)in.readObject();
        in.close();
        for (URI uri : tmp.keySet()) {
            body_map.put(uri, new ResponseReader((byte[])tmp.get(uri)));
        }
        in = new ObjectInputStream(new FileInputStream(head));
        head_map = (HashMap)in.readObject();
        in.close();
    }

    private Cache() {
    }

    private static boolean isGet(URI u) {
        String last = u.getPath();
        int len = last.length() - 4;
        if (len < 0) {
            return false;
        }
        if ((last = last.substring(len)).equals(".dtd")) {
            return true;
        }
        return last.equals(".ent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheResponse get(URI u, String method, Map<String, List<String>> m) throws IOException {
        if (!Cache.isGet(u)) {
            return null;
        }
        if (!"GET".equalsIgnoreCase(method)) {
            return null;
        }
        ResponseReader b = null;
        Map<String, List<String>> head = null;
        HashMap<URI, Object> hashMap = body_map;
        synchronized (hashMap) {
            b = body_map.get(u);
        }
        hashMap = head_map;
        synchronized (hashMap) {
            head = head_map.get(u);
        }
        if (b == null || head == null) {
            CacheRequest req = null;
            try {
                int size;
                ResponseCache.setDefault(null);
                URL url = new URL(u.toString());
                URLConnection r_conn = url.openConnection();
                if (!(r_conn instanceof HttpURLConnection)) {
                    return null;
                }
                HttpURLConnection conn = (HttpURLConnection)r_conn;
                conn.setRequestProperty("User-Agent", Param.USER_AGENT.get());
                conn.connect();
                if (conn.getResponseCode() / 100 != 2) {
                    return null;
                }
                req = this.put(u, conn);
                OutputStream out = req.getBody();
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                byte[] buf = new byte[4096];
                while ((size = in.read(buf)) > 0) {
                    out.write(buf, 0, size);
                }
                in.close();
                out.close();
                HashMap<URI, Object> hashMap2 = body_map;
                synchronized (hashMap2) {
                    b = body_map.get(u);
                }
                hashMap2 = head_map;
                synchronized (hashMap2) {
                    head = head_map.get(u);
                }
                ResponseCache.setDefault(new Cache());
            }
            catch (Exception e) {
                return null;
            }
        }
        return new Response(b, head);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheRequest put(URI u, URLConnection conn) throws IOException {
        if (!Cache.isGet(u)) {
            return null;
        }
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)conn;
            if (!"GET".equalsIgnoreCase(http.getRequestMethod())) {
                return null;
            }
        } else {
            return null;
        }
        HashMap<URI, Map<String, List<String>>> hashMap = head_map;
        synchronized (hashMap) {
            head_map.put(u, conn.getHeaderFields());
        }
        return new Request(u);
    }
}

