/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import paraselene.Page;
import paraselene.supervisor.Forward;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Tag;
import paraselene.tag.form.Form;
import paraselene.tag.form.Input;
import paraselene.ui.Clickable;
import paraselene.ui.PageHooker;

public class Button
extends Input
implements PageHooker,
Clickable {
    private static final long serialVersionUID = 2L;
    private boolean pushed = false;
    private Type const_type;

    public Button(Type type) {
        super(type.type);
        this.const_type = type;
    }

    public Type getType() {
        return this.const_type;
    }

    @Override
    protected Tag newReplica() {
        return this.copy4Replica(new Button(this.const_type));
    }

    public void resetClicked() {
        this.setClicked(false);
    }

    @Override
    public boolean isClicked(RequestParameter req) {
        String tv;
        Form form = this.getForm();
        if (form == null) {
            return false;
        }
        RequestItem item = req.getItem(this.getNameAttribute());
        if (item == null) {
            return false;
        }
        RequestItem form_id = req.getItem("paraselene$form$id");
        if (form_id == null) {
            return false;
        }
        if (!form.getID().equals(form_id.getValue())) {
            return false;
        }
        String iv = item.getValue();
        if (iv == null) {
            iv = "";
        }
        if ((tv = this.getValueAttribute()) == null) {
            tv = "";
        }
        return iv.equals(tv);
    }

    @Override
    public boolean isClicked() {
        return this.pushed;
    }

    @Override
    public void setClicked(boolean flag) {
        this.pushed = flag;
    }

    @Override
    public Forward beforeInput(Page page, RequestParameter req, Forward fw) throws Exception {
        return fw;
    }

    @Override
    public void afterOutput(Page from, Page to, RequestParameter req) throws Exception {
        StringBuilder buf = new StringBuilder("function(ev){");
        buf = buf.append("paraselene_form_kill=");
        buf = buf.append(this.isAjaxEnable() ? "false" : "true");
        buf = buf.append(";}");
        this.setAnonymousEventHandler("click", buf.toString());
    }

    public static enum Type {
        SUBMIT(Input.Type.SUBMIT),
        RESET(Input.Type.RESET),
        IMAGE(Input.Type.IMAGE),
        BUTTON(Input.Type.BUTTON);

        private static final long serialVersionUID = 1L;
        Input.Type type;

        private Type(Input.Type t) {
            this.type = t;
        }
    }
}

