/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import paraselene.supervisor.RequestItem;
import paraselene.tag.Tag;
import paraselene.tag.form.ControlException;
import paraselene.tag.form.Input;

public class UploadFile
extends Input {
    private static final long serialVersionUID = 1L;
    private File file;
    private String mime;

    public UploadFile() {
        super(Input.Type.FILE);
    }

    @Override
    protected Tag newReplica() {
        return new UploadFile();
    }

    void setRequest(RequestItem item) {
        this.delete();
        int cnt = item.getCount();
        for (int i = 0; i < cnt; ++i) {
            String path;
            if (!item.isFile(i) || (path = item.getValue(i)) == null || path.isEmpty()) continue;
            this.setValueString(new File(path).getName());
            this.file = item.getFile(i);
            this.mime = item.getContentType(i);
            return;
        }
    }

    public String getContentType() {
        return this.mime;
    }

    public void delete() {
        if (this.file != null) {
            this.file.delete();
            this.file = null;
            this.setValueString(null);
            this.mime = null;
        }
    }

    public void checkExtension(String mes, String ... ext) throws ControlException {
        String name = this.getValueString();
        if (name == null) {
            return;
        }
        int name_len = name.length();
        for (int i = 0; i < ext.length; ++i) {
            int ext_len = ext[i].length();
            if (name_len <= ext_len || !name.substring(name_len - ext_len).equalsIgnoreCase(ext[i])) continue;
            return;
        }
        throw new ControlException(mes, this);
    }

    public void checkContentType(String mes, String ... type) throws ControlException {
        String myself = this.getContentType();
        if (myself == null) {
            return;
        }
        myself = myself.split(" ")[0];
        for (int i = 0; i < type.length; ++i) {
            type[i] = type[i].split(" ")[0];
            if (!myself.equalsIgnoreCase(type[i])) continue;
            return;
        }
        throw new ControlException(mes, this);
    }

    public void move(File des) throws FileNotFoundException, IOException {
        des.delete();
        if (this.file.renameTo(des)) {
            this.delete();
            return;
        }
        BufferedOutputStream out = null;
        InputStream in = null;
        byte[] buf = new byte[4096];
        FileNotFoundException fnf_ex = null;
        IOException io_ex = null;
        try {
            int size;
            out = new BufferedOutputStream(new FileOutputStream(des));
            in = this.getInputStream();
            while ((size = in.read(buf)) > 0) {
                out.write(buf, 0, size);
                if (size >= buf.length) continue;
                break;
            }
            in.close();
            out.close();
            this.delete();
        }
        catch (FileNotFoundException e1) {
            fnf_ex = e1;
        }
        catch (IOException e2) {
            io_ex = e2;
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fnf_ex != null) {
            throw fnf_ex;
        }
        if (io_ex != null) {
            throw io_ex;
        }
    }

    public InputStream getInputStream() throws FileNotFoundException {
        if (this.file == null) {
            throw new FileNotFoundException();
        }
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    protected void finalize() throws Throwable {
        this.delete();
    }
}

