/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import paraselene.mockup.LineSeparator;
import paraselene.mockup.Linker;
import paraselene.mockup.OutputNo;
import paraselene.mockup.Param;
import paraselene.mockup.SourceHead;

public abstract class Output {
    protected abstract String getFileByte();

    static String toHtmlPath(String path) {
        String[] parts = path.split("[/\\\\]");
        StringBuilder buf = new StringBuilder(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            buf = buf.append("/");
            buf = buf.append(parts[i]);
        }
        return buf.toString();
    }

    static String toOSPath(String path) {
        String[] parts = path.split("[/\\\\]");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            buf = buf.append(File.separator);
            buf = buf.append(parts[i]);
        }
        return buf.toString();
    }

    static void mkdir(String dir) {
        if (dir == null) {
            return;
        }
        if (new File(dir).exists()) {
            return;
        }
        String[] path = dir.split("[/\\\\]+");
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            buf = buf.append(path[i]);
            buf = buf.append(File.separator);
            new File(buf.toString()).mkdir();
        }
    }

    static void rmdir(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            if (Param.isNoClear(file.getName())) {
                return;
            }
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                Output.rmdir(list[i].getPath());
            }
        }
        boolean ret = file.delete();
        Linker.readme.echo(dir);
        if (ret) {
            Linker.readme.echoln(" was deleted.");
        } else {
            Linker.readme.echoln(" was not deleted.");
        }
    }

    private static String scanLine(String str) {
        char[] ch = str.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == '\n' || ch[i] == '\r') {
                if (i > 0 && (ch[i - 1] == '\n' || ch[i - 1] == '\r') && ch[i] != ch[i - 1]) continue;
                buf.append(LineSeparator.getUse());
                continue;
            }
            buf.append(ch[i]);
        }
        return buf.toString();
    }

    public Status write(File file, OutputNo out_no, long org_tm) throws Exception {
        if (org_tm > 0L && file.exists() && file.lastModified() > org_tm) {
            return Status.SKIP;
        }
        Output.mkdir(file.getParent());
        char[] str = Output.scanLine(this.getFileByte()).toCharArray();
        BufferedWriter bw = null;
        Exception ex = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Param.SOURCE_ENCODE.get()));
            bw.write(SourceHead.getHead());
            for (int i = 0; i < str.length; ++i) {
                if (str[i] == '#' && str[++i] != '#') {
                    bw.write(Output.scanLine(out_no.getString(Integer.parseInt(new String(str, i, 1), 36))));
                    continue;
                }
                bw.write(str[i]);
            }
        }
        catch (Exception e) {
            ex = e;
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (ex != null) {
            throw ex;
        }
        return Status.OK;
    }

    static enum Status {
        OK,
        SKIP;

    }
}

