/*
 * Decompiled with CFR 0.152.
 */
package paraselene.css;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.Text;
import paraselene.Valuable;
import paraselene.css.CSSParser;
import paraselene.css.CSSValuable;
import paraselene.mockup.Converter;

public class Property
implements Serializable {
    private static final long serialVersionUID = 2L;
    public static final String IMPORTANT = "!important";
    private String name;
    private CSSValuable[] value;
    private boolean important_f;
    private Page embed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPage(Page p) {
        this.embed = p;
        Property property = this;
        synchronized (property) {
            if (this.value != null) {
                for (int i = 0; i < this.value.length; ++i) {
                    this.value[i].setPage(p);
                }
            }
        }
    }

    public Property getReplica() {
        Valuable[] rep = new Text[this.value.length];
        for (int i = 0; i < rep.length; ++i) {
            rep[i] = (CSSValuable)((Object)this.value[i].getReplica());
        }
        return new Property(this.important_f, this.name, rep);
    }

    public static Property[] create(String str) {
        str = str.trim();
        ArrayList<Property> ret = new ArrayList<Property>();
        String[] line = CSSParser.split(str, ';');
        for (int i = 0; i < line.length; ++i) {
            String[] part = CSSParser.split(str, ':');
            ret.add(new Property(part[0], part[1]));
        }
        return ret.toArray(new Property[0]);
    }

    private Property() {
    }

    public Property(boolean important, String n, String v) {
        this.setImportant(important);
        this.setName(n);
        this.set(v);
    }

    public Property(String n, String v) {
        this(false, n, v);
    }

    public Property(boolean important, String n, Valuable ... v) {
        this.setImportant(important);
        this.setName(n);
        this.set(v);
    }

    public Property(String n, Valuable ... v) {
        this(false, n, v);
    }

    public void setImportant(boolean important) {
        this.important_f = important;
    }

    public boolean isImportant() {
        return this.important_f;
    }

    private void setName(String n) {
        this.name = n.toLowerCase(Locale.ENGLISH);
    }

    public String getName() {
        return this.name;
    }

    public void set(String v) {
        if (v == null) {
            this.value = null;
            return;
        }
        String[] str = CSSParser.split(CSSParser.split(v, ';')[0], ' ');
        ArrayList<Text> list = new ArrayList<Text>();
        for (int i = 0; i < str.length; ++i) {
            str[i] = str[i].trim();
            if (str[i].isEmpty()) continue;
            if ("!".equals(str[i])) {
                if (i >= str.length - 1) continue;
                str[i + 1] = "!" + str[i + 1];
                continue;
            }
            if (IMPORTANT.equals(str[i])) {
                this.setImportant(true);
                continue;
            }
            list.add(new Text(str[i]));
        }
        this.set(list.toArray(new Text[0]));
    }

    public void set(Valuable ... v) {
        this.value = Converter.toCSSValuable(v);
    }

    public CSSValuable[] get() {
        return this.value;
    }

    private String[] getStringArray() {
        CSSValuable[] t = this.get();
        if (t == null) {
            return null;
        }
        if (t.length == 0) {
            return null;
        }
        String[] ret = new String[t.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = t[i].toString(HTMLPart.StringMode.CSS);
        }
        return ret;
    }

    public String getString() {
        String[] s = this.getStringArray();
        if (s == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(s[0]);
        for (int i = 1; i < s.length; ++i) {
            buf = buf.append(" ");
            buf = buf.append(s[i]);
        }
        return buf.toString();
    }

    public String toHtmlString() {
        StringBuilder buf = new StringBuilder(this.name);
        buf = buf.append(":");
        buf = buf.append(this.getString());
        buf = buf.append(";");
        return buf.toString();
    }

    public String toString() {
        return this.toHtmlString();
    }
}

