//
// cpuidՂ肯[
//
// this file is encoded in utf-8
//

#include <stdio.h>
#include <string.h>

#ifdef _PEKOE64_
#define	rBX	"rbx"
#define	rSI	"rsi"
#define	rDI	"rdi"
#else
#define	rBX	"ebx"
#define	rSI	"esi"
#define	rDI	"edi"
#endif

void cpuid(uint32 func,void* result){
	asm volatile(
		"mov %1,%%"rDI"\n"
		"cpuid\n"
		"movl %%eax,(%%"rDI")\n"
		"movl %%ecx,4(%%"rDI")\n"
		"movl %%edx,8(%%"rDI")\n"
		"movl %%ebx,12(%%"rDI")\n"
		:
		:"a"(func),"m"(result)
		:"ebx",rDI
		);
}

char* getCacheString(uint type){
	switch(type){
	case 0x01:
	case 0x02:
	case 0x03:
	case 0x04:
	case 0x50:
	case 0x51:
	case 0x52:
	case 0x5B:
	case 0x5C:
	case 0x5D:
	case 0xB0:
	case 0xB3:
		return NULL;
	case 0x06:
		return "L1 Inst: 8KB, 4-way, 32 byte line size";
	case 0x08:
		return "L1 Inst: 16KB, 4-way, 32 byte line size";
	case 0x0A:
		return "L1 Data: 8KB, 2-way, 32 byte line size";
	case 0x0C:
		return "L1 Data: 16KB, 4-way, 32 byte line size";
	case 0x22:
		return "L3: 512K, 4-way, 64byte line size, 128byte sector size";
	case 0x23:
		return "L3: 1MB, 8-way, 64byte line size, 128byte sector size";
	case 0x25:
		return "L3: 2MB, 8-way, 64byte line size, 128byte sector size";
	case 0x29:
		return "L3: 4MB, 8-way, 64byte line size, 128byte sector size";
	case 0x2C:
		return "L1 Data: 32KB, 8-way, 64 byte line size";
	case 0x30:
		return "L1 Inst: 32KB, 8-way, 64 byte line size";
	case 0x40:
		return "No L3 or L2 Cache";
	case 0x41:
		return "L2: 128KB, 4-way, 32 byte line size";
	case 0x42:
		return "L2: 256KB, 4-way, 32 byte line size";
	case 0x43:
		return "L2: 512KB, 4-way, 32 byte line size";
	case 0x44:
		return "L2: 1MB, 4-way, 32 byte line size";
	case 0x45:
		return "L2: 2MB, 4-way, 32 byte line size";
	case 0x60:
		return "L1 Data: 16KB, 8-way, 64byte line size";
	case 0x66:
		return "L1 Data: 8KB, 4-way, 64byte line size";
	case 0x67:
		return "L1 Data: 16KB, 4-way, 64byte line size";
	case 0x68:
		return "L1 Data: 32KB, 4-way, 64byte line size";
	case 0x70:
		return "L1 TC: 12K uops, 8-way";
	case 0x71:
		return "L1 TC: 16K uops, 8-way";
	case 0x72:
		return "L1 TC: 32K uops, 8-way";
	case 0x79:
		return "L2: 128KB, 8-way, 64byte line size, 128byte sector size";
	case 0x7A:
		return "L2: 256KB, 8-way, 64byte line size, 128byte sector size";
	case 0x7B:
		return "L2: 512KB, 8-way, 64byte line size, 128byte sector size";
	case 0x7C:
		return "L2: 1MB, 8-way, 64byte line size, 128byte sector size";
	case 0x7D:
		return "L2: 2MB, 8-way, 64byte line size";
	case 0x82:
		return "L2: 256KB, 8-way, 32 byte line size";
	case 0x83:
		return "L2: 512KB, 8-way, 32 byte line size";
	case 0x84:
		return "L2: 1MB, 8-way, 32 byte line size";
	case 0x85:
		return "L2: 2MB, 8-way, 32 byte line size";
	case 0x86:
		return "L2: 512KB, 4-way, 64 byte line size";
	case 0x87:
		return "L2: 1MB, 8-way, 64 byte line size";
	default:
		return "unknown";
	}
}

char* getAMDL2Associative(uint asc){
	switch(asc){
	case 0x01:
		return "Direct mapped";
	case 0x02:
		return "2-way";
	case 0x04:
		return "4-way";
	case 0x06:
		return "8-way";
	case 0x08:
		return "16-way";
	case 0x0F:
		return "Fully associative";
	default:
		return "unknown associative";
	}
}

#define	MOBILE		"Mobile"
#define	INTEL_R		"Intel(R)"
#define	PENTIUM_R	"Pentium(R)"
#define	CELERON_R	"Celeron(R)"
#define	XEON_TM		"Xeon(TM)"
#define	PROCESSOR	"processor"

char* getBrandIndexString(uint32 cpuid,uint bi){
	switch(bi){
	case 1:
		return CELERON_R" "PROCESSOR;
	case 2:
		return PENTIUM_R" III "PROCESSOR;
	case 3:
		return INTEL_R" "PENTIUM_R" III "XEON_TM" "PROCESSOR;
	case 4:
		return INTEL_R" "PENTIUM_R" III "PROCESSOR;
	case 6:
		return MOBILE" "INTEL_R" "PENTIUM_R" III "PROCESSOR" -M";
	case 7:
		return MOBILE" "INTEL_R" "CELERON_R" "PROCESSOR;
	case 8:
		return INTEL_R" "PENTIUM_R" 4 "PROCESSOR;
	case 9:
		return INTEL_R" "PENTIUM_R" 4 "PROCESSOR;
	case 10:
		return INTEL_R" "CELERON_R" "PROCESSOR;
	case 11:
		if(cpuid<0xF13){
			return INTEL_R" "XEON_TM" "PROCESSOR" MP";
		}else{
			return INTEL_R" "XEON_TM" "PROCESSOR;
		}
	case 12:
		return INTEL_R" "XEON_TM" "PROCESSOR" MP";
	case 14:
		if(cpuid<0xF13){
			return INTEL_R" "XEON_TM" "PROCESSOR;
		}else{
			return MOBILE" "INTEL_R" "PENTIUM_R" 4 "PROCESSOR" -M";
		}
	case 15:
		return MOBILE" "INTEL_R" "CELERON_R" "PROCESSOR;
	case 0x13:
		return MOBILE" "INTEL_R" "CELERON_R" "PROCESSOR;
	case 0x16:
		return INTEL_R" "PENTIUM_R" M "PROCESSOR;
	default:
		return NULL;
	}
}

char* getGenerationString(uint32 cpuid,uint32 feture,uint8 bi,uint32 e,char* cpuid_vendor_string){
	uint family = (cpuid&0xF00)>>8;
	cpuid&=0xFFF;
	if(e>=0x80000004){
		static char	cpuid_brand_string[48];
		asm volatile(
			"mov %0,%%"rDI"\n"
			"movl $0x80000002,%%eax\n"
			"cpuid\n"
			"movl %%eax,(%%"rDI")\n"
			"movl %%ebx,4(%%"rDI")\n"
			"movl %%ecx,8(%%"rDI")\n"
			"movl %%edx,12(%%"rDI")\n"
			"movl $0x80000003,%%eax\n"
			"cpuid\n"
			"movl %%eax,16(%%"rDI")\n"
			"movl %%ebx,20(%%"rDI")\n"
			"movl %%ecx,24(%%"rDI")\n"
			"movl %%edx,28(%%"rDI")\n"
			"movl $0x80000004,%%eax\n"
			"cpuid\n"
			"movl %%eax,32(%%"rDI")\n"
			"movl %%ebx,36(%%"rDI")\n"
			"movl %%ecx,40(%%"rDI")\n"
			"movl %%edx,44(%%"rDI")\n"
			:
			:"m"(cpuid_brand_string)
			:"eax","ecx","edx","ebx",rDI
			);
		char*p=cpuid_brand_string;
		for(;*p==0x20;p++){}
		if(*p) return p;
	}
	if(bi){
		char*s;
		s=getBrandIndexString(cpuid,bi);
		if(s) return s;
	}
	switch(family){
	case 4:
		if(feture&0x01){
			return "486DX family processor";
		}else{
			return "486SX family processor";
		}
	case 5:
		if(!strcmp(cpuid_vendor_string,"GenuineIntel")){
			return "P5 family processor";
		}else{
			return "586 family processor";
		}
	case 6:
		if(!strcmp(cpuid_vendor_string,"GenuineIntel")){
			return "P6 family processor";
		}else if(!strcmp(cpuid_vendor_string,"AuthenticAMD")){
			return "K7 family processor";
		}else{
			return "686 family processor";
		}
	case 15:
		if(!strcmp(cpuid_vendor_string,"GenuineIntel")){
			return "P68 or later processor";
		}else if(!strcmp(cpuid_vendor_string,"AuthenticAMD")){
			return "K8 or later processor";
		}else{
			return "786 or later processor";
		}
	default:
		return "unknown processor";
	}
}

int main(void){

	uint32	cpuid00[4];
	uint32	cpuid01[4];
	uint32	cpuid80[4];
	uint32	cpuid81[4];
	char	cpuid_vendor_string[16];

	cpuid(0x00000000,cpuid00);
	cpuid(0x00000001,cpuid01);
	cpuid(0x80000000,cpuid80);
	cpuid(0x80000001,cpuid81);

	asm volatile(
		"mov %0,%%"rSI"\n"
		"mov %1,%%"rDI"\n"
		"movl 4(%%"rSI"),%%eax\n"
		"movl 8(%%"rSI"),%%ecx\n"
		"movl 12(%%"rSI"),%%edx\n"
		"movl %%eax,8(%%"rDI")\n"
		"movl %%ecx,4(%%"rDI")\n"
		"movl %%edx,(%%"rDI")\n"
		"xor %%eax,%%eax\n"
		"mov %%eax,12(%%"rDI")\n"
		:
		:"m"(cpuid00),"m"(cpuid_vendor_string)
		:"eax","ecx","edx",rSI,rDI
		);

	printf("**** CPUID Information ****\n");
	printf("Brand: %s (%s %x)\n"
		,getGenerationString(cpuid01[0],cpuid01[2],cpuid01[3]&0xFF,cpuid80[0],cpuid_vendor_string)
		,cpuid_vendor_string,cpuid01[0]);

	printf("Feature: %08x %08x\n",cpuid01[2],cpuid01[1]);
	printf(
		"%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s\n"
		// edx
		,(cpuid01[2]&0x00000001)?" FPU":""
		,(cpuid01[2]&0x00000002)?" VME":""
		,(cpuid01[2]&0x00000004)?" DE":""
		,(cpuid01[2]&0x00000008)?" PSE":""
		,(cpuid01[2]&0x00000010)?" TSC":""
		,(cpuid01[2]&0x00000020)?" MSR":""
		,(cpuid01[2]&0x00000040)?" PAE":""
		,(cpuid01[2]&0x00000080)?" MCE":""
		,(cpuid01[2]&0x00000100)?" CX8":""
		,(cpuid01[2]&0x00000200)?" APIC":""
//		,(cpuid01[2]&0x00000400)?" ???":""
		,(cpuid01[2]&0x00000800)?" SEP":""
		,(cpuid01[2]&0x00001000)?" MTRR":""
		,(cpuid01[2]&0x00002000)?" PGE":""
		,(cpuid01[2]&0x00004000)?" MCA":""
		,(cpuid01[2]&0x00008000)?" CMOV":""
		,(cpuid01[2]&0x00010000)?" PAT":""
		,(cpuid01[2]&0x00020000)?" PSE-36":""
		,(cpuid01[2]&0x00040000)?" PSN":""
		,(cpuid01[2]&0x00080000)?" CLFSH":""
//		,(cpuid01[2]&0x00100000)?" ???":""
		,(cpuid01[2]&0x00200000)?" DS":""
		,(cpuid01[2]&0x00400000)?" ACPI":""
		,(cpuid01[2]&0x00800000)?" MMX":""
		,(cpuid01[2]&0x01000000)?" FXSR":""
		,(cpuid01[2]&0x02000000)?" SSE":""
		,(cpuid01[2]&0x04000000)?" SSE2":""
		,(cpuid01[2]&0x08000000)?" SS":""
		,(cpuid01[2]&0x10000000)?" HT":""
		,(cpuid01[2]&0x20000000)?" TM":""
		,(cpuid01[2]&0x40000000)?" IA-64":""
		,(cpuid01[2]&0x80000000)?" FERR":""
		// ecx
		,(cpuid01[1]&0x00000001)?" SSE3":""
		,(cpuid01[1]&0x00000008)?" Monitor":""
		,(cpuid01[1]&0x00000010)?" DS_CPL":""
		,(cpuid01[1]&0x00000080)?" EST":""
		,(cpuid01[1]&0x00000100)?" TM2":""
		,(cpuid01[1]&0x00000400)?" CNXT-ID":""
		,(cpuid01[1]&0x00002000)?" CMPXCHG16B":""
	);
	if(cpuid80[0]>=0x80000001&&cpuid81[2]!=0){
		printf("Extended Feature: %08x\n",cpuid81[2]);
		printf(
			"%s%s%s%s%s%s%s\n"
			// edx
			,(cpuid81[2]&0x00000800)?" SYSCALL":""
			,(cpuid81[2]&0x00100000)?" NX":""
			,(cpuid81[2]&0x00400000)?" MMX+":""
			,(cpuid81[2]&0x02000000)?" Fast-FXSAVE/FXRSTOR":""
			,(cpuid81[2]&0x20000000)?" AMD64":""
			,(cpuid81[2]&0x40000000)?" 3DNOW+":""
			,(cpuid81[2]&0x80000000)?" 3DNOW":""
		);
	}

	if(cpuid00[0]>=2||cpuid80[0]>=0x80000006){
		printf("Cache Information:\n");
		if(cpuid80[0]>=0x80000006){
			uint8	cpuid85[16];
			uint8	cpuid86[4];
			cpuid(0x80000005,cpuid85);
			cpuid(0x80000006,cpuid86);
			printf(
				" L1 Data: %dKB, %d-way, %d byte line size\n"
				" L1 Inst: %dKB, %d-way, %d byte line size\n"
				,cpuid85[7],cpuid85[6],cpuid85[4],cpuid85[11],cpuid85[10],cpuid85[8]);
			if(cpuid86[5]&0xF0){
				printf(" L2: %dKB, %s, %d byte line size\n",*(uint16*)(cpuid86+6),
					getAMDL2Associative(cpuid86[5]>>4),cpuid86[4]);
			}else{
				printf(" No L2 Cache\n");
			}
		}else if(cpuid00[0]>=2){
			uint8	cpuid02[16];
			cpuid(0x00000002,cpuid02);
			for(int i=1;i<15;i++){
				if(cpuid02[i]){
					uint q=cpuid02[i];
					char*s = getCacheString(q);
					if(s) printf(" %02x: %s\n",q,s);
				}
			}
		}
	}

	//	HTT
	if(cpuid01[3]&0x00FF0000){
		printf("Number of logical processors: %d\n",(uint8)(cpuid01[3]>>16));
	}

	//	AMD64
	if(cpuid80[0]>=0x80000008){
		uint8	cpuid88[16];
		cpuid(0x80000008,cpuid88);
		printf("AMD64 feature:\n");
		printf(" %dbit Virtual-Address, %dbit Physical-Address\n",cpuid88[1],cpuid88[0]);
	}

}

