//
//	malloc (C)K&R
//
#include <stdio.h>

typedef	long double Align;	//	sizeof(long double)=16
union header{
	struct {
		header	*ptr;
		unsigned	size;
	} s;
	Align x;
};
typedef	union header Header;

static Header base;
static Header *freep = NULL;

static Header* morecore(unsigned);
static char* sbrk(int);

void* malloc(size_t nbytes){
	Header *p,*prevp;
	unsigned nunits;
	nunits = (nbytes+sizeof(Header)-1)/sizeof(Header)+1;
	if((prevp=freep)==NULL){
		base.s.ptr=freep=prevp=&base;
		base.s.size=0;
	}
	for(p=prevp->s.ptr;;prevp=p,p=p->s.ptr){
		if(p->s.size>=nunits){
			if(p->s.size==nunits)
				prevp->s.ptr=p->s.ptr;
			else {
				p->s.size-=nunits;
				p+=p->s.size;
				p->s.size=nunits;
			}
			freep=prevp;
			return (void*)(p+1);
		}
		if(p==freep)
			if((p=morecore(nunits))==NULL)
			return NULL;
	}
}

void free(void* ap){
	Header *bp,*p;
	if(!ap) return;
	bp = (Header*)ap-1;
	for(p=freep;!(bp>p&&bp<p->s.ptr);p=p->s.ptr)
		if(p>=p->s.ptr&&(bp>p||bp<p->s.ptr))
			break;
	if(bp+bp->s.size==p->s.ptr){
		bp->s.size+=p->s.ptr->s.size;
		bp->s.ptr=p->s.ptr->s.ptr;
	}else
		bp->s.ptr=p->s.ptr;
	if(p+p->s.size==bp){
		p->s.size+=bp->s.size;
		p->s.ptr=bp->s.ptr;
	}else
		p->s.ptr=bp;
	freep=p;
}


#ifndef NALLOC
#define	NALLOC	0x1000
#endif
static Header *morecore(unsigned nu){
	char *cp;
	Header *up;
	if(nu<NALLOC)
		nu=NALLOC;
	cp=sbrk(nu*sizeof(Header));
	if(cp==(char*)-1)
		return NULL;
	up=(Header*)cp;
	up->s.size=nu;
	free((void*)(up+1));
	return freep;
}


static char* sbrk(int n){
	char* r;
	asm volatile(
		"movb $0x48,%%ah \n"
		"int $0x21 \n"
		:"=a"(r):"b"(n)
	);
	return r;
}
