/**
 * $Id: URLEncodeTag.java,v 1.2 2006/01/30 15:22:25 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.taglib;

import java.net.URLEncoder;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.logical_paradox.kinako.constant.ApConstant;

/**
 * URLGR[hJX^^O
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class URLEncodeTag extends BodyTagSupport {
	/** VAo[WUID */
	private static final long serialVersionUID = -2856175806006200148L;

	/**
	 * ^OBODYURLGR[hďo͂
	 * @return ʃXe[^X
	 */
	@Override
	public int doAfterBody() throws JspException {
		BodyContent body = getBodyContent();

		try {
			body.getEnclosingWriter().write(URLEncoder.encode(body.getString(), ApConstant.KINAKO_DEFAULT_PAGE_ENCODING));
		} catch(Exception e) {
			throw new JspException(e.getMessage());
		}
		body.clearBody();

		return SKIP_BODY;
	}

	/**
	 * ^O̕]Jn
	 * @return ʃXe[^X
	 */
	@Override
	public int doStartTag() throws JspException {
		return EVAL_BODY_BUFFERED;
	}

	/**
	 * ^O̕]I
	 * @return ʃXe[^X
	 */
	@Override
	public int doEndTag() throws JspException {
		return EVAL_PAGE;
	}
}
