/**
 * $Id: PageLinkTag.java,v 1.3 2006/01/30 15:22:25 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.taglib;

import java.io.IOException;
import java.text.MessageFormat;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

/**
 * y[WN^O
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.3 $
 */
public class PageLinkTag extends TagSupport {
	/** VAo[WUID */
	private static final long serialVersionUID = 5467322700104322509L;
	/** 1y[W̕\ */
	private int num;
	/** \Ώۃy[W */
	private int page;
	/** ʂ̑ */
	private int hits;
	/** N\錏 */
	private int range;

	/** N */
	private String href;

	/**
	 * ^OJn
	 * @return IR[h
	 */
	@Override
	public int doStartTag() throws JspException {
		// Sŉy[W݂邩vZ
		int totalPages = hits / num;
		if(hits % num > 0) {
			totalPages++;
		}

		// O㉽y[W̃N\邩vZ
		int bgn = ((page-1) / range) * range;
		int end = totalPages - bgn < range ? totalPages : range;

		// \
		try {
			if(bgn > 1) {
				pageContext.getOut().write("<a href=\"" + buildURL(bgn) + "\">&lt;&lt;</a>&nbsp;");
			}
			for(int i = bgn +1; i <= end; i++) {
				if(i == page) {
					pageContext.getOut().write("<b>" + i + "</b>");
				} else {
					pageContext.getOut().write("<a href=\"" + buildURL(i) + "\">");
					pageContext.getOut().write(""+i);
					pageContext.getOut().write("</a>");
				}
				pageContext.getOut().write("&nbsp;");
			}
			if(end < totalPages) {
				pageContext.getOut().write("<a href=\"" + buildURL(end+1) + "\">&gt;&gt;</a>&nbsp;");
			}
			pageContext.getOut().flush();
		} catch (IOException e) {
			e.printStackTrace();
			throw new JspException(e.getMessage());
		}

		return SKIP_BODY;
	}

	/**
	 * URL𐶐
	 * @return ꂽURL
	 */
	protected String buildURL(int pageNo) {
		return MessageFormat.format(href, "" + ((pageNo-1) * num));
	}
	/**
	 * 1y[W̕\Ԃ
	 * @return 1y[W̕\
	 */
	public String getNum() {
		return "" + num;
	}
	/**
	 * 1y[W̕\ݒ肷
	 * @param i 1y[W̕\
	 */
	public void setNum(String i) {
		Integer ii;
		try {
			ii =
				(Integer) ExpressionEvaluatorManager.evaluate(
					"num",
					i,
					Integer.class,
					this,
					pageContext);
			num = ii.intValue();
		} catch (JspException e) {
			e.printStackTrace();
		}
	}
	/**
	 * Ԃ
	 * @return 
	 */
	public String getHits() {
		return "" + hits;
	}

	/**
	 * ݒ肷
	 * @param i 
	 */
	public void setHits(String i) {
		Integer ii;
		try {
			ii =
				(Integer) ExpressionEvaluatorManager.evaluate(
					"hits",
					i,
					Integer.class,
					this,
					pageContext);
			hits = ii.intValue();
		} catch (JspException e) {
			e.printStackTrace();
		}
	}
	/**
	 * y[WԍԂ
	 * @return y[Wԍ
	 */
	public String getPage() {

		return "" + page;
	}

	/**
	 * y[Wԍݒ肷
	 * @param i y[Wԍ
	 */
	public void setPage(String i) {
		Integer ii;
		try {
			ii =
				(Integer) ExpressionEvaluatorManager.evaluate(
					"page",
					i,
					Integer.class,
					this,
					pageContext);
			page = ii.intValue();
		} catch (JspException e) {
			e.printStackTrace();
		}
	}

	/**
	 * \͈͂Ԃ
	 * @return \͈
	 */
	public String getRange() {
		return "" + range;
	}

	/**
	 * \͈͂ݒ肷
	 * @param i \͈
	 */
	public void setRange(String i) {
		Integer ii;
		try {
			ii =
				(Integer) ExpressionEvaluatorManager.evaluate(
					"range",
					i,
					Integer.class,
					this,
					pageContext);
			range = ii.intValue();
		} catch (JspException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Nݒ肷
	 * @param url N
	 */
	public void setHref(String url) {
		try {
			href =
				(String) ExpressionEvaluatorManager.evaluate(
					"href",
					url,
					String.class,
					this,
					pageContext);
		} catch (JspException e) {
			e.printStackTrace();
		}
	}
	/**
	 * NԂ
	 * @return N
	 */
	public String getHref() {
		return href;
	}
}
