/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.logic.parser;

import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.phalanx.binding.condition.Condition;

/**
 * p[X
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class SearchConditionParser {
	private static final SearchConditionParser parser = new SearchConditionParser();
	
	private SearchConditionParser() {
	}
	/**
	 * p[T[̃CX^X𐶐ĕԂ
	 * @return p[T[
	 */
	public static SearchConditionParser getParser() {
		return parser;
	}
	/**
	 * ͂ꂽL[[hIuWFNg̃c[\ɓWJ
	 * @param keyword L[[h
	 * @return WJꂽ
	 */
	public Condition parse(String keyword) throws Exception {
		// SpXy[X𔼊pXy[Xɕϊ
		String halfSpacedKeyword = keyword.replace('@', ' ');

		// ͂ꂽL[[h͋̕LWɕϊ
		char[] characters = halfSpacedKeyword.toCharArray();
		Symbol[] symbols = new Symbol[characters.length];

		for(int i = 0; i < symbols.length; i++) {
			symbols[i] = new CharacterSymbol(characters[i]);
		}

		// ̐
		SearchConditionFsm fsm = new SearchConditionFsm("search condition fsm");
		fsm.execute(symbols);

		return (Condition)fsm.getResult();
	}
}
