/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.logic.parser;

import org.logical_paradox.common.fsm.FiniteStateMachine;
import org.logical_paradox.common.fsm.Symbol;
import org.logical_paradox.phalanx.binding.condition.AndType;
import org.logical_paradox.phalanx.binding.condition.Condition;
import org.logical_paradox.phalanx.binding.condition.ObjectFactory;

/**
 * ͂ꂽL[[h͂āC𐶐LԑJڋ@B
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.2 $
 */
public class SearchConditionFsm extends FiniteStateMachine {
	/**  */
	private Condition condition;
	/** Ɋ֘AIuWFNg𐶐t@Ng */
	private ObjectFactory factory;
	/** ݂̏ */
	private SearchConditionState state;
	private AndType and;
	private StringBuffer sb = new StringBuffer();

	/** Zp[^V{ */
	private static final Symbol SEPARATOR = new CharacterSymbol(' ');
	private static final SearchConditionState STATE_INITIAL = new SearchConditionState(SearchConditionState.INITIAL);
	private static final SearchConditionState STATE_ACCEPTING = new SearchConditionState(SearchConditionState.ACCEPTING);
	private static final SearchConditionState STATE_FINAL = new SearchConditionState(SearchConditionState.FINAL);

	/**
	 * RXgN^
	 * @param name 
	 */
	public SearchConditionFsm(String name) throws Exception {
		super(name);
	}
	/**
	 * 
	 */
	public void init() throws Exception {
		super.init();
		factory = new ObjectFactory();
		condition = factory.createCondition();
		state = new SearchConditionState();
		and = factory.createAndType();
	}
	/**
	 * I
	 * @throws Exception ɔO
	 */
	public void finish() throws Exception {
		// Xe[^Xr[ł΁CIs
		if(state.equals(STATE_ACCEPTING)) {
			and.getTerm().add(sb.toString());
		}
		// 𐶐
		condition.getAnd().add(and);

		// IԂ֑J
		state.transition(STATE_FINAL.getCurrentState());
	}
	/**
	 * ͋LԂɑ΂ė^
	 * ͂ꂽLɂāCԂJڂƂ^C~OŃCxg
	 * @param symbol ͋L
	 */
	protected void input(Symbol symbol) {
		if(symbol.equals(SEPARATOR)) {
			if(state.equals(STATE_ACCEPTING)) {
				// ̍̏ꍇ́Ctermǉ
				and.getTerm().add(sb.toString());
				sb = new StringBuffer();
			}
			// Zp[^Mꍇ͏Ԃ֑J
			state.transition(SearchConditionState.INITIAL);
		} else {
			// Zp[^ȊO͎M̏
			if(state.equals(STATE_INITIAL)) {
				// ԂMԂ֑JڂꍇC<AND>ǉ
				state.transition(SearchConditionState.ACCEPTING);
			}
			sb.append(symbol.toString());
		}
	}
	/**
	 * ݂̏ԂIԂɂ邩ǂԂ
	 * @return true:I / false:p
	 */
	protected boolean isFiniteState() {
		return STATE_FINAL.equals(state);
	}
	/**
	 * ʂԂ
	 * @return 
	 */
	public Object getResult() {
		return condition;
	}
}
