/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.logic;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.charset.CharsetUtils;
import org.logical_paradox.kinako.constant.ApConstant;
import org.logical_paradox.kinako.object.SearchCondition;
import org.logical_paradox.phalanx.binding.resultset.ResultSet;

/**
 * SVXeMʂXMLHTMLɕϊ
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.6 $
 */
public class SearchResultTranslator {
	/** K[ */
	private static final Log log = LogFactory.getLog(SearchResultTranslator.class);

	/** HTMLϊ̃CX^X */
	private static final SearchResultTranslator translator = new SearchResultTranslator();
	/** XML̃A}[V[ */
	private Unmarshaller resultSetUmarshaller;

	/**
	 * RXgN^
	 */
	private SearchResultTranslator() {
		// A}[V[
		JAXBContext resultSetCtx;
		try {
			resultSetCtx = JAXBContext.newInstance(ApConstant.PHALANX_JAXB_PACKAGE_NAME + ".resultset");
			resultSetUmarshaller = resultSetCtx.createUnmarshaller();
//			resultSetUmarshaller.setValidating(true);
		} catch (JAXBException e) {
			log.error("A}[V[̐ɗO܂F", e);
		}
	}
	/**
	 * VOg̃CX^XԂ
	 * @return HTMLϊ̃CX^X
	 */
	public static SearchResultTranslator getInstance() {
		return translator;
	}
	/**
	 * ̓Xg[MXMLCw肳ꂽXSLɏ]HTMLɕϊCo̓Xg[𗬂
	 * SĎMIƂĂC̓Xg[o̓Xg[ɕȂ߁C<br>
	 * ̃\bhĂяoXg[̃N[YǗKv
	 * @param ostream o̓Xg[
	 * @param istream ̓Xg[
	 * @param xslt ϊ[
	 * @param inputEncoding ̓GR[fBO
	 * @param outputEncoding o̓GR[fBO
	 * @param condition  
	 * @return ʂ̑
	 */
	public int output(OutputStream ostream, InputStream istream, String xslt, String inputEncoding, SearchCondition condition) throws IOException, TransformerException, JAXBException {
		// xf[^\[XXMLeLXgǂݍ
		BufferedReader br = new BufferedReader(new InputStreamReader(istream, inputEncoding));
		StringBuffer sb = new StringBuffer();
		String line = null;
		while((line = br.readLine()) != null) {
			sb.append(line);
		}

		// ̓Xg[XML擾
		String xmlDocument = sb.toString();

		String originalEncodingXml = CharsetUtils.encode(inputEncoding, xmlDocument);
		InputStreamReader ir = new InputStreamReader(new ByteArrayInputStream(xmlDocument.getBytes()));
		BufferedReader xmlReader = new BufferedReader(ir);

		// for JDK 1.5.0
		System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");

		TransformerFactory factory = TransformerFactory.newInstance();
		Transformer transformer = factory.newTransformer(new StreamSource(xslt));
		transformer.setParameter(ApConstant.XSLT_PARAM_KEYWORD, condition.getKeyword());
		// o̓GR[fBO
		transformer.setOutputProperty(OutputKeys.ENCODING, System.getProperty("file.encoding"));

		// ϊďo
		transformer.transform(new StreamSource(xmlReader), new StreamResult(ostream));

		// XMLhLgIuWFNgɕϊ
		ResultSet rs = getResultSet(originalEncodingXml.getBytes("ISO-8859-1"));

		return rs.getHits();
	}
	/**
	 * XMLIuWFNgɕϊ
	 * @param xml SapT[o[ԋpꂽXMLhLg
	 * @return oChꂽIuWFNg
	 */
	protected ResultSet getResultSet(byte[] xml) throws JAXBException {
		ResultSet rs = (ResultSet)resultSetUmarshaller.unmarshal(new ByteArrayInputStream(xml));
		return rs;
	}
}
