/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.logic;

import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.Properties;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.logical_paradox.common.net.HttpRequestSender;
import org.logical_paradox.kinako.constant.ApConstant;
import org.logical_paradox.kinako.logic.parser.SearchConditionParser;
import org.logical_paradox.kinako.object.FailureTransitionException;
import org.logical_paradox.kinako.object.SearchCondition;
import org.logical_paradox.phalanx.binding.condition.Condition;

/**
 * WbN
 * ʂ͂ꂽL[[hCT[o[ɑMCʂMD<br>
 * T[o[web serviceŌJĂCf[^̑MSOAPɂčsD
 * 
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.11 $
 */
public class KinakoSearchLogic {
	/** K[ */
	private static final Log log = LogFactory.getLog(KinakoSearchLogic.class);

	private final Marshaller marshaller;
	private final String xmlEncoding;

	/**
	 * RXgN^
	 * @param encoding XML̃GR[fBO
	 */
	public KinakoSearchLogic(String encoding) throws JAXBException {
		JAXBContext conditionCtx = JAXBContext.newInstance(ApConstant.PHALANX_JAXB_PACKAGE_NAME + ".condition");
		xmlEncoding = encoding;
		marshaller = conditionCtx.createMarshaller();
		marshaller.setProperty(Marshaller.JAXB_ENCODING, xmlEncoding);
		marshaller.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.FALSE);
	}
	/**
	 * s
	 * @param phalanxURL
	 * @param keyword L[[h(Xy[X؂)
	 * @param encoding L[[h̃GR[fBO
	 * @return ʂXML
	 */
	public InputStream search(String url, SearchCondition searchCondition, String encoding) throws Exception {
		log.info("***** Jn܂");
		// ͂ꂽIuWFNg̃c[\ɕϊ
		// L[[hϊĂ
		Condition condition = SearchConditionParser.getParser().parse(searchCondition.getKeyword());
		if(condition == null) {
			log.fatal("***** ꂽ(condition)nullł");
			throw new FailureTransitionException();
		}
		condition.setMethod("ngramFtsSearchLogic");
		condition.setStartindex(BigInteger.valueOf(searchCondition.getStartIndex()));
		condition.setEndindex(BigInteger.valueOf(searchCondition.getEndIndex()));

		StringWriter buffer = new StringWriter();
		marshaller.marshal(condition, buffer);

		// XMĽ`ŃGR[h
		String xml = buffer.toString();

		log.info("***** XMLɕϊ܂: " + xml);

		// SVXeɖ₢킹
		Properties postdata = new Properties();
		postdata.setProperty("req", xml);
		InputStream response = HttpRequestSender.post(url, HttpRequestSender.urlEncodeAll(postdata, encoding));

		return response;
	}
}
