/*
 * $Id: ExtendedXSLTHandler.java,v 1.1 2005/09/26 15:05:40 rampil Exp $
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2005 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.logic;

import org.logical_paradox.kinako.constant.ApConstant;

/**
 * gXSLT^Onh
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.1 $
 */
public class ExtendedXSLTHandler {
	/** \^O */
	private static final String[] emphasisTags =
		{
			ApConstant.XSLT_EMPHASIS_PTN_01, 
			ApConstant.XSLT_EMPHASIS_PTN_02, 
			ApConstant.XSLT_EMPHASIS_PTN_03, 
			ApConstant.XSLT_EMPHASIS_PTN_04, 
			ApConstant.XSLT_EMPHASIS_PTN_05, 
		};

	/**
	 * wL[[hĕԂD
	 * @param keyword L[[h(pXy[X؂)
	 * @param msg bZ[W
	 * @return ϊꂽbZ[W
	 */
	public static String emphasis(String keyword, String msg) {
		// SpXy[X𔼊pXy[Xɕϊ
		String exprkeyword = keyword.trim().replaceAll("@"," ");
		// pXy[Xŋ؂ = ̎擾
		String[] keywords = exprkeyword.split(" ");

		String exprmsg = msg;

		// ꂼ̋^Oɒu
		for(int i = 0; i < keywords.length; i++) {
			String em = emphasisTags[i >= emphasisTags.length ? emphasisTags.length-1 : i].replaceAll("%%KEYWORD%%", keywords[i]); 
			exprmsg = exprmsg.replaceAll(keywords[i], em);
		}

		return exprmsg;
	}
}
