/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.action;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.logical_paradox.common.util.StringUtils;
import org.logical_paradox.kinako.constant.ApConstant;
import org.logical_paradox.kinako.form.SearchForm;
import org.logical_paradox.kinako.logic.KinakoSearchLogic;
import org.logical_paradox.kinako.logic.SearchResultTranslator;
import org.logical_paradox.kinako.object.SearchCondition;

/**
 * ANV
 * L[[hs܂
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.8 $
 */
public class SearchAction extends KinakoBaseAction {
	/** K[ */
	private static final Log log = LogFactory.getLog(SearchAction.class);

	/**
	 * L[[hsANV
	 * ʂ͂ꂽL[[h́CT[o[ɑMD<BR>
	 * ʂ͌T[o[XMLŎMD
	 * 
	 * @param form ANVtH[
	 * @param mapping ANV}bsO
	 * @param resource bZ[W\[X
	 * @return tH[h
	 */
	public ActionForward executeLogic(ActionForm form, ActionMapping mapping, MessageResources resource) throws Exception {
		SearchForm searchForm = (SearchForm)form;

		String xmlEncoding = resource.getMessage("system.encoding.xml");
		String urlEncoding = resource.getMessage("system.encoding.url");
		String pageEncoding = resource.getMessage("system.encoding.page");
		String xslFilename = resource.getMessage("system.path.xsl.result");

		if(StringUtils.isEmpty(xmlEncoding)) {
			xmlEncoding = ApConstant.PHALANX_DEFAULT_XML_ENCODING;
		}
		if(StringUtils.isEmpty(urlEncoding)) {
			urlEncoding = ApConstant.KINAKO_DEFAULT_URL_ENCODING;
		}
		if(StringUtils.isEmpty(pageEncoding)) {
			pageEncoding = ApConstant.KINAKO_DEFAULT_PAGE_ENCODING;
		}
		String url = resource.getMessage("phalanx.apserver.url");

		// JnʒuEIʒuw肳ĂȂꍇ̓ftHglݒ
		if(searchForm.getStartIndex() == 0 && searchForm.getNum() == 0) {
			searchForm.setStartIndex(1);
			searchForm.setNum(Integer.parseInt(resource.getMessage("system.default.page_size")));
		}
		// v̑M
		SearchCondition condition = searchForm.bindToSearchCondition();
		InputStream istream = new KinakoSearchLogic(xmlEncoding).search(url, condition, urlEncoding);

		// XMLHTMLϊ
		// ԂĂʂHTMLɕϊ
		SearchResultTranslator translator = SearchResultTranslator.getInstance();
		ByteArrayOutputStream out = new ByteArrayOutputStream();

		// ϊ
		int hits = translator.output(out, istream, xslFilename, xmlEncoding, condition);

		istream.close();

		// MʂƂ肠Oɏo͂
		log.info(":\n--------------------\n" + out.toString());

		// HTMLۑ
		searchForm.setResult(out.toString());
		searchForm.setHits(hits);

		return mapping.findForward(ApConstant.FORWARD_SUCCESS);
	}
}
