/**
 * LOGICAL-PARADOX.ORG
 * Copyright (C)2004 satoshi akabane(akabane@logical-paradox.org)
 *
 */
package org.logical_paradox.kinako.action;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.util.MessageResources;
import org.logical_paradox.kinako.constant.ApConstant;
import org.logical_paradox.kinako.object.FailureTransitionException;

/**
 * ANV
 * @author satoshi akabane@logical-paradox.org
 * @version $Revision: 1.4 $
 */
public abstract class KinakoBaseAction extends Action {
	/**
	 * WbNs
	 * @param form ANVtH[
	 * @param mapping }bsO
	 * @param resource bZ[W\[X
	 * @return tH[h
	 */
	public abstract ActionForward executeLogic(ActionForm form, ActionMapping mapping, MessageResources resource) throws Exception;
	/**
	 * O
	 * ANVsOɉꍇC̃\bhI[o[Ch邱
	 * @param baseForm tH[
	 * @return true: / false:s
	 * @throws Exception ɔO
	 */
	public boolean preProcess(ActionForm baseForm) throws Exception {
		return true;
	}
	/**
	 * ㏈
	 * ANVsɉꍇC̃\bhI[o[Ch邱
	 * @param baseForm tH[
	 * @return true: / false:s
	 * @throws Exception ɔO
	 */
	public boolean postProcess(ActionForm baseForm) throws Exception {
		return true;
	}
	/**
	 * ANVs
	 * ǑĂяoCWbŇĂяoC㏈̌Ăяȍɏ
	 */
	@Override
	public final ActionForward execute(
		ActionMapping mapping,
		ActionForm form,
		HttpServletRequest request,
		HttpServletResponse response)
		throws Exception {

		// WbN
		ActionForward forward = null;
		try {
			// O
			if(preProcess(form) == false) {
				throw new FailureTransitionException();
			}
			forward = executeLogic(form, mapping, getResources(request));
			// ㏈
			if(postProcess(form) == false) {
				throw new FailureTransitionException();
			}
		} catch(FailureTransitionException e) {
			// G[J
			forward = mapping.findForward(ApConstant.FORWARD_FAILURE);
		}

		return forward;
	}
}
