<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" />
<jsp:directive.include file="/jsp/custom/result_info.jsp" />
<og:comment
	system	= "GE:エンジンサンプル"
	pgid	= "GE0002"
	title	= "画面"
	date	= "2007/12/12"
	author	= "K.HASEGAWA"
	text	= "ZZZZ"
	version	= "001"
>
	5.4.3.6 2012/01/19 add PARENT_GRP
	5.6.6.0 2013/07/05 ROLE検索方法変更
	5.6.9.2 2013/10/18 {@scope}対応
</og:comment>

<!-- ワーニングメッセージです。ここでは、登録完了のメッセージを表示します。 -->
<og:errorMessage command="{@command}" clear="{@clear}" displayMsg="{@displayMsg}" />

<og:columnCheck
	command	= "{@command}"
	columns	= "SYSTEM_ID,GUIKEY,NAME_JA,LONGNAME,ADDRESS"
/>

<!-- 取り消しボタンが押された時に必要です。 -->
<og:entry command="{@command}" />

<og:equals val1="{@FROMGUIKEY}" notNull="true">
	<og:value command="SQL">
		SELECT SEQNO AS FROMKEY FROM GEA11
		WHERE GUIKEY='{@FROMGUIKEY}'
		AND SYSTEM_ID IN ( '{@SYSTEM_ID}','{@REP.U_BASE}','**' )
		AND FGJ='1'	<!-- 7.2.8.0 (2020/09/04) -->
	</og:value>
	<og:value command="SQL">
		SELECT COALESCE ( MIN(SEQNO), 999999 ) AS TOKEY FROM GEA11
		WHERE SEQNO &gt; {@FROMKEY}
		AND GUILVL &lt;= '{@GUILVL}'
		AND SYSTEM_ID IN ( '{@SYSTEM_ID}','{@REP.U_BASE}','**' )
		AND FGJ='1'	<!-- 7.2.8.0 (2020/09/04) -->
	</og:value>
</og:equals>

<og:equals val1="{@USE_UPLOADFILE}{@command}" val2="trueNEW">
	<og:value key="scope" value="request" />
</og:equals>

<og:query command="{@command}" debug="{@debug}" dbid="{@FROM_DBID}" maxRowCount="{@maxRowCount}" scope="{@scope}">
	select
		'1' as WRITABLE,A.GUIKEY,A.ADDRESS,A.SEQNO,A.GUILVL,A.LABEL_CLM,A.GROUPS,'' as POP2
		,A.NAME_JA,B.LNAME,B.SNAME,A.ROLES,'' as POP1
		,A.RWMODE,A.KBLINK,A.TARGET,A.PARAM,B.DESCRIPTION,A.COMMENTS,A.SYSTEM_ID
		,A.KBSAKU,A.SUBSYS,A.RDC_CODE,A.RELEASE_NOTES,A.DYUPD,A.CDKH,A.FGJ,A.UNIQ
		,'' CLM,'3' as KBLBL
	from GEA11 A left outer join GEA08 B
			on	A.SYSTEM_ID	= B.SYSTEM_ID
			and	A.GUIKEY	= B.CLM
			and	A.KBSAKU	= B.KBSAKU
			and	B.LANG		= 'ja'
			and	B.FGJ		= '1'
	where A.SYSTEM_ID IN ( '{@SYSTEM_ID}','{@REP.BASE}','{@AST}' )
	<og:where startKey="and">
		<og:and value = "UPPER(A.GUIKEY)	like UPPER('{@GUIKEY}')"	/>
		<og:and value = "A.NAME_JA			like '{@NAME_JA}'"			/>
		<og:and value = "A.ADDRESS			like '{@ADDRESS}'"			/>
		<og:and value = "A.ROLES			like '{@ROLES}'"			/>
		<og:and value = "A.SEQNO BETWEEN {@FROMKEY} and {@TOKEY} - 1"	/>
		<og:and value = "A.KBSAKU			=    '{@KBSAKU}'"			/>
		<og:and value = "A.SUBSYS			like '{@SUBSYS}'"			/>
		<og:and value = "B.LNAME			like '{@LNAME}'"			/>
		<og:and value = "B.SNAME			like '{@SNAME}'"			/>
		<jsp:directive.include file="/jsp/custom/releaseNotesWhereA.jsp" />
	</og:where>
	<og:appear startKey="order by" value="{@ORDER_BY}"
				defaultVal="A.SEQNO,A.GUIKEY,A.ADDRESS,A.SYSTEM_ID DESC,A.KBSAKU DESC" />
</og:query>

<!-- tableFilter でラベル設定します。設定先が未設定の場合のみセットされます。 -->
<og:tableFilter classId="LABEL" keys="SYSTEM_ID,LANG,CLM,LRAW,SRAW,DISC" vals="{@SYSTEM_ID},ja,GUIKEY,LNAME,SNAME,DESCRIPTION" />

<og:columnEditor columns="SYSTEM_ID,GUIKEY,SEQNO,RWMODE" must="true" />
<og:columnEditor columns="DESCRIPTION,COMMENTS" clazz="W100"  renderer="SLABEL" param="50" />
<og:columnEditor columns="POP1,POP2"	label="" />	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->

<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
<og:value command="SET" key="param1" >
select ROLES,NMROLE from GEA05 where SYSTEM_ID=\'{@SYSTEM_ID}\' and FGJ=\'1\'
</og:value>

<og:viewMarker isRenderer="false"  command="NEW">
	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
	<og:columnMarker column="ROLES"  />
	<og:popup column="POP1" href="{@SYS.JSP}/custom/multiChoose.jsp" rtnKeys="ROLES"
			keys="name,SYSTEM_ID,editor,toVals,param"
			vals='ROLES,{@SYSTEM_ID},DBMENU,"[ROLES].value","{@param1}"'
			height="250px" width="520px" src="{@SYS.JSP_IMG}/multiChoose.gif" />

	<!-- 1.6.1 (2021/03/01) og:popup タグ化 -->
	<og:columnMarker column="GROUPS"  />
	<og:popup column="POP2" href="{@SYS.JSP}/custom/multiChoose.jsp" rtnKeys="GROUPS"
			keys="name,SYSTEM_ID,separator,toVals"
			vals='GROUPS,{@SYSTEM_ID},",","[GROUPS].value"'
			height="250px" width="520px" src="{@SYS.JSP_IMG}/multiChoose.gif" />
</og:viewMarker>

<!-- 7.2.8.0 (2020/09/04) RESOURCE_BASE_SYSTEM_ID 対応 -->
<og:viewMarker command="{@command}">
	<og:columnMarker columns="GUIKEY,ADDRESS,SYSTEM_ID,KBSAKU" onMark="[SYSTEM_ID]" markList="{@BASE}|{@AST}">
		<div style="background-color:#c1ffff;">[$1]</div>
	</og:columnMarker>
</og:viewMarker>

<og:viewLink command="{@command}">
	<og:link column="GUIKEY" gamenId="GE0005" href="index.jsp" target="CONTENTS"
		keys="command,SYSTEM_ID,BASE,AST,CLM,FGJ,LANG"
		vals="NEW,{@SYSTEM_ID},{@BASE},{@AST},[GUIKEY],1,ja" />
</og:viewLink>

<form method="POST" action="forward.jsp" target="RESULT" >
	<og:writeCheck>
		<og:equals val1="{@ACTION}" isNull="true">
			<og:input name="repeatCount" value="1" lbl="" td="false" size="2"/>
			<og:submit action="COPY" noWritable="null" />
			<og:equals val1="{@BASE}{@AST}" isNull="true" >
				<og:submit action="MODIFY" noWritable="SYSTEM_ID,GUIKEY,ADDRESS,KBSAKU,CDKH" />
				<og:submit action="DELETE" columnWritable="null" keys="logicalDelete" vals="true" />
				<og:submit action="DELETE" columnWritable="null" lbl="DELETE_PH" roles="DEL" accesskey="" />
			</og:equals>
			<span>　</span>
			<fieldset style="display:inline;" >
				<legend><strong><og:message lbl="INSERT_GEA11" /></strong></legend>
				<og:column  name="SYSTEM_ID" useRequestValue="false" td="no" />
				<og:submit action="COPY" noWritable="null" keys="sysins" vals="true" accesskey="" />
			</fieldset>
			<span>　</span>
			<!-- 8.0.0.0 表示順並び替えは、手動で行う -->
			<fieldset style="display:inline;" >
				<legend><strong><og:message lbl="UPDATE_SEQNO" /></strong></legend>
				<og:column name="START_NO"  size="5" td="no" />
				<og:column name="INCREMENT" size="5" td="no" />
				<og:column name="SEL_ALL" codeName="BOOLEAN" defaultVal="false" addNoValue="false" td="no" />
				<og:submit action="MODIFY" value="seqset" lbl="SEQNO" accesskey="" />
			</fieldset>
		</og:equals>
		<og:equals val1="{@ACTION}" val2="MINUS">
			<og:submit action="COPY"   noWritable="null" />
		</og:equals>
		<og:equals val1="{@ACTION}" val2="DIFFERENCE">
			<og:submit action="MODIFY" noWritable="SYSTEM_ID,GUIKEY,ADDRESS,KBSAKU,CDKH"  />
		</og:equals>
		<br />
	</og:writeCheck>

	<!-- ACTION が指定された場合は、tableMerge により積集合/差分集合を取得します。-->
	<og:equals val1="{@ACTION}" notNull="true">
		<og:query dbid="{@TO_DBID}" scope="request" quotCheck="false" maxRowCount="{@maxRowCount}" mainTrans="false">
			{@USER.LASTSQL}
		</og:query>

		<og:tableMerge
			action		= "{@ACTION}"
			masterScope	= "session"
			masterKeys	= "SYSTEM_ID,GUIKEY,ADDRESS,KBSAKU"
			diffKeys	= "SEQNO,NAME_JA,GUILVL,RWMODE,ROLES,KBLINK,TARGET,PARAM,GROUPS,LABEL_CLM,LNAME,SNAME"
			slaveScope	= "request"
			modifyClms	= "UNIQ"
			display		= "true"
		/>
	</og:equals>

	<og:view
		viewFormType	= "HTMLTable"
		command			= "{@command}"
		noDisplay		= "UNIQ,CLM,KBLBL"
		checked			= "{@checked}"
		startNo			= "{@startNo}"
		pageSize		= "{@pageSize}"
	/>

</form>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
