/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.internal.http;

import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.http.HttpResponse;
import com.ibm.cloud.objectstorage.internal.http.ErrorCodeParser;
import com.ibm.cloud.objectstorage.protocol.json.JsonContent;
import java.util.Arrays;

@SdkInternalApi
public class CompositeErrorCodeParser
implements ErrorCodeParser {
    private final Iterable<ErrorCodeParser> parsers;

    public CompositeErrorCodeParser(Iterable<ErrorCodeParser> parsers) {
        this.parsers = parsers;
    }

    public CompositeErrorCodeParser(ErrorCodeParser ... parsers) {
        this.parsers = Arrays.asList(parsers);
    }

    @Override
    public String parseErrorCode(HttpResponse response, JsonContent jsonContent) {
        for (ErrorCodeParser parser : this.parsers) {
            String errorCode = parser.parseErrorCode(response, jsonContent);
            if (errorCode == null) continue;
            return errorCode;
        }
        return null;
    }
}

