/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cloud.objectstorage.auth.profile.internal;

import com.ibm.cloud.objectstorage.SdkClientException;
import com.ibm.cloud.objectstorage.annotation.Immutable;
import com.ibm.cloud.objectstorage.annotation.SdkInternalApi;
import com.ibm.cloud.objectstorage.auth.AWSCredentials;
import com.ibm.cloud.objectstorage.auth.AWSCredentialsProvider;
import com.ibm.cloud.objectstorage.auth.BasicAWSCredentials;
import com.ibm.cloud.objectstorage.auth.BasicSessionCredentials;
import com.ibm.cloud.objectstorage.auth.profile.internal.BasicProfile;
import com.ibm.cloud.objectstorage.internal.StaticCredentialsProvider;
import com.ibm.cloud.objectstorage.oauth.BasicIBMOAuthCredentials;
import com.ibm.cloud.objectstorage.util.StringUtils;

@SdkInternalApi
@Immutable
public class ProfileStaticCredentialsProvider
implements AWSCredentialsProvider {
    private final BasicProfile profile;
    private final AWSCredentialsProvider credentialsProvider;

    public ProfileStaticCredentialsProvider(BasicProfile profile) {
        this.profile = profile;
        this.credentialsProvider = new StaticCredentialsProvider(this.fromStaticCredentials());
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.credentialsProvider.getCredentials();
    }

    @Override
    public void refresh() {
    }

    private AWSCredentials fromStaticCredentials() {
        if (!StringUtils.isNullOrEmpty(this.profile.getIBMApiKey())) {
            return new BasicIBMOAuthCredentials(this.profile.getIBMApiKey(), this.profile.getIBMServiceInstanceId());
        }
        if (StringUtils.isNullOrEmpty(this.profile.getAwsAccessIdKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Access Key ID is not specified.", this.profile.getProfileName()));
        }
        if (StringUtils.isNullOrEmpty(this.profile.getAwsSecretAccessKey())) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Secret Access Key is not specified.", this.profile.getAwsSecretAccessKey()));
        }
        if (this.profile.getAwsSessionToken() == null) {
            return new BasicAWSCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey());
        }
        if (this.profile.getAwsSessionToken().isEmpty()) {
            throw new SdkClientException(String.format("Unable to load credentials into profile [%s]: AWS Session Token is empty.", this.profile.getProfileName()));
        }
        return new BasicSessionCredentials(this.profile.getAwsAccessIdKey(), this.profile.getAwsSecretAccessKey(), this.profile.getAwsSessionToken());
    }
}

