/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.sahara.internal;

import com.google.common.base.Preconditions;
import java.util.List;
import org.openstack4j.api.sahara.JobExecutionService;
import org.openstack4j.model.common.ActionResponse;
import org.openstack4j.model.sahara.JobExecution;
import org.openstack4j.openstack.sahara.domain.SaharaJobExecution;
import org.openstack4j.openstack.sahara.domain.SaharaJobExecutionUnwrapped;
import org.openstack4j.openstack.sahara.internal.BaseSaharaServices;

public class JobExecutionServiceImpl
extends BaseSaharaServices
implements JobExecutionService {
    @Override
    public JobExecution create(JobExecution jobExecution) {
        Preconditions.checkNotNull((Object)jobExecution);
        SaharaJobExecutionUnwrapped unwrapped = new SaharaJobExecutionUnwrapped(jobExecution);
        return this.post(SaharaJobExecution.class, this.uri("/jobs/%s/execute", jobExecution.getJobIdForExecution())).entity(unwrapped).execute();
    }

    @Override
    public List<? extends JobExecution> list() {
        return this.get(SaharaJobExecution.JobExecutions.class, this.uri("/job-executions", new Object[0])).execute().getList();
    }

    @Override
    public JobExecution get(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(SaharaJobExecution.class, this.uri("/job-executions/%s", jobExecutionId)).execute();
    }

    @Override
    public JobExecution refreshStatus(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(SaharaJobExecution.class, this.uri("/job-executions/%s/refresh-status", jobExecutionId)).execute();
    }

    @Override
    public JobExecution cancel(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.get(SaharaJobExecution.class, this.uri("/job-executions/%s/cancel", jobExecutionId)).execute();
    }

    @Override
    public ActionResponse delete(String jobExecutionId) {
        Preconditions.checkNotNull((Object)jobExecutionId);
        return this.deleteWithResponse(this.uri("/job-executions/%s", jobExecutionId)).execute();
    }
}

