/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.openstack.barbican.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.util.Date;
import java.util.List;
import org.openstack4j.model.barbican.Secret;
import org.openstack4j.model.barbican.builder.SecretCreateBuilder;
import org.openstack4j.openstack.common.ListResult;

public class BarbicanSecret
implements Secret {
    private String name;
    @JsonProperty(value="algorithm")
    private String algorithm;
    @JsonProperty(value="bit_length")
    private int bitLength;
    @JsonProperty(value="content-types")
    private List<String> contentTypes;
    @JsonProperty(value="created")
    private Date createTime;
    @JsonProperty(value="updated")
    private Date updateTime;
    @JsonProperty(value="creator_id")
    private String creatorId;
    @JsonProperty(value="expiration")
    private String expiration;
    @JsonProperty(value="mode")
    private String mode;
    @JsonProperty(value="secret_ref")
    private String secretReference;
    @JsonProperty(value="secret_type")
    private String secretType;
    @JsonProperty(value="status")
    private String status;

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBitLength() {
        return this.bitLength;
    }

    @Override
    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    @Override
    public Date getCreateTime() {
        return this.createTime;
    }

    @Override
    public Date getUpdateTime() {
        return this.updateTime;
    }

    @Override
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    public String getExpiration() {
        return this.expiration;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getSecretReference() {
        return this.secretReference;
    }

    @Override
    public String getSecretType() {
        return this.secretType;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("algorithm", (Object)this.algorithm).add("bit_length", this.bitLength).add("content_types", this.contentTypes).add("created", (Object)this.createTime).add("creator_id", (Object)this.creatorId).add("expiration", (Object)this.expiration).add("mode", (Object)this.mode).add("name", (Object)this.name).add("secret_ref", (Object)this.secretReference).add("secret_type", (Object)this.secretType).add("status", (Object)this.status).add("updated", (Object)this.updateTime).toString();
    }

    @Override
    public SecretCreateBuilder toBuilder() {
        return new SecretCreateConcreteBuilder();
    }

    public static SecretCreateBuilder builder() {
        return new SecretCreateConcreteBuilder();
    }

    public static class SecretCreateConcreteBuilder
    implements SecretCreateBuilder {
        private BarbicanSecret internalSecret;

        public SecretCreateConcreteBuilder() {
            this(new BarbicanSecret());
        }

        public SecretCreateConcreteBuilder(BarbicanSecret secret) {
            this.internalSecret = secret;
        }

        @Override
        public SecretCreateBuilder name(String name) {
            this.internalSecret.name = name;
            return this;
        }

        @Override
        public Secret build() {
            return this.internalSecret;
        }

        @Override
        public SecretCreateBuilder from(Secret in) {
            this.internalSecret = (BarbicanSecret)in;
            return this;
        }
    }

    public static class Secrets
    extends ListResult<BarbicanSecret> {
        @JsonProperty(value="total")
        private int count;
        @JsonProperty(value="secrets")
        private List<BarbicanSecret> list;

        @Override
        protected List<BarbicanSecret> value() {
            return this.list;
        }

        public int getCount() {
            return this.count;
        }
    }
}

