/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.model.telemetry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.List;
import org.openstack4j.common.Buildable;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.BasicResource;
import org.openstack4j.model.telemetry.builder.AlarmBuilder;
import org.openstack4j.openstack.telemetry.domain.CeilometerAlarm;

public interface Alarm
extends ModelEntity,
BasicResource,
Buildable<AlarmBuilder> {
    public List<String> getAlarmActions();

    public String getAlarmId();

    public String getDescription();

    public boolean isEnabled();

    public void isEnabled(boolean var1);

    public List<String> getInsufficientDataActions();

    @Override
    public String getName();

    public List<String> getOkActions();

    public String getProjectId();

    public boolean getRepeatActions();

    public String getState();

    public String getStateTimestamp();

    public ThresholdRule getThresholdRule();

    public CombinationRule getCombinationRule();

    public String getTimestamp();

    public Type getType();

    public String getUserId();

    @Override
    public void setName(String var1);

    public void setType(Type var1);

    public void setUserId(String var1);

    public void setAlarmActions(List<String> var1);

    public void setDescription(String var1);

    public void setInsufficientDataActions(List<String> var1);

    public void setOkActions(List<String> var1);

    public void setRepeateActions(Boolean var1);

    public void setThresholdRule(CeilometerAlarm.CeilometerThresholdRule var1);

    public static interface ThresholdRule {
        public String getMeterName();

        public int getEvaluationPeriods();

        public Statistic getStatistic();

        public int getPeriod();

        public float getThreshold();

        public List<? extends Query> getQuery();

        public ComparisonOperator getComparisonOperator();

        public boolean getExcludeOutliers();

        public void setMeterName(String var1);

        public void setEvaluationPeriods(int var1);

        public void setStatistic(Statistic var1);

        public void setPeriod(int var1);

        public void setThreshold(float var1);

        public void setQuery(List<CeilometerAlarm.CeilometerQuery> var1);

        public void setComparisonOperator(ComparisonOperator var1);

        public void setExcludeOutliers(boolean var1);

        public static interface Query {
            public String getField();

            public String getValue();

            public ComparisonOperator getOp();

            public void setField(String var1);

            public void setValue(String var1);

            public void setOp(ComparisonOperator var1);
        }

        public static enum ComparisonOperator {
            LT,
            LE,
            EQ,
            NE,
            GE,
            GT,
            UNRECOGNIZED;


            @JsonValue
            public String value() {
                return this.name().toLowerCase();
            }

            public String toString() {
                return this.value();
            }

            @JsonCreator
            public static ComparisonOperator fromValue(String operator) {
                try {
                    return ComparisonOperator.valueOf(operator.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }
        }

        public static enum Statistic {
            MAX,
            MIN,
            AVG,
            SUM,
            COUNT,
            UNRECOGNIZED;


            @JsonValue
            public String value() {
                return this.name().toLowerCase();
            }

            public String toString() {
                return this.value();
            }

            @JsonCreator
            public static Statistic fromValue(String statistic) {
                try {
                    return Statistic.valueOf(statistic.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }
        }
    }

    public static interface CombinationRule {
        public List<String> getAlarmIds();

        public Operator getOperator();

        public void setAlarmIds(List<String> var1);

        public void setOperator(Operator var1);

        public static enum Operator {
            AND,
            OR,
            UNRECOGNIZED;


            @JsonValue
            public String value() {
                return this.name().toLowerCase();
            }

            public String toString() {
                return this.value();
            }

            @JsonCreator
            public static Operator fromValue(String operator) {
                try {
                    return Operator.valueOf(operator.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return UNRECOGNIZED;
                }
            }
        }
    }

    public static enum Type {
        THRESHOLD,
        COMBINATION,
        UNRECOGNIZED;


        @JsonValue
        public String value() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.value();
        }

        @JsonCreator
        public static Type fromValue(String type) {
            try {
                return Type.valueOf(type.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

