/*
 * Decompiled with CFR 0.152.
 */
package org.openstack4j.core.transport;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstack4j.api.EndpointTokenProvider;
import org.openstack4j.api.types.ServiceType;
import org.openstack4j.core.transport.Config;
import org.openstack4j.core.transport.HttpMethod;
import org.openstack4j.model.ModelEntity;
import org.openstack4j.model.common.Payload;

public class HttpRequest<R> {
    String endpoint;
    String path;
    Class<R> returnType;
    Object entity;
    String contentType = "application/json";
    HttpMethod method = HttpMethod.GET;
    String json;
    private Config config;
    private Map<String, List<Object>> queryParams;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private Function<String, String> endpointFunc;

    public HttpRequest() {
    }

    public HttpRequest(String endpoint, String path, HttpMethod method, ModelEntity entity, Class<R> returnType) {
        this.endpoint = endpoint;
        this.path = path;
        this.method = method;
        this.entity = entity;
    }

    public static RequestBuilder<Void> builder() {
        return new RequestBuilder<Void>(Void.class);
    }

    public static <R> RequestBuilder<R> builder(Class<R> returnType) {
        return new RequestBuilder<R>(returnType);
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEndpoint() {
        if (this.endpointFunc != null) {
            return (String)this.endpointFunc.apply((Object)this.endpoint);
        }
        return this.endpoint;
    }

    public String getPath() {
        return this.path;
    }

    public String getJson() {
        return this.json == null ? "" : this.json;
    }

    public boolean hasJson() {
        return this.json != null;
    }

    public Class<R> getReturnType() {
        return this.returnType;
    }

    public Object getEntity() {
        return this.entity;
    }

    public boolean hasQueryParams() {
        return this.queryParams != null && !this.queryParams.isEmpty();
    }

    public Map<String, List<Object>> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public boolean hasHeaders() {
        return !this.headers.isEmpty();
    }

    public RequestBuilder<R> toBuilder() {
        return new RequestBuilder(this);
    }

    public Config getConfig() {
        return this.config != null ? this.config : Config.DEFAULT;
    }

    public static final class RequestBuilder<R> {
        HttpRequest<R> request;
        EndpointTokenProvider provider;
        ServiceType service;

        public RequestBuilder(HttpRequest<R> request) {
            this.request = request;
        }

        public RequestBuilder(Class<R> returnType) {
            this.request = new HttpRequest();
            this.request.returnType = returnType;
        }

        public RequestBuilder<R> endpoint(String endpoint) {
            this.request.endpoint = endpoint;
            return this;
        }

        public RequestBuilder<R> path(String path) {
            this.request.path = path;
            return this;
        }

        public RequestBuilder<R> method(HttpMethod method) {
            this.request.method = method;
            return this;
        }

        public RequestBuilder<R> endpointFunction(Function<String, String> endpointFunc) {
            ((HttpRequest)this.request).endpointFunc = endpointFunc;
            return this;
        }

        public RequestBuilder<R> methodPut() {
            this.request.method = HttpMethod.PUT;
            return this;
        }

        public RequestBuilder<R> methodGet() {
            this.request.method = HttpMethod.GET;
            return this;
        }

        public RequestBuilder<R> methodDelete() {
            this.request.method = HttpMethod.DELETE;
            return this;
        }

        public RequestBuilder<R> methodPost() {
            this.request.method = HttpMethod.POST;
            return this;
        }

        public RequestBuilder<R> entity(ModelEntity entity) {
            this.request.entity = entity;
            return this;
        }

        public RequestBuilder<R> entity(Payload<?> entity) {
            if (entity != null) {
                this.request.entity = entity.open();
            }
            return this;
        }

        public RequestBuilder<R> config(Config config) {
            ((HttpRequest)this.request).config = config;
            return this;
        }

        public RequestBuilder<R> headers(Map<String, ? extends Object> headers) {
            this.request.getHeaders().putAll(headers);
            return this;
        }

        public RequestBuilder<R> header(String name, Object value) {
            this.request.getHeaders().put(name, value);
            return this;
        }

        public RequestBuilder<R> serviceType(ServiceType service) {
            this.service = service;
            return this;
        }

        public RequestBuilder<R> queryParam(String key, Object value) {
            if (value == null) {
                return this;
            }
            if (((HttpRequest)this.request).queryParams == null) {
                ((HttpRequest)this.request).queryParams = Maps.newHashMap();
            }
            if (((HttpRequest)this.request).queryParams.containsKey(key)) {
                List values = (List)((HttpRequest)this.request).queryParams.get(key);
                values.add(value);
            } else {
                ArrayList<Object> values = new ArrayList<Object>();
                values.add(value);
                ((HttpRequest)this.request).queryParams.put(key, values);
            }
            return this;
        }

        public RequestBuilder<R> updateQueryParam(String key, Object value) {
            if (value == null) {
                return this;
            }
            if (((HttpRequest)this.request).queryParams == null) {
                ((HttpRequest)this.request).queryParams = Maps.newHashMap();
            }
            ArrayList<Object> values = new ArrayList<Object>();
            values.add(value);
            ((HttpRequest)this.request).queryParams.put(key, values);
            return this;
        }

        public RequestBuilder<R> endpointTokenProvider(EndpointTokenProvider provider) {
            this.provider = provider;
            return this;
        }

        public RequestBuilder<R> json(String json) {
            this.request.json = json;
            return this;
        }

        public RequestBuilder<R> contentType(String contentType) {
            if (contentType != null) {
                this.request.contentType = contentType;
            }
            return this;
        }

        public HttpRequest<R> build() {
            if (this.provider != null) {
                this.request.endpoint = this.provider.getEndpoint(this.service);
                if (this.provider.getTokenId() != null) {
                    this.request.getHeaders().put("X-Auth-Token", this.provider.getTokenId());
                }
            }
            return this.request;
        }
    }
}

