/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.plugin.cloud;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.cloud.storage.CloudStorage;
import oracle.cloud.storage.CloudStorageConfig;
import oracle.cloud.storage.CloudStorageFactory;
import oracle.cloud.storage.exception.NoSuchContainerException;
import oracle.cloud.storage.model.QueryOption;
import oracle.cloud.storage.model.QueryResult;
import oracle.cloud.storage.model.StorageInputStream;
import org.apache.commons.lang3.StringUtils;
import org.opengion.fukurou.model.CloudFileOperation;
import org.opengion.fukurou.model.FileOperation;
import org.opengion.fukurou.model.FileOperationInfo;
import org.opengion.fukurou.util.Closer;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;
import org.opengion.hayabusa.common.HybsSystemException;

public class FileOperation_ORACLE
extends CloudFileOperation {
    private static final long serialVersionUID = 5108020190201L;
    private final CloudStorage oracleStorage;
    private final String PLUGIN = "oracle";

    public FileOperation_ORACLE(String string, String string2) {
        super(StringUtil.nval((String)string, (String)HybsSystem.sys((String)"CLOUD_BUCKET")), string2);
        this.setPlugin("oracle");
        CloudStorageConfig cloudStorageConfig = new CloudStorageConfig();
        String string3 = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_SERVICE_NAME");
        String string4 = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_USERNAME");
        String string5 = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_PASSWORD");
        String string6 = HybsSystem.sys((String)"CLOUD_STORAGE_ORACLE_SERVICEURL");
        this.initCheck(string3, string4, string5, string6);
        try {
            cloudStorageConfig.setServiceName(string3).setUsername(string4).setPassword(string5.toCharArray()).setServiceUrl(string6);
            this.oracleStorage = CloudStorageFactory.getStorage((CloudStorageConfig)cloudStorageConfig);
            try {
                this.oracleStorage.describeContainer(this.conBucket);
            }
            catch (NoSuchContainerException noSuchContainerException) {
                this.oracleStorage.createContainer(this.conBucket);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new HybsSystemException(malformedURLException.getMessage());
        }
    }

    private void initCheck(String string, String string2, String string3, String string4) {
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append("CLOUD_STORAGE_ORACLE_SERVICE_NAME");
        }
        if (StringUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_USERNAME");
        }
        if (StringUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_PASSWORD");
        }
        if (StringUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(",CLOUD_STORAGE_ORACLE_SERVICEURL");
        }
        if (stringBuilder.length() > 0) {
            throw new HybsSystemException("\u30af\u30e9\u30a6\u30c9\u30b9\u30c8\u30ec\u30fc\u30b8\u306e\u30ad\u30fc\u60c5\u5831(" + stringBuilder.toString() + ")\u304c\u30b7\u30b9\u30c6\u30e0\u30ea\u30bd\u30fc\u30b9\u306b\u767b\u9332\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
    }

    public void write(InputStream inputStream) throws IOException {
        try {
            this.oracleStorage.storeObject(this.conBucket, this.conPath, "application/octet-stream", inputStream);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("Oracle\u30b9\u30c8\u30ec\u30fc\u30b8\u306b\u66f8\u304d\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.conPath);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new IOException(stringBuilder.toString());
        }
    }

    public InputStream read() throws FileNotFoundException {
        StorageInputStream storageInputStream;
        try {
            storageInputStream = this.oracleStorage.retrieveObject(this.conBucket, this.conPath);
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append("Oracle\u30b9\u30c8\u30ec\u30fc\u30b8\u304b\u3089\u8aad\u307f\u8fbc\u307f\u304c\u5931\u6557\u3057\u307e\u3057\u305f\u3002path\uff1a").append(this.conPath);
            stringBuilder.append(" \u30b7\u30b9\u30c6\u30e0\u30a8\u30e9\u30fc\u60c5\u5831\uff1a").append(exception.getMessage());
            throw new FileNotFoundException(stringBuilder.toString());
        }
        return storageInputStream;
    }

    public boolean delete() {
        boolean bl = false;
        try {
            this.oracleStorage.deleteObject(this.conBucket, this.conPath);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String string) {
        boolean bl = false;
        InputStream inputStream = null;
        try {
            inputStream = this.read();
            FileOperation_ORACLE fileOperation_ORACLE = new FileOperation_ORACLE(this.conBucket, string);
            fileOperation_ORACLE.write(inputStream);
            bl = true;
        }
        catch (IOException iOException) {
        }
        finally {
            Closer.ioClose((Closeable)inputStream);
        }
        return bl;
    }

    public long length() {
        long l = 0L;
        try {
            l = this.oracleStorage.describeObject(this.conBucket, this.conPath).getSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public long lastModified() {
        long l = 0L;
        try {
            l = this.oracleStorage.describeObject(this.conBucket, this.conPath).getLastModified().getTime();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    public boolean isFile() {
        boolean bl = false;
        try {
            this.oracleStorage.describeObject(this.conBucket, this.conPath);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public boolean isDirectory() {
        boolean bl = false;
        if (StringUtil.isNull((String)this.conPath)) {
            return true;
        }
        HashMap<QueryOption, String> hashMap = new HashMap<QueryOption, String>();
        hashMap.put(QueryOption.PREFIX, this.setDirTail(this.conPath));
        List list = this.oracleStorage.listObjects(this.conBucket, hashMap);
        if (list.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public File[] listFiles(FileFilter fileFilter) {
        FileOperationInfo fileOperationInfo;
        String string;
        if (!this.exists()) {
            return new File[0];
        }
        String string2 = this.conPath;
        if (this.isDirectory()) {
            string2 = this.setDirTail(this.conPath);
        }
        ArrayList<FileOperationInfo> arrayList = new ArrayList<FileOperationInfo>();
        QueryResult queryResult = this.oracleStorage.listObjectsByPath(this.conBucket, "/", string2, null);
        for (Object object : queryResult.getKeys()) {
            string = object.getKey();
            fileOperationInfo = new FileOperationInfo("oracle", this.conBucket, string);
            fileOperationInfo.setLastModifiedValue(object.getLastModified().getTime());
            fileOperationInfo.setSize(object.getSize());
            fileOperationInfo.setFile(true);
            arrayList.add(fileOperationInfo);
        }
        for (Object object : queryResult.getPaths()) {
            string = this.rTrim((String)object, '/');
            fileOperationInfo = new FileOperationInfo("oracle", this.conBucket, string);
            fileOperationInfo.setDirectory(true);
            arrayList.add(fileOperationInfo);
        }
        File[] fileArray = this.filter(arrayList, fileFilter);
        return fileArray;
    }

    public FileOperation getParentFile() {
        return new FileOperation_ORACLE(this.conBucket, this.getParent());
    }
}

