/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.hayabusa.db;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengion.fukurou.security.HybsCryptography;
import org.opengion.fukurou.util.StringFormat;
import org.opengion.fukurou.util.StringUtil;
import org.opengion.hayabusa.common.HybsSystem;

public class DBEventColumn {
    private static final String EVENT_COLUMN_URL = HybsSystem.sys("JSP") + "/" + HybsSystem.sys("EVENT_COLUMN_URL");
    final String name;
    final String evCol;
    final String eventUrl;
    final String renderer;
    final String editor;
    final String rendParam;
    final String editParam;
    final boolean flgEncrypt;
    final Pattern trgPattern = Pattern.compile("(?<=\\{@)[^.]+?(?=\\})");
    HybsCryptography hc = null;

    public DBEventColumn(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        this.name = string;
        this.evCol = string2;
        this.eventUrl = string3 != null && string3.length() > 0 ? string3 : EVENT_COLUMN_URL;
        this.renderer = string4;
        this.editor = string5;
        this.rendParam = string6;
        this.editParam = string7;
        this.flgEncrypt = HybsSystem.sysBool("EVENT_SQL_ENCRYPT");
        if (this.flgEncrypt) {
            this.hc = new HybsCryptography();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getEventColumn() {
        return this.evCol;
    }

    public String getEventURL() {
        return this.eventUrl;
    }

    public String getRenderer() {
        return this.renderer;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getRendParam() {
        StringFormat stringFormat = new StringFormat(this.rendParam, "{@" + this.evColReplace(this.evCol).replace(",", "}:{@") + "}", this.name);
        if (this.flgEncrypt) {
            return this.hc.encrypt(stringFormat.format());
        }
        return stringFormat.format();
    }

    public String getEditParam() {
        StringFormat stringFormat = new StringFormat(this.editParam, "{@" + this.evColReplace(this.evCol).replace(",", "}:{@") + "}", this.name);
        if (this.flgEncrypt) {
            return this.hc.encrypt(stringFormat.format());
        }
        return stringFormat.format();
    }

    private String evColReplace(String string) {
        String[] stringArray = string != null && string.indexOf(44) >= 0 ? StringUtil.csv2Array((String)string, (char)',') : new String[]{string};
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].charAt(0) != '_') continue;
            stringArray[i] = stringArray[i].substring(1);
        }
        return StringUtil.array2csv((String[])stringArray);
    }

    private String getTrgCsv(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        Matcher matcher = this.trgPattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(matcher.group());
        }
        return stringBuilder.toString();
    }

    public String getRendParamKeys() {
        if (!this.flgEncrypt || this.rendParam == null || this.rendParam.length() == 0) {
            return "";
        }
        StringFormat stringFormat = new StringFormat(this.rendParam, "{@" + this.evColReplace(this.evCol).replace(",", "}:{@") + "}", this.name);
        return this.getTrgCsv(stringFormat.format());
    }

    public String getEditParamKeys() {
        if (!this.flgEncrypt || this.editParam == null || this.editParam.length() == 0) {
            return "";
        }
        StringFormat stringFormat = new StringFormat(this.editParam, "{@" + this.evColReplace(this.evCol).replace(",", "}:{@") + "}", this.name);
        return this.getTrgCsv(stringFormat.format());
    }

    public boolean isFlgEncrypt() {
        return this.flgEncrypt;
    }
}

