/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.auth;

import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import oracle.cloudstorage.api.IReply;
import oracle.cloudstorage.api.auth.IAuthReply;
import oracle.cloudstorage.api.header.Header;
import oracle.cloudstorage.api.reply.Reply;
import oracle.cloudstorage.text.Strings;

public class AuthReply
extends Reply
implements IAuthReply {
    private final String storageToken;
    private final String maskedToken;
    private final String storageUrl;
    private final long createdMillis;

    public AuthReply(Map<String, List<Object>> headers, int statusCode, String message, IReply.Context context) {
        super(headers, statusCode, message, context);
        this.storageToken = Header.storageToken.get(headers);
        this.maskedToken = AuthReply.mask(this.storageToken);
        this.storageUrl = Header.storageUrl.get(headers);
        this.createdMillis = System.currentTimeMillis();
    }

    public AuthReply(Map<String, ?> headers, int statusCode, String message, String token, String storageUrl, IReply.Context context) {
        super(headers, statusCode, message, context);
        this.storageToken = token;
        this.maskedToken = AuthReply.mask(token);
        this.storageUrl = storageUrl;
        this.createdMillis = System.currentTimeMillis();
    }

    private static String mask(String token) {
        try {
            return Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty(MASK_STORAGE_TOKEN)) ? token : (token == null ? null : Strings.md5(token));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getStorageToken() {
        return this.storageToken;
    }

    @Override
    public String getMaskedStorageToken() {
        return this.maskedToken;
    }

    @Override
    public String getStorageUrl() {
        return this.storageUrl;
    }

    @Override
    public boolean isOlderThan(IAuthReply that) {
        long thisAge = this.getAgeInMillis();
        long thatAge = that == null ? -1L : that.getAgeInMillis();
        return thisAge > thatAge;
    }

    @Override
    public long getAgeInMillis() {
        long age = System.currentTimeMillis() - this.createdMillis;
        return age;
    }

    @Override
    public String toString() {
        Date ageDate = new Date(this.getAgeInMillis());
        String age = new SimpleDateFormat("m:s.SSS").format(ageDate);
        return (Object)((Object)this.getStatus()) + ", token: " + this.getMaskedStorageToken() + ", url: " + this.getStorageUrl() + ", age: " + age;
    }
}

