/*
 * Decompiled with CFR 0.152.
 */
package org.opengion.fukurou.fileexec;

import com.sun.nio.file.ExtendedWatchEventModifier;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.function.BiConsumer;
import org.opengion.fukurou.fileexec.DirWatch;
import org.opengion.fukurou.fileexec.PathMatcherSet;
import org.opengion.fukurou.fileexec.XLogger;

public class FileWatch
implements Runnable {
    private static final XLogger LOGGER = XLogger.getLogger(FileWatch.class.getSimpleName());
    public static final WatchEvent.Kind<Path> CREATE = StandardWatchEventKinds.ENTRY_CREATE;
    public static final WatchEvent.Kind<Path> MODIFY = StandardWatchEventKinds.ENTRY_MODIFY;
    public static final WatchEvent.Kind<Path> DELETE = StandardWatchEventKinds.ENTRY_DELETE;
    public static final WatchEvent.Kind<?> OVERFLOW = StandardWatchEventKinds.OVERFLOW;
    private static final WatchEvent.Kind<?>[] WE_KIND = new WatchEvent.Kind[]{CREATE, MODIFY, DELETE, OVERFLOW};
    private static final WatchEvent.Modifier[] WE_MOD_ONE = new WatchEvent.Modifier[0];
    private static final WatchEvent.Modifier[] WE_MOD_TREE = new WatchEvent.Modifier[]{ExtendedWatchEventModifier.FILE_TREE};
    public static final String DIR_WATCH_EVENT = "DirWatch";
    public static final int STOP_WATI_TIME = 500;
    public static final int STOP_WATI_CNT = 5;
    private final Path dirPath;
    private final boolean useTree;
    private final WatchEvent.Modifier[] extModifiers;
    private BiConsumer<String, Path> action = (string, path) -> System.out.println("Event=" + string + " , Path=" + path);
    private WatchEvent.Kind<?>[] weKind = WE_KIND;
    private final PathMatcherSet pathMchSet = new PathMatcherSet();
    private final PathMatcherSet dirWatchMch = new PathMatcherSet();
    private boolean useDirWatch = true;
    private DirWatch dWatch;
    private Thread thread;
    private volatile boolean running;

    public FileWatch(Path path) {
        this(path, false);
    }

    public FileWatch(Path path2, boolean bl) {
        this.dirPath = path2;
        this.useTree = bl;
        this.extModifiers = bl ? WE_MOD_TREE : WE_MOD_ONE;
    }

    public void setEventKinds(WatchEvent.Kind<?> ... kindArray) {
        if (kindArray != null && kindArray.length > 0) {
            this.weKind = kindArray;
        }
    }

    public void setPathMatcher(PathMatcher pathMatcher) {
        this.pathMchSet.addPathMatcher(pathMatcher);
    }

    public void setPathEndsWith(String ... stringArray) {
        this.pathMchSet.addEndsWith(stringArray);
    }

    public void callback(BiConsumer<String, Path> biConsumer) {
        if (biConsumer != null) {
            this.action = biConsumer;
        }
    }

    public void setUseDirWatch(boolean bl) {
        this.useDirWatch = bl;
    }

    public void setDirWatchEndsWith(String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.useDirWatch = true;
            this.dirWatchMch.addEndsWith(stringArray);
        }
    }

    public boolean isErrorStatus() {
        return !this.running || this.dWatch != null && this.dWatch.isErrorStatus();
    }

    public void start() {
        int n = 0;
        while (this.running) {
            ++n;
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (n < 5) continue;
            LOGGER.warning(() -> "FileWatch Stop Error : [" + this.dirPath + "]");
        }
        this.running = true;
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
        if (this.useDirWatch) {
            this.dWatch = new DirWatch(this.dirPath, this.useTree);
            if (this.dirWatchMch.isEmpty()) {
                this.dWatch.setPathMatcher(this.pathMchSet);
            } else {
                this.dWatch.setPathMatcher(this.dirWatchMch);
            }
            this.dWatch.callback((Path path) -> this.action.accept(DIR_WATCH_EVENT, (Path)path));
            this.dWatch.start();
        }
    }

    public void stop() {
        this.running = false;
        if (this.thread != null) {
            this.thread.interrupt();
        }
        if (this.dWatch != null) {
            this.dWatch.stop();
            this.dWatch = null;
        }
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (IOException iOException) {
            String string = "FileWatch#run : Path=" + this.dirPath;
            LOGGER.warning(iOException, "MSG0102", string);
        }
        catch (Throwable throwable) {
            String string = "FileWatch#run : Path=" + this.dirPath;
            LOGGER.warning(throwable, "MSG0021", string);
        }
        finally {
            this.running = false;
            this.thread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws IOException {
        LOGGER.info(() -> "FileWatch Start: " + this.dirPath);
        FileSystem fileSystem = FileSystems.getDefault();
        try (WatchService watchService = fileSystem.newWatchService();){
            WatchKey watchKey = this.dirPath.register(watchService, this.weKind, this.extModifiers);
            try {
                boolean bl = true;
                while (bl && this.running) {
                    WatchKey watchKey2 = watchService.take();
                    if (watchKey.equals(watchKey2)) {
                        for (WatchEvent<?> watchEvent : watchKey2.pollEvents()) {
                            Path path = (Path)watchEvent.context();
                            if (path == null || !this.pathMchSet.matches(path)) continue;
                            Path path2 = this.dirPath.resolve(path);
                            Path path3 = this.dirPath;
                            synchronized (path3) {
                                if (this.dWatch == null || this.dWatch.setAdd(path2)) {
                                    this.action.accept(watchEvent.kind().name(), path2);
                                } else {
                                    LOGGER.info(() -> "WatchEvent Duplication: " + path2);
                                }
                            }
                        }
                    }
                    if (watchKey2 != null) {
                        watchKey2.reset();
                    }
                    if (this.dWatch != null) {
                        this.dWatch.setClear();
                    }
                    boolean bl2 = bl = watchKey.isValid() && !Thread.currentThread().isInterrupted();
                    if (watchKey.isValid()) continue;
                    LOGGER.warning(() -> "FileWatch No isValid : [" + this.dirPath + "]");
                }
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warning(() -> "FileWatch Canceled : [" + this.dirPath + "]");
            }
            finally {
                if (watchKey != null) {
                    watchKey.cancel();
                }
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LOGGER.warning(() -> "FileSystem close : [" + this.dirPath + "]");
        }
        catch (Throwable throwable) {
            String string = "FileWatch#execute : Path=" + this.dirPath;
            LOGGER.warning(throwable, "MSG0021", string);
        }
        LOGGER.info(() -> "FileWatch End : [" + this.dirPath + "]");
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.dirPath + " , DirWatch=[" + this.useDirWatch + "]";
    }
}

