<?xml version="1.0" encoding="UTF-8" ?>
<jsp:root
	xmlns:jsp="http://java.sun.com/JSP/Page"
	xmlns:og="hybs-taglib.tld"
	version="2.0">
<jsp:directive.page language="java" contentType="text/html; charset=UTF-8" />

<og:head headType="result" useChartJS="true" />

<jsp:directive.include file="/jsp/custom/result_info.jsp" />

	<!-- データは使いませんが、tableModelは必須 -->
	<og:query command="NEW" >
		SELECT    ''	VAL1
				, ''	VAL2
				, ''	VAL3
		FROM DUAL
		where 1 = 2
	</og:query>

	<og:jsChart
		chartType			= "line"
		labelColumn			= "VAL1"
		xscaleType			= "realtime"
		height				= "{@height}"
		width				= "{@width}"
		title				= "{@chartTitle}"
		titlePosition		= "{@titlePosition}"
		xlabel				= "{@xlabel}"
		optAxis				= "realtime:RT"
		optOptions			= "tooltips:{mode:'nearest',intersect: false},hover:{mode:'nearest',intersect: false}"
		debug				= "{@debug}"
	>
	var RT = {
		frameRate:	30,
		duration:   30000,
		refresh:	 5000,
		delay:		 5000,
		onRefresh: function(chart) {
	//		VAL1.push( Date.now() );
	//		VAL2.push( Math.random() * 10000 );
	//		VAL3.push( Math.random() * 10000 );
			chart.VAL1 = VAL1;
			chart.VAL2 = VAL2;
			chart.VAL3 = VAL3;
			updatechart( chart );
		}
	};

		<og:jsChartData
				chartColumn			= "VAL2"
				label				= "VAL2"
				max					= "12000"
				min					= "-1000"
				backgroundColor		= "blue"
		/>
		<og:jsChartData
				chartColumn			= "VAL3"
				label				= "VAL3"
				max					= "12000"
				min					= "-1000"
				backgroundColor		= "green"
		/>
	</og:jsChart>


<!-- エラー確認用 -->
エラー時の情報:
<div id="err"></div>

<script type="text/javascript">
	// 左の円形を選択時に、右の棒グラフを更新します。
	// ※ラベル名を利用しているため、重複したラベル名が存在する場合、正しく動作しません。
	var updatechart = function(_chart){

//_chart.VAL2.push( Math.random() );
//_chart.VAL3.push( Math.random() );

		// チャートの空白箇所クリック時の処理
		if( _chart ) {
			$.ajax({
				url:'sample15A_ajax.jsp',
				async:true, // 非同期通信
				type: 'GET',
				data: {'ENAME': 'KING'},
				dataType: 'json',
				success: function(jsn){
					for(var i=0; i&lt; jsn.DATA.length; i++){
						_chart.VAL2.push( parseInt( jsn.DATA[i].SALES ) );
						_chart.VAL3.push( parseInt( jsn.DATA[i].AMOUNT) );
					}
					_chart.VAL1.push( Date.now() );
					_chart.update();
				},
				error: function(err){
					$('#err').html(err.responseText);
				}
			});
		}
	}
</script>

<jsp:directive.include file="/jsp/common/htmlend.jsp" />
</jsp:root>
