/****************************************************************************/
/* SYSTEM_ID : GF                                                           */
/* PRJ_NAME ( FUNCTION )                                                    */
/* Created : 2021/06/29 14:04:12                                            */
/****************************************************************************/

CREATE 
FUNCTION PRJ_NAME(
	XPRJCODE       IN VARCHAR2 )
RETURN VARCHAR2
/**********************************************************************/
/* プロジェクト名称を求めるファンクションです。                       */
/*  PRJ_NAME( PRJCODE )                                               */
/*                                                                    */
/*	 PRJCODE  IN VARCHAR2    プロジェクトコード                       */
/*                                                                    */
/*	指定された値をキーに、GE62（プロジェクトマスタ定義）を検索し、    */
/*  名称(NAME)を取得して返します。                                    */
/*  JOIN で取得する代わりに、ファンクションで取得しています。         */
/*                                                                    */
/**********************************************************************/
IS
    RTN     VARCHAR2(1000);

BEGIN

	SELECT NAME_JA INTO RTN
	FROM GF62
	WHERE PRJCODE = XPRJCODE ;

	RETURN RTN;

END PRJ_NAME;
;
