/****************************************************************************/
/* GF73 ( 使用ｶﾗﾑ状態ﾃｰﾌﾞﾙ )                                                */
/*                                                                          */
/* Created : 2021/06/30 16:37:08                                            */
/****************************************************************************/

CREATE TABLE GF73 (
   SYSTEM_ID    VARCHAR2 (   10 )                       NOT NULL            /*  1 ｼｽﾃﾑID        */
 , TBLSYU       VARCHAR2 (    1 )                       NOT NULL            /*  2 ﾃｰﾌﾞﾙ種別     */
 , ADDRESS      VARCHAR2 (  256 )                                           /*  3 ｱﾄﾞﾚｽ         */
 , FILENAME     VARCHAR2 (   60 )                                           /*  4 ﾌｧｲﾙ名        */
 , FILEPATH     VARCHAR2 (  256 )                                           /*  5 ﾌｧｲﾙﾊﾟｽ       */
 , MODIFIED     VARCHAR2 (   14 )                                           /*  6 最終更新日    */
 , TAGNAME      VARCHAR2 (   30 )                                           /*  7 ﾀｸﾞ名称       */
 , FORM_TYPE    VARCHAR2 (   20 )                                           /*  8 ﾌｫｰﾑﾀｲﾌﾟ      */
 , FORM_NAME    VARCHAR2 (  500 )                                           /*  9 名称          */
 , FORM_VAL     VARCHAR2 ( 1000 )                                           /* 10 値            */
 , DEFAULT_VAL  VARCHAR2 (  100 )                                           /* 11 ﾃﾞﾌｫﾙﾄ値      */
 , LBLCD        VARCHAR2 (   60 )                                           /* 12 ﾗﾍﾞﾙｺｰﾄﾞ      */
 , MSGCD        VARCHAR2 (   20 )                                           /* 13 ﾒｯｾｰｼﾞID      */
 , MUST         VARCHAR2 (   20 )                                           /* 14 必須          */
 , VIEW_SIZE    VARCHAR2 (   20 )                                           /* 15 表示桁数      */
 , MAX_SIZE     VARCHAR2 (   20 )       DEFAULT 'NULL'                      /* 16 使用桁数      */
 , CODE_CLM     VARCHAR2 (   30 )                                           /* 17 ｺｰﾄﾞｶﾗﾑ       */
 , READONLY     VARCHAR2 (   20 )                                           /* 18 読取専用      */
 , DISABLED     VARCHAR2 (   20 )                                           /* 19 無効          */
 , ROLES        VARCHAR2 (  500 )                                           /* 20 ﾛｰﾙｽﾞ         */
 , TEXT_DATA    CLOB                                                        /* 21 ﾃｷｽﾄ          */
 , FGOMIT       VARCHAR2 (    1 )       DEFAULT '0'     NOT NULL            /* 22 除外ﾌﾗｸﾞ      */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0       NOT NULL            /* 23 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1'     NOT NULL            /* 24 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                           /* 25 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                           /* 26 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                           /* 27 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                           /* 28 作成社員      */
 , DYUPD        VARCHAR2 (   14 )                                           /* 29 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                           /* 30 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                           /* 31 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                           /* 32 更新者        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GF73S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF73T00 
  BEFORE INSERT ON GF73
  FOR EACH ROW 
  BEGIN 
    SELECT GF73S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
