/****************************************************************************/
/* GF71 ( 画面関連状態ﾃｰﾌﾞﾙ )                                               */
/*                                                                          */
/* Created : 2021/06/30 16:37:08                                            */
/****************************************************************************/

CREATE TABLE GF71 (
   SYSTEM_ID    VARCHAR2 (  10 )                    NOT NULL            /*  1 ｼｽﾃﾑID        */
 , TBLSYU       VARCHAR2 (   1 )                    NOT NULL            /*  2 ﾃｰﾌﾞﾙ種別     */
 , ADDRESS      VARCHAR2 ( 256 )                                        /*  3 ｱﾄﾞﾚｽ         */
 , FILENAME     VARCHAR2 (  60 )                                        /*  4 ﾌｧｲﾙ名        */
 , FILEPATH     VARCHAR2 ( 256 )                                        /*  5 ﾌｧｲﾙﾊﾟｽ       */
 , MODIFIED     VARCHAR2 (  14 )                                        /*  6 最終更新日    */
 , TAGNAME      VARCHAR2 (  30 )                                        /*  7 ﾀｸﾞ名称       */
 , TO_GAMENID   VARCHAR2 (  30 )                                        /*  8 先画面ID      */
 , HREF         VARCHAR2 ( 256 )                                        /*  9 ﾘﾝｸ先URL      */
 , TARGET       VARCHAR2 (  30 )                                        /* 10 ﾀｰｹﾞｯﾄ        */
 , CLM          VARCHAR2 (  30 )                                        /* 11 項目          */
 , P_KEYS       VARCHAR2 ( 500 )                                        /* 12 引数ｷｰ        */
 , P_VALS       VARCHAR2 ( 500 )                                        /* 13 引数値        */
 , USEGAMENID   VARCHAR2 (  20 )                                        /* 14 画面使用      */
 , USEREDIRECT  VARCHAR2 (  20 )                                        /* 15 ﾘﾀﾞｲﾚｸﾄ使用   */
 , TEXT_DATA    CLOB                                                    /* 16 ﾃｷｽﾄ          */
 , FGOMIT       VARCHAR2 (   1 )        DEFAULT '0' NOT NULL            /* 17 除外ﾌﾗｸﾞ      */
 , UNIQ         NUMBER   (   9 )        DEFAULT 0   NOT NULL            /* 18 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (   1 )        DEFAULT '1' NOT NULL            /* 19 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (  14 )                                        /* 20 登録日時      */
 , PGSET        VARCHAR2 (  10 )                                        /* 21 作成PG        */
 , PGPSET       VARCHAR2 (  10 )                                        /* 22 作成親PG      */
 , USRSET       VARCHAR2 (  10 )                                        /* 23 作成社員      */
 , DYUPD        VARCHAR2 (  14 )                                        /* 24 更新日時      */
 , PGUPD        VARCHAR2 (  10 )                                        /* 25 更新PG        */
 , PGPUPD       VARCHAR2 (  10 )                                        /* 26 更新親PG      */
 , USRUPD       VARCHAR2 (  10 )                                        /* 27 更新者        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 16K );


CREATE SEQUENCE GF71S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF71T00 
  BEFORE INSERT ON GF71
  FOR EACH ROW 
  BEGIN 
    SELECT GF71S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
