/****************************************************************************/
/* GF19 ( 予約語管理ﾃｰﾌﾞﾙ )                                                 */
/*                                                                          */
/* Created : 2021/06/30 16:37:08                                            */
/****************************************************************************/

CREATE TABLE GF19 (
   DBNAME       VARCHAR2 (   20 )                   NOT NULL            /*  1 DB名称        */
 , YOYAKU       VARCHAR2 (   60 )                   NOT NULL            /*  2 予約語        */
 , CDYOYAKU     VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /*  3 予約語種別    */
 , NAME_JA      VARCHAR2 (  200 )                                       /*  4 名称          */
 , ALTERNATE    VARCHAR2 ( 1000 )                                       /*  5 代替候補      */
 , CONTENTS     CLOB                                                    /*  6 内容          */
 , RANKCOM      VARCHAR2 (    1 )       DEFAULT '0' NOT NULL            /*  7 共通化ﾗﾝｸ     */
 , UNIQ         NUMBER   (    9 )       DEFAULT 0   NOT NULL            /*  8 ﾕﾆｰｸｷｰ        */
 , FGJ          VARCHAR2 (    1 )       DEFAULT '1' NOT NULL            /*  9 状態ﾌﾗｸﾞ      */
 , DYSET        VARCHAR2 (   14 )                                       /* 10 登録日時      */
 , PGSET        VARCHAR2 (   10 )                                       /* 11 作成PG        */
 , PGPSET       VARCHAR2 (   10 )                                       /* 12 作成親PG      */
 , USRSET       VARCHAR2 (   10 )                                       /* 13 作成社員      */
 , DYUPD        VARCHAR2 (   14 )                                       /* 14 更新日時      */
 , PGUPD        VARCHAR2 (   10 )                                       /* 15 更新PG        */
 , PGPUPD       VARCHAR2 (   10 )                                       /* 16 更新親PG      */
 , USRUPD       VARCHAR2 (   10 )                                       /* 17 更新者        */
)
TABLESPACE GETBL01
STORAGE( INITIAL 128K );


CREATE SEQUENCE GF19S00 
  INCREMENT BY 1 START WITH 1 MAXVALUE 999999999 CYCLE NOCACHE;


CREATE OR REPLACE TRIGGER GF19T00 
  BEFORE INSERT ON GF19
  FOR EACH ROW 
  BEGIN 
    SELECT GF19S00.NEXTVAL INTO :NEW.UNIQ FROM DUAL; 
  END; 
/
