/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* STRING_TO_HALF ( FUNCTION )                                              */
/* Created : 2021/07/01 16:05:57                                            */
/****************************************************************************/

CREATE 
FUNCTION STRING_TO_HALF(
    IN_STR IN VARCHAR2
)
-- ===========================================
--  全角カナ文字を半角に変換します。
-- https://www.projectgroup.info/tips/Oracle/function/F000010.html
-- ===========================================
RETURN VARCHAR2
AS
  result     VARCHAR2(32767);
BEGIN
  --変換対照の文字列を取得
  result := IN_STR;


  --濁点や半濁点の文字は個別に変換する
  result := REPLACE(result,'ガ','ｶﾞ');
  result := REPLACE(result,'ギ','ｷﾞ');
  result := REPLACE(result,'グ','ｸﾞ');
  result := REPLACE(result,'ゲ','ｹﾞ');
  result := REPLACE(result,'ゴ','ｺﾞ');

  result := REPLACE(result,'ザ','ｻﾞ');
  result := REPLACE(result,'ジ','ｼﾞ');
  result := REPLACE(result,'ズ','ｽﾞ');
  result := REPLACE(result,'ゼ','ｾﾞ');
  result := REPLACE(result,'ゾ','ｿﾞ');

  result := REPLACE(result,'ダ','ﾀﾞ');
  result := REPLACE(result,'ヂ','ﾁﾞ');
  result := REPLACE(result,'ヅ','ﾂﾞ');
  result := REPLACE(result,'デ','ﾃﾞ');
  result := REPLACE(result,'ド','ﾄﾞ');

  result := REPLACE(result,'バ','ﾊﾞ');
  result := REPLACE(result,'ビ','ﾋﾞ');
  result := REPLACE(result,'ブ','ﾌﾞ');
  result := REPLACE(result,'ベ','ﾍﾞ');
  result := REPLACE(result,'ボ','ﾎﾞ');

  result := REPLACE(result,'パ','ﾊﾟ');
  result := REPLACE(result,'ピ','ﾋﾟ');
  result := REPLACE(result,'プ','ﾌﾟ');
  result := REPLACE(result,'ペ','ﾍﾟ');
  result := REPLACE(result,'ポ','ﾎﾟ') ;

  --濁点、半濁点のない文字を置換
  RETURN TRANSLATE(result,'アイウエオカキクケコサシスセソタチツテトナニヌネノハヒフヘホマミムメモヤユヨラリルレロワヲンァィゥェォャュョッー'
                         ,'ｱｲｳｴｵｶｷｸｹｺｻｼｽｾｿﾀﾁﾂﾃﾄﾅﾆﾇﾈﾉﾊﾋﾌﾍﾎﾏﾐﾑﾒﾓﾔﾕﾖﾗﾘﾙﾚﾛﾜｦﾝｧｨｩｪｫｬｭｮｯｰ');

END;
;
