/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* GFP00001 ( PACKAGE BODY )                                                */
/* Created : 2021/07/01 16:06:06                                            */
/****************************************************************************/

CREATE 
PACKAGE BODY GFP00001 AS
/*******************************************************************************
*	ｼｽﾃﾑ			:	フレームワーク雛形
*	ﾌﾟﾛｸﾞﾗﾑID		:	GFP00001
*	処理名			:	共通ＳＰサンプル
*	作成日			:	2007/09/01
*	作成者			:	XXXXXXXXX
*	更新日/更新者	:
*	更新内容		:
*******************************************************************************/
PROCEDURE GF00001 (
	 PO_STATUS		OUT				NUMBER										-- ｽﾃｰﾀｽ(0:正常 1:異常)
	,PO_ERRMSGS		IN OUT			ERR_MSG_ARRAY								-- ｴﾗｰﾒｯｾｰｼﾞ配列
	,PI_PGPID		IN				VARCHAR2									-- ｼﾞｮﾌﾞIDor画面ID
	,PI_GYOU		IN				VARCHAR2									-- 行番号
	,PI_SYSTEM_ID	IN				VARCHAR2									-- ｼｽﾃﾑID
	,PI_LANG		IN				VARCHAR2									-- 言語
	,PI_CLM			IN				VARCHAR2									-- ｶﾗﾑ名
	,PI_NAME_JA		IN				VARCHAR2									-- 名称（漢字）
	,PI_LABEL_NAME	IN				VARCHAR2									-- 表示名称
	,PI_KBSAKU		IN				VARCHAR2									-- 作成区分
	,PI_CDTAN		IN				VARCHAR2									-- 担当者
	,PI_USER		IN				VARCHAR2									-- ﾕｰｻﾞｰ
)
IS
/*******************************************************************************
*	変数宣言
*******************************************************************************/
	-- 定数定義
	CON_PGID		CONSTANT	VARCHAR2(10)  := 'GFP00001';					-- ﾌﾟﾛｸﾞﾗﾑID
	CON_PGPID		CONSTANT	VARCHAR2(10)  := PI_PGPID;						-- ｼﾞｮﾌﾞIDor画面ID
	CON_SYSDATE		CONSTANT	VARCHAR2(14)  := TO_CHAR(SYSDATE,'YYYYMMDDHH24MISS');	-- ｼｽﾃﾑ日付
	CON_USER		CONSTANT	VARCHAR2(8)	  := PI_USER;						-- ﾕｰｻﾞｰ

	--ｴﾗｰﾒｯｾｰｼﾞ配列の初期件数設定
	CON_STRT_ERRIDX	CONSTANT	NUMBER        := CASE WHEN PO_ERRMSGS IS NULL THEN 1 ELSE PO_ERRMSGS.COUNT+1 END;

	-- 必須変数定義
	G_ERRSTP					VARCHAR2(1000)	:= NULL;						-- ｴﾗｰﾒｯｾｰｼﾞ
	G_DISP_KEY					VARCHAR2(1000)	:= NULL;						-- ｷｰ項目
	G_RTN						BOOLEAN;										-- ﾘﾀｰﾝ値
	G_KEKKA						NUMBER;											-- 処理結果(0:正常 1:警告 2:異常)

	-- ｻﾌﾞﾌﾟﾛｸﾞﾗﾑ
	FUNCTION	ERROR_CHECK	RETURN BOOLEAN;
	FUNCTION	GF41_INSERT_RTN RETURN BOOLEAN;
/*******************************************************************************
*	ERROR_CHECK 入力ｴﾗｰﾁｪｯｸ
*******************************************************************************/
FUNCTION ERROR_CHECK
RETURN BOOLEAN
IS
	L_COUNT	NUMBER	:= 0;
BEGIN
	G_ERRSTP:='ERR_CHARCK';

	RETURN TRUE;
END ERROR_CHECK;
/*******************************************************************************
*	GF41_INSERT_RTN ｶﾗﾑ定義追加処理
*******************************************************************************/
FUNCTION GF41_INSERT_RTN
RETURN BOOLEAN
IS
	L_UNIQ			NUMBER(9);
	L_COUNT			NUMBER(9);
BEGIN

	G_ERRSTP		:= 'GF41_INSERT_RTN';

	G_ERRSTP		:= 'GF41_INSERT_RTN_INS';
	INSERT INTO GF41 (
		 SYSTEM_ID																-- ｼｽﾃﾑID
		,LANG																	-- 言語
		,CLM																	-- 項目
		,NAME_JA																-- 名称（漢字）
		,LABEL_NAME																-- 表示名称
		,KBSAKU																	-- 作成区分
		,CDTAN																	-- 担当者
		,FGJ																	-- 状態F
		,DYSET																	-- 作成日時
		,PGSET																	-- 作成PG
		,PGPSET																	-- 作成呼出PG
		,USRSET																	-- 作成ﾕｰｻﾞｰ
		,DYUPD																	-- 更新日時
		,PGUPD																	-- 更新PG
		,PGPUPD																	-- 更新呼出PG
		,USRUPD																	-- 更新ﾕｰｻﾞｰ
	)
	VALUES (
		 PI_SYSTEM_ID															-- ｼｽﾃﾑID
		,PI_LANG																-- 言語
		,PI_CLM																	-- 項目
		,PI_NAME_JA																-- 名称（漢字）
		,PI_LABEL_NAME															-- 表示名称
		,PI_KBSAKU																-- 作成区分
		,PI_CDTAN																-- 担当者
		,'1'																	-- 状態F
		,CON_SYSDATE															-- 作成日時
		,CON_PGID																-- 作成PG
		,CON_PGPID																-- 作成呼出PG
		,CON_USER																-- 作成ﾕｰｻﾞｰ
		,CON_SYSDATE															-- 更新日時
		,CON_PGID																-- 更新PG
		,CON_PGPID																-- 更新呼出PG
		,CON_USER																-- 更新ﾕｰｻﾞｰ
	);

	RETURN TRUE;

END GF41_INSERT_RTN;
/*******************************************************************************
*   ﾒｲﾝ処理
*******************************************************************************/
BEGIN
	G_ERRSTP:='GFP00001_S';

	-- ｽﾃｰﾀｽ(1:異常)
	PO_STATUS := 1;

	G_DISP_KEY := ' SYSTEM_ID='|| PI_SYSTEM_ID||
				  ' LANG='|| PI_LANG||
				  ' CLM='|| PI_CLM;

	--ｴﾗｰﾁｪｯｸ
	G_RTN := ERROR_CHECK;

	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大,CON_STRT_ERRIDXは配列の開始番号)
	G_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS,CON_STRT_ERRIDX);

	-- 処理結果判定
	IF G_KEKKA < 2 THEN
		G_RTN := GF41_INSERT_RTN;
	END IF;

	G_ERRSTP:='GFP00001_E';
	-- 処理結果(ｴﾗｰﾒｯｾｰｼﾞ配列のｴﾗｰ結果の最大,CON_STRT_ERRIDXは配列の開始番号)
	G_KEKKA	:= HYBS.GET_MAX_KEKKA(PO_ERRMSGS,CON_STRT_ERRIDX);

	-- KEKKAが0,1の時はｽﾃｰﾀｽ(0:正常)、KEKKAが2の時はｽﾃｰﾀｽ(1:異常)
	PO_STATUS := CASE WHEN G_KEKKA < 2 THEN 0 ELSE 1 END;
/*******************************************************************************
*   例外処理
*******************************************************************************/
EXCEPTION
	-- ｵﾗｸﾙｴﾗｰ
	WHEN OTHERS THEN
		HYBS.SET_ERRMSGS2(PO_ERRMSGS											-- ｴﾗｰﾒｯｾｰｼﾞ配列
						,PI_GYOU												-- 行番号
						,2														-- ｴﾗｰ結果(0:正常 1:警告 2:異常)
						,CON_PGID 												-- ﾌﾟﾛｸﾞﾗﾑID
						,G_ERRSTP												-- ｴﾗｰ発生箇所(ｽﾃｯﾌﾟ)
						,TO_CHAR(SQLCODE)										-- ｵﾗｸﾙｴﾗｰｺｰﾄﾞ
						,SUBSTRB(SQLERRM,1,1000)								-- ｵﾗｸﾙｴﾗｰﾒｯｾｰｼﾞ
						,G_DISP_KEY												-- ｷｰ項目
						);
		--親SPはIF(STATUS=9)でｴﾗｰを拾ってHYBS.END_PROCEDUREをRAISEして下さい。
		PO_STATUS := 9;

END GF00001;
END GFP00001;
;
