/****************************************************************************/
/* SYSTEM_ID : GE                                                           */
/* WARN ( FUNCTION )                                                        */
/* Created : 2021/07/01 16:06:09                                            */
/****************************************************************************/

CREATE 
FUNCTION WARN(
	XDYSTART   IN VARCHAR2 ,
	XDURATION  IN NUMBER   ,
	XCOMPLETE  IN NUMBER  )
RETURN VARCHAR2
/**********************************************************************/
/* タスクの警告判定を行います。                                       */
/*  WARN( DYSTART,DURATION,COMPLETE )                                 */
/*                                                                    */
/*	 DYSTART   IN VARCHAR2           開始日                           */
/*	 DURATION  IN NUMBER             期間                             */
/*	 COMPLETE  IN NUMBER             進捗度                           */
/*                                                                    */
/*		リターン値   0:正常  1:注意  2:警告                           */
/*                                                                    */
/*	今日の日付けを元に、開始日、期間、進捗度に対応した警告の値を      */
/*	返します。                                                        */
/*                                                                    */
/*		0:正常                                                        */
/*           進捗度 100% または、開始日が来ていない場合               */
/*                                                                    */
/*		1:注意                                                        */
/*           進捗度が 100% 未満で、かつ、期間が過ぎていない場合       */
/*                                                                    */
/*		2:警告                                                        */
/*           進捗度が 0% で、開始日が来たか、                         */
/*           または、進捗度 100% 未満で、期間が過ぎた場合             */
/*                                                                    */
/*     --------|-----------|-----------                               */
/*        ↑        ↑         ↑                                     */
/*      0:正常    1:注意     2:警告                                   */
/**********************************************************************/
IS
    RTN     VARCHAR2(1);
	COMP	NUMBER(5);

BEGIN
	COMP := TO_DATE( SUBSTRB(XDYSTART,1,8),'YYYYMMDD' ) - TRUNC(SYSDATE,'DD') ;

	IF COMP > 0 OR XCOMPLETE = 100  THEN
		RTN := '0';
	ELSIF ( COMP + XDURATION ) >= 0 AND XCOMPLETE < 100 THEN
		RTN := '1';
	ELSIF ( COMP < 0 AND XCOMPLETE = 0 ) OR
		   (( COMP + XDURATION ) < 0 AND XCOMPLETE < 100 ) THEN
		RTN := '2';
	END IF ;

	RETURN RTN;

END WARN;
;
